﻿using System.Linq;
using Mall.Common.API;
using Microsoft.AspNetCore.Mvc;
using Mall.WebApi.Filter;
using Microsoft.AspNetCore.Cors;
using Mall.Module.MarketingCenter;
using Newtonsoft.Json;
using Mall.Model.Query;
using System;
using Mall.Common.Plugin;
using System.Collections.Generic;
using Mall.Model.Extend.MarketingCenter;
using Newtonsoft.Json.Linq;

namespace Mall.WebApi.Controllers.MarketingCenter
{
    [Route("api/[controller]/[action]")]
    [ApiExceptionFilter]
    [ApiController]
    [EnableCors("AllowCors")]
    public class TemplateController : BaseController
    {
        private readonly Module.MarketingCenter.MiniprogramTemplateModule templateModule = new MiniprogramTemplateModule();


        #region 模板管理
        /// <summary>
        /// 添加修改模板
        /// </summary>
        /// <returns></returns>
        public ApiResult SetMiniTemplate()
        {
            var extModel = JsonConvert.DeserializeObject<RB_Miniprogram_Template_Extend>(RequestParm.msg.ToString());
            extModel.TenantId = RequestParm.TenantId;
            extModel.MallBaseId = RequestParm.MallBaseId;
            if (extModel.ComponentDataList != null && extModel.ComponentDataList.Count > 0)
            {
                extModel.TemplateData = JsonConvert.SerializeObject(extModel.ComponentDataList);
            }
            Int32.TryParse(RequestParm.uid, out int Uid);
            extModel.CreateBy = Uid;
            extModel.CreateDate = DateTime.Now;
            extModel.Status = 0;
            var flag = templateModule.SetMiniprogramTemplateModule(extModel);
            return flag ? ApiResult.Success(data:extModel.Id) : ApiResult.Failed();
        }

        /// <summary>
        /// 获取模板
        /// </summary>
        /// <returns></returns>
        public ApiResult GetMiniTemplate()
        {
            JObject parms = JObject.Parse(RequestParm.msg.ToString());
            var Id = parms.GetInt("Id");
            var result = templateModule.GetMiniprogramTemplateModule(Id);
            return ApiResult.Success(data: result);
        }

        /// <summary>
        /// 删除用户中心自定义菜单
        /// </summary>
        /// <returns></returns>
        public ApiResult RemoveMiniTemplate()
        {
            JObject parms = JObject.Parse(RequestParm.msg.ToString());
            var Id = parms.GetInt("Id", 0);
            var Status = parms.GetInt("Status", 1);
            var flag = templateModule.RemoveMiniprogramTemplateModule(Id, Status);
            return flag ? ApiResult.Success() : ApiResult.Failed();
        }

        /// <summary>
        /// 获取分销商等级分页列表
        /// </summary>
        /// <returns></returns>
        [HttpPost]
        public ApiResult GetMiniTemplatePageList()
        {
            var parms = RequestParm;
            ResultPageModel pagelist = JsonConvert.DeserializeObject<ResultPageModel>(parms.msg.ToString());
            var  query = JsonConvert.DeserializeObject<RB_Miniprogram_Template_Extend>(parms.msg.ToString());
            query.TenantId = Convert.ToInt32(parms.uid);
            query.MallBaseId = parms.MallBaseId;

            var list = templateModule.GetMiniprogramTemplatePageListModule(pagelist.pageIndex, pagelist.pageSize, out long count, query);
            pagelist.count = Convert.ToInt32(count);
            pagelist.pageData = list;
            return ApiResult.Success("", pagelist);
        }
        #endregion
    }
}