﻿using VT.FW.DB;
using System;
using System.Collections.Generic;
using Mall.Model.Entity.MarketingCenter;

namespace Mall.Model.Extend.MarketingCenter
{
    /// <summary>
    /// 小程序模板扩展实体表
    /// </summary>
    [Serializable]
    [DB(ConnectionName = "DefaultConnection")]
    public class RB_Miniprogram_Template_Extend : RB_Miniprogram_Template
    {
        /// <summary>
        /// 自定义模板编号【查询使用】
        /// </summary>
        public string QIds { get; set; }

        /// <summary>
        /// 创建时间字符串
        /// </summary>
        public string CreateDateStr
        {
            get
            {
                string str = "";
                if (this.CreateDate != null)
                {
                    str = Convert.ToDateTime(this.CreateDate).ToString("yyyy-MM-dd HH:mm:ss");
                }
                return str;
            }
        }

        /// <summary>
        /// 前端组件
        /// </summary>
        public List<ComponentItem> ComponentDataList { get; set; }
    }

    /// <summary>
    /// 组件项
    /// </summary>
    public class ComponentItem
    {
        /// <summary>
        /// 组件Id
        /// </summary>
        public string Id { get; set; }

        /// <summary>
        /// 是否选中
        /// </summary>
        public bool isCked { get; set; }

        /// <summary>
        /// 组件JSON数据
        /// </summary>
        public object data { get; set; }
    }

    /// <summary>
    /// 背景组件
    /// </summary>
    public class backgroundItem
    {
        /// <summary>
        /// 背景颜色
        /// </summary>
        public string backgroundColor { get; set; }

        /// <summary>
        /// 背景高度
        /// </summary>
        public int backgroundHeight { get; set; }

        /// <summary>
        /// 背景图片地址
        /// </summary>
        public string backgroundPicUrl { get; set; }

        /// <summary>
        /// 背景宽度
        /// </summary>
        public int backgroundWidth { get; set; }

        /// <summary>
        /// 填充方式
        /// </summary>
        public int mode { get; set; }

        /// <summary>
        /// 图片位置
        /// </summary>
        public int position { get; set; }

        /// <summary>
        /// 是否显示背景图片
        /// </summary>
        public bool showImg { get; set; }
    }

    /// <summary>
    /// 搜索插件
    /// </summary>
    public class searchItem
    {
        /// <summary>
        /// 搜索框颜色
        /// </summary>
        public string color { get; set; }

        /// <summary>
        /// 背景颜色
        /// </summary>
        public string background { get; set; }

        /// <summary>
        /// 圆角
        /// </summary>
        public int radius { get; set; }

        /// <summary>
        /// 提示文字
        /// </summary>
        public string placeholder { get; set; }

        /// <summary>
        /// 文字颜色
        /// </summary>
        public string textColor { get; set; }

        /// <summary>
        /// 文字位置
        /// </summary>
        public string textPosition { get; set; }

        /// <summary>
        /// 左边距
        /// </summary>
        public string left { get; set; }

        /// <summary>
        /// 右边距
        /// </summary>
        public string right { get; set; }

        /// <summary>
        /// 上边距
        /// </summary>
        public string top { get; set; }

        /// <summary>
        /// 下边距
        /// </summary>
        public string bottom { get; set; }

        /// <summary>
        /// 搜索框位置(0-默认，1-顶部)
        /// </summary>
        public int searchPosition { get; set; }
    }

    /// <summary>
    /// 导航组件
    /// </summary>
    public class navItem
    {
        /// <summary>
        /// 颜色
        /// </summary>
        public string color { get; set; }

        /// <summary>
        /// 每页行数
        /// </summary>
        public int rows { get; set; }

        /// <summary>
        /// 每行个数
        /// </summary>
        public int columns { get; set; }

        /// <summary>
        /// 左右滑动
        /// </summary>
        public bool scroll { get; set; }

        /// <summary>
        /// 导航图标
        /// </summary>
        public List<navIconItem> navs { get; set; }

        /// <summary>
        /// 背景图片
        /// </summary>
        public bool showImg { get; set; }

        /// <summary>
        /// 背景颜色
        /// </summary>
        public string backgroundColor { get; set; }

        /// <summary>
        /// 背景链接
        /// </summary>
        public string backgroundPicUrl { get; set; }

        /// <summary>
        /// 图片位置
        /// </summary>
        public int position { get; set; }

        /// <summary>
        /// 填充方式
        /// </summary>
        public int mode { get; set; }

        /// <summary>
        /// 背景图宽
        /// </summary>
        public int backgroundHeight { get; set; }

        /// <summary>
        /// 背景图高
        /// </summary>
        public int backgroundWidth { get; set; }
    }

    /// <summary>
    /// 导航页面组件
    /// </summary>
    public class navPageItem
    {
        /// <summary>
        /// 颜色
        /// </summary>
        public string color { get; set; }

        /// <summary>
        /// 每页行数
        /// </summary>
        public int rows { get; set; }

        /// <summary>
        /// 每行个数
        /// </summary>
        public int columns { get; set; }

        /// <summary>
        /// 左右滑动
        /// </summary>
        public bool scroll { get; set; }

        /// <summary>
        /// 导航类型(1-导航模式,2-Tab模式)
        /// </summary>
        public int navType { get; set; }

        /// <summary>
        /// 导航图标
        /// </summary>
        public List<navPageIconItem> navs { get; set; }

        /// <summary>
        /// 背景图片
        /// </summary>
        public bool showImg { get; set; }

        /// <summary>
        /// 背景颜色
        /// </summary>
        public string backgroundColor { get; set; }

        /// <summary>
        /// 背景链接
        /// </summary>
        public string backgroundPicUrl { get; set; }

        /// <summary>
        /// 图片位置
        /// </summary>
        public int position { get; set; }

        /// <summary>
        /// 填充方式
        /// </summary>
        public int mode { get; set; }

        /// <summary>
        /// 背景图宽
        /// </summary>
        public int backgroundHeight { get; set; }

        /// <summary>
        /// 背景图高
        /// </summary>
        public int backgroundWidth { get; set; }
    }

    /// <summary>
    /// 导航图标页面明细
    /// </summary>
    public class navPageIconItem
    {
        /// <summary>
        /// 导航图标
        /// </summary>
        public string icon { get; set; }

        /// <summary>
        /// 导航名称
        /// </summary>
        public string name { get; set; }

        /// <summary>
        /// 组件方式(0-组件，1-模板)
        /// </summary>
        public int ShowType { get; set; }

        /// <summary>
        /// 组件URL
        /// </summary>
        public string url { get; set; }

        /// <summary>
        /// 组件名称
        /// </summary>
        public string ComponentName { get; set; }

        /// <summary>
        /// 模板编号
        /// </summary>
        public int TemplateId { get; set; }

        /// <summary>
        /// 显示名称
        /// </summary>
        public string TemplateShowName { get; set; }

        /// <summary>
        /// 模板数据
        /// </summary>
        public object TemplateData { get; set; }

        /// <summary>
        /// 是否显示
        /// </summary>
        public int isShow { get; set; }
    }


    /// <summary>
    /// 导航图标明细
    /// </summary>
    public class navIconItem
    {
        /// <summary>
        /// 导航图标
        /// </summary>
        public string icon { get; set; }

        /// <summary>
        /// 导航名称
        /// </summary>
        public string name { get; set; }

        /// <summary>
        /// 导链接
        /// </summary>
        public string url { get; set; }

        /// <summary>
        /// 打开方式(默认新页面打开)
        /// </summary>
        public string openType { get; set; }

        /// <summary>
        /// diy
        /// </summary>
        public string key { get; set; }
    }

    /// <summary>
    /// 轮播广告插件
    /// </summary>
    public class bannerItem
    {
        /// <summary>
        /// 样式
        /// </summary>
        public int style { get; set; }

        /// <summary>
        /// 填充方式0-留白 1填充
        /// </summary>
        public int fill { get; set; }

        /// <summary>
        /// 默认高度
        /// </summary>
        public int height { get; set; }

        /// <summary>
        /// 轮播图
        /// </summary>
        public List<bannerDetailItem> banners { get; set; }

        /// <summary>
        /// 圆角
        /// </summary>
        public string radius { get; set; }

        /// <summary>
        /// 上下边距
        /// </summary>
        public string topAndBottom { get; set; }

        /// <summary>
        /// 左右边距
        /// </summary>
        public string leftAndRight { get; set; }

        /// <summary>
        /// 背景颜色
        /// </summary>
        public string background { get; set; }

        /// <summary>
        /// 是否显示导航标题(1-显示，0-不显示)
        /// </summary>
        public int isShowTitle { get; set; }
    }

    /// <summary>
    /// 轮播图明细
    /// </summary>
    public class bannerDetailItem
    {
        /// <summary>
        /// 轮播图图片
        /// </summary>
        public string picUrl { get; set; }

        /// <summary>
        /// 轮播图链接
        /// </summary>
        public string url { get; set; }

        /// <summary>
        /// 打开方式
        /// </summary>
        public string openType { get; set; }

        /// <summary>
        /// 链接标题
        /// </summary>
        public string title { get; set; }
    }

    /// <summary>
    /// 公告组件
    /// </summary>
    public class noticeItem
    {
        /// <summary>
        /// 公告名称
        /// </summary>
        public string name { get; set; }

        /// <summary>
        /// 公告内容
        /// </summary>
        public string content { get; set; }

        /// <summary>
        /// 公告ICON
        /// </summary>
        public string icon { get; set; }

        /// <summary>
        /// 公告文字颜色
        /// </summary>
        public string textColor { get; set; }

        /// <summary>
        /// 公告文字背景颜色
        /// </summary>
        public string background { get; set; }

        /// <summary>
        /// 公告文字headerUrl
        /// </summary>
        public string headerUrl { get; set; }

        /// <summary>
        /// 按钮颜色
        /// </summary>
        public string btnColor { get; set; }

        /// <summary>
        /// 按钮宽度
        /// </summary>
        public int btnWidth { get; set; }

        /// <summary>
        /// 按钮高度
        /// </summary>
        public int btnHeight { get; set; }

        /// <summary>
        /// 按钮圆角
        /// </summary>
        public int btnRadius { get; set; }

        /// <summary>
        /// 按钮文字
        /// </summary>
        public string btnText { get; set; }

        /// <summary>
        /// 按钮文字颜色
        /// </summary>
        public string btnTextColor { get; set; }
    }

    /// <summary>
    /// 专题插件
    /// </summary>
    public class topicItem
    {
        /// <summary>
        /// 专题样式
        /// </summary>
        public string style { get; set; }

        /// <summary>
        /// 显示行数
        /// </summary>
        public int count { get; set; }

        /// <summary>
        /// logo(1行)
        /// </summary>
        public string logo_1 { get; set; }

        /// <summary>
        /// logo(2行)
        /// </summary>
        public string logo_2 { get; set; }

        /// <summary>
        /// 专题标签
        /// </summary>
        public string icon { get; set; }

        /// <summary>
        /// 是否显示分类
        /// </summary>
        public bool cat_show { get; set; }

        /// <summary>
        /// 专题列表
        /// </summary>
        public List<topicDetailsItem> topic_list { get; set; }

        /// <summary>
        /// 专题分类列表
        /// </summary>
        public List<topicTypeItem> list { get; set; }
    }

    /// <summary>
    /// 专题分类
    /// </summary>
    public class topicTypeItem
    {
        /// <summary>
        /// 分类Id
        /// </summary>
        public int cat_id { get; set; }

        /// <summary>
        /// 分类名称
        /// </summary>
        public string cat_name { get; set; }

        /// <summary>
        /// 分类名称
        /// </summary>
        public string name { get; set; }

        /// <summary>
        ///  自定义专题(1-是)
        /// </summary>
        public int custom { get; set; }

        /// <summary>
        /// 专题数量
        /// </summary>
        public int number { get; set; }

        /// <summary>
        /// 专题分类列表
        /// </summary>
        public List<topicDetailsItem> children { get; set; }
    }

    /// <summary>
    /// 专题列表详情
    /// </summary>
    public class topicDetailsItem
    {
        /// <summary>
        /// 专题标题
        /// </summary>
        public string title { get; set; }

        /// <summary>
        /// 专题封面图
        /// </summary>
        public string cover_pic { get; set; }

        /// <summary>
        /// 专题阅读数量
        /// </summary>
        public int read_count { get; set; }

        /// <summary>
        /// layout
        /// </summary>
        public int layout { get; set; }

        /// <summary>
        /// 专题Id
        /// </summary>
        public int id { get; set; }
    }

    /// <summary>
    /// 标题组件
    /// </summary>
    public class linkItem
    {
        /// <summary>
        /// 标题
        /// </summary>
        public string title { get; set; }

        /// <summary>
        /// 标题样式
        /// </summary>
        public string style { get; set; }

        /// <summary>
        /// 字体大小
        /// </summary>
        public string fontSize { get; set; }

        /// <summary>
        /// 标题位置
        /// </summary>
        public string position { get; set; }

        /// <summary>
        /// 样式颜色
        /// </summary>
        public string styleColor { get; set; }

        /// <summary>
        /// 链接
        /// </summary>
        public linkDetailItem link { get; set; }

        /// <summary>
        /// 图标开关
        /// </summary>
        public bool picSwitch { get; set; }

        /// <summary>
        /// 箭头开关
        /// </summary>
        public bool arrowsSwitch { get; set; }

        /// <summary>
        /// 图标地址
        /// </summary>
        public string picUrl { get; set; }

        /// <summary>
        /// 文字颜色
        /// </summary>
        public string color { get; set; }

        /// <summary>
        /// 背景颜色
        /// </summary>
        public string background { get; set; }
    }

    /// <summary>
    /// 链接明细
    /// </summary>
    public class linkDetailItem
    {
        /// <summary>
        /// 链接名称
        /// </summary>
        public string name { get; set; }

        /// <summary>
        /// 链接URL
        /// </summary>
        public string url { get; set; }
    }

    /// <summary>
    /// 图片广告插件
    /// </summary>
    public class rubikItem
    {
        /// <summary>
        /// 样式-选取几张图
        /// </summary>
        public int style { get; set; }

        /// <summary>
        /// 图片件间隔
        /// </summary>
        public int space { get; set; }

        /// <summary>
        /// 选中的第几张图 对应的style_list里的height
        /// </summary>
        public string height { get; set; }

        /// <summary>
        /// 选中的第几张图 对应的style_list里的w
        /// </summary>
        public string w { get; set; }

        /// <summary>
        /// 选中的第几张图 对应的style_list里的h
        /// </summary>
        public int h { get; set; }

        /// <summary>
        /// 热区划分
        /// </summary>
        public List<hotspotItem> hotspot { get; set; }

        /// <summary>
        /// 选中的第几张图的小区域对应的数据
        /// </summary>
        public List<rubikDetailItem> list { get; set; }

        /// <summary>
        /// 左边距
        /// </summary>
        public string left { get; set; }

        /// <summary>
        /// 右边距
        /// </summary>
        public string right { get; set; }

        /// <summary>
        /// 上边距
        /// </summary>
        public string top { get; set; }

        /// <summary>
        /// 下边距
        /// </summary>
        public string bottom { get; set; }

        /// <summary>
        /// 背景颜色
        /// </summary>
        public string background { get; set; }
    }

    /// <summary>
    /// 图片广告详情
    /// </summary>
    public class rubikDetailItem
    {
        /// <summary>
        /// 背景颜色
        /// </summary>
        public string backgroundColor { get; set; }

        public int numberX { get; set; }

        public int numberY { get; set; }

        public int x { get; set; }
        public int y { get; set; }
        public int w { get; set; }
        public int h { get; set; }

        /// <summary>
        /// 图片导航链接
        /// </summary>
        public List<rubikLinkItem> link { get; set; }

        /// <summary>
        /// 宽度
        /// </summary>
        public string width { get; set; }

        /// <summary>
        /// 高度
        /// </summary>
        public string height { get; set; }

        /// <summary>
        /// 左
        /// </summary>
        public string left { get; set; }

        /// <summary>
        /// 顶部
        /// </summary>
        public string top { get; set; }

        public string pic_url { get; set; }

        public string backgroundImage { get; set; }

        public string backgroundRepeat { get; set; }

        public string backgroundSize { get; set; }

        /// <summary>
        /// 背景图片位置
        /// </summary>
        public string backgroundPosition { get; set; }

        public int zIndex { get; set; }
    }

    /// <summary>
    /// 链接地址
    /// </summary>
    public class rubikLinkItem
    {
        /// <summary>
        /// 页面路径
        /// </summary>
        public string PageUrl { get; set; }

        /// <summary>
        /// 是否有参数
        /// </summary>
        public int IsParameter { get; set; }

        /// <summary>
        /// 参数值
        /// </summary>
        public string ParameterValue { get; set; }

        /// <summary>
        /// 页面名称
        /// </summary>
        public string PageName { get; set; }

        /// <summary>
        /// App前端使用
        /// </summary>
        public string new_link_url { get; set; }
    }

    /// <summary>
    /// 热区
    /// </summary>
    public class hotspotItem
    {
        /// <summary>
        /// 热区高度
        /// </summary>
        public int height { get; set; }

        /// <summary>
        /// 热区宽度
        /// </summary>
        public int width { get; set; }

        /// <summary>
        /// 热区左
        /// </summary>
        public int left { get; set; }

        /// <summary>
        /// 热区上
        /// </summary>
        public int top { get; set; }

        /// <summary>
        /// 开始点X
        /// </summary>
        public int defaultX { get; set; }

        /// <summary>
        /// 开始点Y
        /// </summary>
        public int defaultY { get; set; }

        /// <summary>
        /// 是否关闭
        /// </summary>
        public bool is_close { get; set; }

        /// <summary>
        /// 热区链接
        /// </summary>
        public List<rubikLinkItem> link { get; set; }

        /// <summary>
        /// 打开方式
        /// </summary>
        public string open_type { get; set; }
    }

    /// <summary>
    /// 视频插件
    /// </summary>
    public class videoItem
    {
        /// <summary>
        /// 图片地址
        /// </summary>
        public string pic_url { get; set; }

        /// <summary>
        /// 视频地址
        /// </summary>
        public string url { get; set; }

        /// <summary>
        /// 上边距
        /// </summary>
        public string top { get; set; }

        /// <summary>
        /// 下边距
        /// </summary>
        public string bottom { get; set; }

        /// <summary>
        /// 左边距
        /// </summary>
        public string left { get; set; }

        /// <summary>
        /// 右边距
        /// </summary>
        public string right { get; set; }

        /// <summary>
        /// 是否全屏
        /// </summary>
        public bool isfullscreen { get; set; }

        /// <summary>
        /// 背景图
        /// </summary>
        public string backgroundimage { get; set; }

        /// <summary>
        /// 圆角
        /// </summary>
        public string radius { get; set; }
    }

    /// <summary>
    /// 商品插件
    /// </summary>
    public class goodsItem
    {
        /// <summary>
        /// 显示分类
        /// </summary>
        public bool showCat { get; set; }

        /// <summary>
        /// 分类栏位置
        /// </summary>
        public string catPosition { get; set; }

        /// <summary>
        /// 分类样式
        /// </summary>
        public int catStyle { get; set; }

        /// <summary>
        /// 商品添加方式【0-自动添加,1-手动添加】
        /// </summary>
        public int addGoodsType { get; set; }

        /// <summary>
        /// 商品数量
        /// </summary>
        public int goodsLength { get; set; }

        /// <summary>
        /// 列表样式[-1-列表模式,0-左右滑动,1-一行一个,2-一行两个3-一行三个  4-教育模式]
        /// </summary>
        public int listStyle { get; set; }

        /// <summary>
        /// 商品封面图宽高比例[1-1]
        /// </summary>
        public string goodsCoverProportion { get; set; }

        /// <summary>
        /// 商品封面图填充
        /// </summary>
        public int fill { get; set; }

        /// <summary>
        /// 商品样式
        /// </summary>
        public int goodsStyle { get; set; }

        /// <summary>
        /// 文本样式
        /// </summary>
        public int textStyle { get; set; }

        /// <summary>
        /// 显示商品名称
        /// </summary>
        public bool showGoodsName { get; set; }

        /// <summary>
        /// 显示商品价格
        /// </summary>
        public bool showGoodsPrice { get; set; }

        /// <summary>
        /// 显示购买按钮
        /// </summary>
        public bool showBuyBtn { get; set; }

        /// <summary>
        /// 购买按钮样式[cart]
        /// </summary>
        public string buyBtn { get; set; }

        /// <summary>
        /// 购买按钮文字样式
        /// </summary>
        public int buyBtnStyle { get; set; }

        /// <summary>
        /// 购买按钮文字
        /// </summary>
        public string buyBtnText { get; set; }

        /// <summary>
        /// 购买按钮颜色
        /// </summary>
        public string buttonColor { get; set; }

        /// <summary>
        /// 显示评分    ld  2020-10-13
        /// </summary>
        public bool showScore { get; set; }

        /// <summary>
        /// 评分颜色
        /// </summary>
        public string scoreColor { get; set; }

        /// <summary>
        /// 显示商品角标
        /// </summary>
        public bool showGoodsTag { get; set; }

        /// <summary>
        /// 商品角标自定义
        /// </summary>
        public bool customizeGoodsTag { get; set; }

        /// <summary>
        /// 商品角标链接
        /// </summary>
        public string goodsTagPicUrl { get; set; }

        /// <summary>
        /// 是否显示图片背景
        /// </summary>
        public bool showImg { get; set; }

        /// <summary>
        /// 背景颜色
        /// </summary>
        public string backgroundColor { get; set; }

        /// <summary>
        /// 背景链接
        /// </summary>
        public string backgroundPicUrl { get; set; }

        /// <summary>
        ///  背景图片位置
        /// </summary>
        public int position { get; set; }


        /// <summary>
        ///  填充方式
        /// </summary>
        public int mode { get; set; }

        /// <summary>
        ///  背景高
        /// </summary>
        public int backgroundHeight { get; set; }

        /// <summary>
        ///  背景宽
        /// </summary>
        public int backgroundWidth { get; set; }

        /// <summary>
        /// 分类列表
        /// </summary>
        public List<catItem> catList { get; set; }

        /// <summary>
        /// 商品列表
        /// </summary>
        public List<GoodsDetailsItem2> list { get; set; }
    }

    /// <summary>
    /// 商品详情项
    /// </summary>
    public class GoodsDetailsItem2
    {
        /// <summary>
        /// 商品编号
        /// </summary>
        public int id { get; set; }

        /// <summary>
        /// 商品名称
        /// </summary>
        public string name { get; set; }

        /// <summary>
        /// 商品图片
        /// </summary>
        public string picUrl { get; set; }

        /// <summary>
        /// 售价
        /// </summary>
        public decimal price { get; set; }

        /// <summary>
        /// 【原价】前端使用
        /// </summary>
        public decimal OriginalPrice { get; set; }

        /// <summary>
        /// 课程评分  2020-10-13  ld 
        /// </summary>
        public decimal courseScore { get; set; }
    }

    /// <summary>
    /// 商品分类
    /// </summary>
    public class catItem
    {
        /// <summary>
        /// 分类编号
        /// </summary>
        public int id { get; set; }

        /// <summary>
        /// 商品分类
        /// </summary>
        public string name { get; set; }

        /// <summary>
        /// 菜单名称
        /// </summary>
        public string menuName { get; set; }

        /// <summary>
        /// 商品数量
        /// </summary>
        public int goodsNum { get; set; }

        /// <summary>
        /// 是否显示自定义商品
        /// </summary>
        public bool staticGoods { get; set; }

        /// <summary>
        /// 商品列表
        /// </summary>
        public List<GoodsDetailsItem2> goodsList { get; set; }
    }


    /// <summary>
    /// 门店插件
    /// </summary>
    public class storeItem
    {
        /// <summary>
        /// 导航图标
        /// </summary>
        public string navPicUrl { get; set; }

        /// <summary>
        /// 评分图标
        /// </summary>
        public string scorePicUrl { get; set; }

        /// <summary>
        /// 显示门店名称
        /// </summary>
        public bool showName { get; set; }

        /// <summary>
        /// 显示评分
        /// </summary>
        public bool showScore { get; set; }

        /// <summary>
        /// 显示电话
        /// </summary>
        public bool showTel { get; set; }

        /// <summary>
        /// 门店列表
        /// </summary>
        public List<storeDetailItem> list { get; set; }
    }

    /// <summary>
    /// 门店详情
    /// </summary>
    public class storeDetailItem
    {
        /// <summary>
        /// 门店编号
        /// </summary>
        public int id { get; set; }

        /// <summary>
        /// 门店名称
        /// </summary>
        public string name { get; set; }

        /// <summary>
        /// 电话
        /// </summary>
        public string mobile { get; set; }

        /// <summary>
        /// 门店封面图
        /// </summary>
        public string CoverImg { get; set; }
    }

    /// <summary>
    /// 版权插件
    /// </summary>
    public class copyrightItem
    {
        /// <summary>
        /// 图片
        /// </summary>
        public string picUrl { get; set; }

        /// <summary>
        /// 版权文字
        /// </summary>
        public string text { get; set; }

        /// <summary>
        /// 版权背景颜色
        /// </summary>
        public string backgroundColor { get; set; }

        /// <summary>
        /// 链接地址
        /// </summary>
        public string link { get; set; }
    }

    /// <summary>
    /// 签到插件
    /// </summary>
    public class checkinItem
    {
        /// <summary>
        /// 背景图
        /// </summary>
        public string backgroundPicUrl { get; set; }

        /// <summary>
        /// 显示文字
        /// </summary>
        public bool showText { get; set; }

        /// <summary>
        /// 文字位置
        /// </summary>
        public string textPosition { get; set; }

        /// <summary>
        /// 文本颜色
        /// </summary>
        public string textColor { get; set; }

        /// <summary>
        /// 点击热区
        /// </summary>
        public checkInHotSpot hotspot { get; set; }
    }

    /// <summary>
    /// 签到热区
    /// </summary>
    public class checkInHotSpot
    {
        /// <summary>
        /// 高度
        /// </summary>
        public int height { get; set; }

        /// <summary>
        /// 宽度
        /// </summary>
        public int width { get; set; }

        /// <summary>
        /// 左边距
        /// </summary>
        public int left { get; set; }

        /// <summary>
        /// 上边距
        /// </summary>
        public int top { get; set; }

        /// <summary>
        /// 起始点X坐标
        /// </summary>
        public int defaultX { get; set; }

        /// <summary>
        /// 起始点Y坐标
        /// </summary>
        public int defaultY { get; set; }

        /// <summary>
        /// 显示文字
        /// </summary>
        public bool is_close { get; set; }

        /// <summary>
        /// 链接地址
        /// </summary>
        public string link { get; set; }

        /// <summary>
        /// 页面打开方式
        /// </summary>
        public string open_type { get; set; }
    }

    /// <summary>
    /// 用户信息插件
    /// </summary>
    public class userinfoItem
    {
        /// <summary>
        /// 样式
        /// </summary>
        public int style { get; set; }

        /// <summary>
        /// 背景图片
        /// </summary>
        public string backgroundPicUrl { get; set; }

        /// <summary>
        /// 背景颜色
        /// </summary>
        public string backgroundColor { get; set; }
    }

    /// <summary>
    /// 用户订单插件
    /// </summary>
    public class userorderItem
    {
        /// <summary>
        /// 用户订单导航
        /// </summary>
        public List<userorderNav> navs { get; set; }

        /// <summary>
        /// 背景颜色
        /// </summary>
        public string backgroundColor { get; set; }
    }

    /// <summary>
    /// 用户订单导航详细
    /// </summary>
    public class userorderNav
    {
        /// <summary>
        /// 链接
        /// </summary>
        public string url { get; set; }

        /// <summary>
        /// openType【navigate】
        /// </summary>
        public string openType { get; set; }

        /// <summary>
        /// 图片地址
        /// </summary>
        public string picUrl { get; set; }

        /// <summary>
        /// 链接文件
        /// </summary>
        public string text { get; set; }
    }

    /// <summary>
    /// 地图插件
    /// </summary>
    public class mapItem
    {
        /// <summary>
        /// 经纬度
        /// </summary>
        public string location { get; set; }

        /// <summary>
        /// 地图高度
        /// </summary>
        public int height { get; set; }

        /// <summary>
        /// 上下边距
        /// </summary>
        public int paddingY { get; set; }

        /// <summary>
        /// 左右边距
        /// </summary>
        public int paddingX { get; set; }

        /// <summary>
        /// 顶部外边距
        /// </summary>
        public int marginTop { get; set; }

        /// <summary>
        ///  外边距颜色
        /// </summary>
        public string marginTopColor { get; set; }

        /// <summary>
        ///  背景颜色
        /// </summary>
        public string backgroundColor { get; set; }

        /// <summary>
        ///  背景图片
        /// </summary>
        public string backgroundPicUrl { get; set; }
    }

    /// <summary>
    /// 微信公众号插件
    /// </summary>
    public class mplinkItem
    {
        /// <summary>
        ///  位置auto
        /// </summary>
        public string position { get; set; }
    }

    /// <summary>
    /// 图文插件
    /// </summary>
    public class imagetextItem
    {
        /// <summary>
        /// 图文内容
        /// </summary>
        public string content { get; set; }
    }

    /// <summary>
    /// 优惠券插件
    /// </summary>
    public class couponItem
    {
        /// <summary>
        /// 字体颜色
        /// </summary>
        public string textColor { get; set; }

        /// <summary>
        /// 不可领取
        /// </summary>
        public string receiveBg { get; set; }

        /// <summary>
        /// 可领取
        /// </summary>
        public string unclaimedBg { get; set; }

        /// <summary>
        /// showImg
        /// </summary>
        public bool showImg { get; set; }

        /// <summary>
        /// 背景颜色
        /// </summary>
        public string backgroundColor { get; set; }

        /// <summary>
        /// 背景图片
        /// </summary>
        public string backgroundPicUrl { get; set; }

        /// <summary>
        /// 背景图片位置
        /// </summary>
        public int position { get; set; }

        /// <summary>
        /// 填充方式
        /// </summary>
        public int mode { get; set; }

        /// <summary>
        /// 背景高度
        /// </summary>
        public int backgroundHeight { get; set; }

        /// <summary>
        /// 背景宽度
        /// </summary>
        public int backgroundWidth { get; set; }
    }

    /// <summary>
    /// 倒计时插件
    /// </summary>
    public class timerItem
    {
        /// <summary>
        /// 图片
        /// </summary>
        public string picUrl { get; set; }

        /// <summary>
        /// 开始时间
        /// </summary>
        public string startDateTime { get; set; }

        /// <summary>
        /// 结束时间
        /// </summary>
        public string endDateTime { get; set; }

        /// <summary>
        /// 链接
        /// </summary>
        public timerLink link { get; set; }

    }

    /// <summary>
    /// 倒计时链接
    /// </summary>
    public class timerLink
    {
        /// <summary>
        /// 链接
        /// </summary>
        public string url { get; set; }

        /// <summary>
        /// 打开类型
        /// </summary>
        public string openType { get; set; }
    }

    /// <summary>
    /// 拼团插件
    /// </summary>
    public class pintuanItem
    {
        /// <summary>
        /// 按钮颜色
        /// </summary>
        public string buttonColor { get; set; }

        /// <summary>
        /// 列表样式(-1-列表模式,1-一行一个,2-一行两个)
        /// </summary>
        public int listStyle { get; set; }

        /// <summary>
        /// 文本样式(1-左对齐,2-居中)
        /// </summary>
        public int textStyle { get; set; }

        /// <summary>
        /// 商品封面图填充(1-填充,2-留白)
        /// </summary>
        public int fill { get; set; }

        /// <summary>
        /// 商品封面图宽高比例(1-1;3-2)
        /// </summary>
        public string goodsCoverProportion { get; set; }

        /// <summary>
        /// 商品样式(1-白底无边框,2-白底有边框,3-无底无边框)
        /// </summary>
        public int goodsStyle { get; set; }

        /// <summary>
        /// 显示商品名称
        /// </summary>
        public bool showGoodsName { get; set; }

        /// <summary>
        /// 显示购买按钮
        /// </summary>
        public bool showBuyBtn { get; set; }

        /// <summary>
        /// 购买按钮样式(1-填充,2-线条,3-圆角填充,4-圆角线条)
        /// </summary>
        public int buyBtnStyle { get; set; }

        /// <summary>
        /// 购买按钮文字
        /// </summary>
        public string buyBtnText { get; set; }

        /// <summary>
        /// 显示商品角标
        /// </summary>
        public bool showGoodsTag { get; set; }

        /// <summary>
        /// 自定义商品角标
        /// </summary>
        public bool customizeGoodsTag { get; set; }

        /// <summary>
        /// 商品角标图片
        /// </summary>
        public string goodsTagPicUrl { get; set; }

        /// <summary>
        /// 背景颜色
        /// </summary>
        public string backgroundColor { get; set; }

        /// <summary>
        /// 背景图
        /// </summary>
        public string backgroundPicUrl { get; set; }

        /// <summary>
        /// 图片位置
        /// </summary>
        public int position { get; set; }

        /// <summary>
        /// 填充方式
        /// </summary>
        public int mode { get; set; }

        /// <summary>
        /// 背景高度
        /// </summary>
        public int backgroundHeight { get; set; }

        /// <summary>
        /// 背景宽度
        /// </summary>
        public int backgroundWidth { get; set; }

        /// <summary>
        /// 拼团商品列表
        /// </summary>
        public List<pingtuanGoodsItem> list { get; set; }
    }

    /// <summary>
    /// 拼图商品详情
    /// </summary>
    public class pingtuanGoodsItem
    {
        /// <summary>
        /// 商品编号
        /// </summary>
        public int id { get; set; }

        /// <summary>
        /// 商品名称
        /// </summary>
        public string name { get; set; }

        /// <summary>
        /// 封面图
        /// </summary>
        public string CoverImage { get; set; }

        /// <summary>
        /// 价格
        /// </summary>
        public decimal price { get; set; }

        /// <summary>
        /// 拼团价格
        /// </summary>
        public decimal pintuanPrice { get; set; }

        /// <summary>
        /// 拼团人数
        /// </summary>
        public int peopleNum { get; set; }
    }

    /// <summary>
    /// 预约插件
    /// </summary>
    public class bookingItem
    {
        /// <summary>
        ///购买按钮颜色
        /// </summary>
        public string buttonColor { get; set; }

        /// <summary>
        /// 预约商品列表
        /// </summary>
        public List<bookingGoodsItem> list { get; set; }

        /// <summary>
        /// 列表样式(-1列表模式,1-一行一个,2-一行两个)
        /// </summary>
        public int listStyle { get; set; }

        /// <summary>
        /// 商品封面图填充(1-填充,0-留白)
        /// </summary>
        public int fill { get; set; }

        /// <summary>
        /// 商品封面图宽高比例(1-1,3-2)
        /// </summary>
        public string goodsCoverProportion { get; set; }

        /// <summary>
        /// 商品样式(1-白底无边框,2-白底有边框,3-无底无边框)
        /// </summary>
        public int goodsStyle { get; set; }

        /// <summary>
        /// 文本样式(1-左对齐,2-居中)
        /// </summary>
        public int textStyle { get; set; }

        /// <summary>
        /// 显示商品名称
        /// </summary>
        public bool showGoodsName { get; set; }

        /// <summary>
        /// 显示购买按钮
        /// </summary>
        public bool showBuyBtn { get; set; }

        /// <summary>
        /// 购买按钮样式(1-填充,2-线条,3-圆角填充,4-圆角线条)
        /// </summary>
        public int buyBtnStyle { get; set; }

        /// <summary>
        /// 购买按钮文字
        /// </summary>
        public string buyBtnText { get; set; }

        /// <summary>
        /// 显示商品角标
        /// </summary>
        public bool showGoodsTag { get; set; }

        /// <summary>
        /// 自定义商品角标
        /// </summary>
        public bool customizeGoodsTag { get; set; }

        /// <summary>
        /// 商品角标图片
        /// </summary>
        public string goodsTagPicUrl { get; set; }

        /// <summary>
        /// 背景颜色
        /// </summary>
        public string backgroundColor { get; set; }

        /// <summary>
        /// 背景图片
        /// </summary>
        public string backgroundPicUrl { get; set; }

        /// <summary>
        /// 图片位置
        /// </summary>
        public int position { get; set; }

        /// <summary>
        /// 填充方式
        /// </summary>
        public int mode { get; set; }

        /// <summary>
        /// 背景高度
        /// </summary>
        public int backgroundHeight { get; set; }

        /// <summary>
        /// 背景宽度
        /// </summary>
        public int backgroundWidth { get; set; }
    }

    /// <summary>
    /// 预约商品详情
    /// </summary>
    public class bookingGoodsItem
    {
        /// <summary>
        /// 商品编号
        /// </summary>
        public int id { get; set; }

        /// <summary>
        /// 演示商品名称
        /// </summary>
        public string name { get; set; }

        /// <summary>
        /// 商品封面图
        /// </summary>
        public string CoverImage { get; set; }

        /// <summary>
        /// 商品价格
        /// </summary>
        public decimal price { get; set; }
    }

    /// <summary>
    /// 砍价插件
    /// </summary>
    public class bargainItem
    {
        /// <summary>
        /// 按钮颜色
        /// </summary>
        public string buttonColor { get; set; }

        /// <summary>
        /// 砍价商品列表
        /// </summary>
        public List<bargainGoodsItem> list { get; set; }

        /// <summary>
        /// 列表样式(-1列表模式,1-一行一个,2-一行两个)
        /// </summary>
        public int listStyle { get; set; }

        /// <summary>
        /// 商品封面图填充(1-填充,0-留白)
        /// </summary>
        public int fill { get; set; }

        /// <summary>
        /// 商品封面图宽高比例(1-1,3-2)
        /// </summary>
        public string goodsCoverProportion { get; set; }

        /// <summary>
        /// 商品样式(1-白底无边框,2-白底有边框,3-无底无边框)
        /// </summary>
        public int goodsStyle { get; set; }

        /// <summary>
        /// 文本样式(1-左对齐,2-居中)
        /// </summary>
        public int textStyle { get; set; }

        /// <summary>
        /// 显示商品名称
        /// </summary>
        public bool showGoodsName { get; set; }

        /// <summary>
        /// 显示购买按钮
        /// </summary>
        public bool showBuyBtn { get; set; }

        /// <summary>
        /// 购买按钮样式(1-填充,2-线条,3-圆角填充,4-圆角线条)
        /// </summary>
        public int buyBtnStyle { get; set; }

        /// <summary>
        /// 按钮文字
        /// </summary>
        public string buyBtnText { get; set; }

        /// <summary>
        /// 显示商品角标
        /// </summary>
        public bool showGoodsTag { get; set; }

        /// <summary>
        /// 自定义商品角标
        /// </summary>
        public bool customizeGoodsTag { get; set; }

        /// <summary>
        /// 商品角标图片
        /// </summary>
        public string goodsTagPicUrl { get; set; }

        /// <summary>
        /// 背景颜色
        /// </summary>
        public string backgroundColor { get; set; }

        /// <summary>
        /// 背景图片
        /// </summary>
        public string backgroundPicUrl { get; set; }

        /// <summary>
        /// 图片位置
        /// </summary>
        public int position { get; set; }

        /// <summary>
        /// 填充方式
        /// </summary>
        public int mode { get; set; }

        /// <summary>
        /// 背景高度
        /// </summary>
        public int backgroundHeight { get; set; }

        /// <summary>
        /// 背景宽度
        /// </summary>
        public int backgroundWidth { get; set; }
    }

    /// <summary>
    /// 砍价商品详情
    /// </summary>
    public class bargainGoodsItem
    {
        /// <summary>
        /// 商品编号
        /// </summary>
        public int id { get; set; }

        /// <summary>
        /// 商品名称
        /// </summary>
        public string name { get; set; }

        /// <summary>
        /// 封面图
        /// </summary>
        public string CoverImage { get; set; }

        /// <summary>
        /// 售价
        /// </summary>
        public decimal price { get; set; }

        /// <summary>
        /// 原价
        /// </summary>
        public decimal originalPrice { get; set; }
    }

    /// <summary>
    /// 积分商城插件
    /// </summary>
    public class integralmallItem
    {
        /// <summary>
        /// 显示优惠券
        /// </summary>
        public bool showCoupon { get; set; }

        /// <summary>
        /// 显示商品
        /// </summary>
        public bool showGoods { get; set; }

        /// <summary>
        /// 优惠券文字颜色
        /// </summary>
        public string couponColor { get; set; }

        /// <summary>
        /// 优惠券背景图片
        /// </summary>
        public string couponPicUrl { get; set; }

        /// <summary>
        /// 购买按钮颜色
        /// </summary>
        public string buttonColor { get; set; }

        /// <summary>
        /// 列表样式(-1列表模式,1-一行一个,2-一行两个)
        /// </summary>
        public int listStyle { get; set; }

        /// <summary>
        /// 商品封面图填充(1-填充,0-留白)
        /// </summary>
        public int fill { get; set; }

        /// <summary>
        /// 商品封面图宽高比例(1-1,3-2)
        /// </summary>
        public string goodsCoverProportion { get; set; }

        /// <summary>
        /// 商品样式(1-白底无边框,2-白底有边框,3-无底无边框)
        /// </summary>
        public int goodsStyle { get; set; }

        /// <summary>
        /// 文本样式(1-左对齐,2-居中)
        /// </summary>
        public int textStyle { get; set; }

        /// <summary>
        /// 显示商品名称
        /// </summary>
        public bool showGoodsName { get; set; }

        /// <summary>
        /// 显示购买按钮
        /// </summary>
        public bool showBuyBtn { get; set; }

        /// <summary>
        /// 购买按钮样式(1-填充,2-线条,3-圆角填充,4-圆角线条)
        /// </summary>
        public int buyBtnStyle { get; set; }

        /// <summary>
        /// 购买按钮文字
        /// </summary>
        public string buyBtnText { get; set; }

        /// <summary>
        /// 显示商品角标
        /// </summary>
        public bool showGoodsTag { get; set; }

        /// <summary>
        /// 自定义商品角标
        /// </summary>
        public bool customizeGoodsTag { get; set; }

        /// <summary>
        /// 商品角标图片
        /// </summary>
        public string goodsTagPicUrl { get; set; }

        /// <summary>
        /// 背景颜色
        /// </summary>
        public string backgroundColor { get; set; }

        /// <summary>
        /// 背景图片
        /// </summary>
        public string backgroundPicUrl { get; set; }

        /// <summary>
        /// 图片位置
        /// </summary>
        public int position { get; set; }

        /// <summary>
        /// 填充方式
        /// </summary>
        public int mode { get; set; }

        /// <summary>
        /// 背景高度
        /// </summary>
        public int backgroundHeight { get; set; }

        /// <summary>
        /// 背景宽度
        /// </summary>
        public int backgroundWidth { get; set; }

        public List<integralmallGoodsItem> list { get; set; }
    }

    /// <summary>
    /// 积分商城商品详情
    /// </summary>
    public class integralmallGoodsItem
    {
        /// <summary>
        /// 编号
        /// </summary>
        public int id { get; set; }

        /// <summary>
        /// 商品名称
        /// </summary>
        public string name { get; set; }

        /// <summary>
        /// 封面图
        /// </summary>
        public string CoverImage { get; set; }

        /// <summary>
        /// 售价
        /// </summary>
        public decimal price { get; set; }

        /// <summary>
        /// 原价
        /// </summary>
        public decimal originalPrice { get; set; }

        /// <summary>
        /// 积分
        /// </summary>
        public int integral { get; set; }
    }

    /// <summary>
    /// 抽奖插件
    /// </summary>
    public class lotteryItem
    {
        public string buttonColor { get; set; }

        public int listStyle { get; set; }

        public int fill { get; set; }

        public string goodsCoverProportion { get; set; }


        public int goodsStyle { get; set; }

        public int textStyle { get; set; }

        public bool showGoodsName { get; set; }

        public bool showBuyBtn { get; set; }

        public int buyBtnStyle { get; set; }

        /// <summary>
        /// 去参与
        /// </summary>
        public string buyBtnText { get; set; }
        public bool showGoodsTag { get; set; }
        public bool customizeGoodsTag { get; set; }

        /// <summary>
        /// goodsTagPicUrl
        /// </summary>
        public string goodsTagPicUrl { get; set; }

        public bool showImg { get; set; }

        /// <summary>
        /// backgroundColor
        /// </summary>
        public string backgroundColor { get; set; }

        /// <summary>
        /// backgroundPicUrl
        /// </summary>
        public string backgroundPicUrl { get; set; }

        /// <summary>
        /// 图片位置
        /// </summary>
        public int position { get; set; }

        /// <summary>
        /// 填充方式
        /// </summary>
        public int mode { get; set; }

        public int backgroundHeight { get; set; }

        public int backgroundWidth { get; set; }

        public List<bargainGoodsItem> list { get; set; }
    }

    /// <summary>
    /// 预售
    /// </summary>
    public class advanceItem
    {
        public string buttonColor { get; set; }
        public List<advanceGoodsItem> list { get; set; }

        public int listStyle { get; set; }
        public int fill { get; set; }

        public string goodsCoverProportion { get; set; }

        public int goodsStyle { get; set; }

        public int textStyle { get; set; }

        public bool showGoodsName { get; set; }

        public bool showBuyBtn { get; set; }

        public int buyBtnStyle { get; set; }

        /// <summary>
        /// 抢购
        /// </summary>
        public string buyBtnText { get; set; }

        public bool showGoodsTag { get; set; }

        public bool customizeGoodsTag { get; set; }
        public string goodsTagPicUrl { get; set; }

        public int goodsIndex { get; set; }

        public int start_x { get; set; }

        public bool showImg { get; set; }

        public string backgroundColor { get; set; }

        public string backgroundPicUrl { get; set; }

        /// <summary>
        /// 图片位置
        /// </summary>
        public int position { get; set; }

        /// <summary>
        /// 填充方式
        /// </summary>
        public int mode { get; set; }

        public int backgroundHeight { get; set; }

        public int backgroundWidth { get; set; }
    }

    public class advanceGoodsItem
    {
        public int id { get; set; }

        /// <summary>
        /// 商品名称
        /// </summary>
        public string name { get; set; }

        /// <summary>
        /// CoverImage
        /// </summary>
        public string CoverImage { get; set; }

        public decimal price { get; set; }

        public decimal originalPrice { get; set; }
        public string deposit { get; set; }
        public string swell_deposit { get; set; }
    }

    /// <summary>
    /// 超级会员卡
    /// </summary>
    public class vipcardItem
    {
        public string background { get; set; }
        public bool usePluginConfig { get; set; }

        public int top_bottom_padding { get; set; }

        public string buy_bg { get; set; }
        public string renew_bg { get; set; }

        public string buy_big_color { get; set; }
        public string buy_small_color { get; set; }
        public string buy_btn_color { get; set; }
        public string buy_btn_bg_color { get; set; }

        public string buy_big { get; set; }

        public string buy_small { get; set; }

        public string buy_btn_text { get; set; }

        public string renew_text_color { get; set; }

        public string renew_btn_bg_color { get; set; }
        public string renew_text { get; set; }
    }

    /// <summary>
    /// 直播组件
    /// </summary>
    public class liveItem
    {
        public string background { get; set; }
        public bool is_show_goods { get; set; }

        public int style_type { get; set; }

        public int number { get; set; }
    }

    /// <summary>
    /// 空白块组件
    /// </summary>
    public class emptyItem
    {
        public string background { get; set; }

        public int height { get; set; }
    }

    /// <summary>
    /// 流量主广告
    /// </summary>
    public class adItem
    {
        public string id { get; set; }

        public string type { get; set; }

        public string pic_url { get; set; }

        public string video { get; set; }

        public string award_type { get; set; }

        public string award_num { get; set; }

        public string award_limit_type { get; set; }

        public int award_limit { get; set; }

        public List<adDetailsItem> award_coupons { get; set; }
    }

    /// <summary>
    /// 流量广告详情
    /// </summary>
    public class adDetailsItem
    {
        public int send_num { get; set; }

        /// <summary>
        /// 优惠券
        /// </summary>
        public string name { get; set; }

        /// <summary>
        /// 优惠券Id
        /// </summary>
        public int coupon_id { get; set; }
    }

    /// <summary>
    /// 弹窗广告
    /// </summary>
    public class modalItem
    {
        /// <summary>
        /// 是否开启(弹窗广告)
        /// </summary>
        public bool opened { get; set; }

        /// <summary>
        /// 弹窗次数(0-每次,1-仅首次)
        /// </summary>
        public int times { get; set; }

        /// <summary>
        /// 弹窗详细列表
        /// </summary>
        public List<modalDetailsItem> list { get; set; }
    }

   /// <summary>
   /// 弹窗详情
   /// </summary>
    public class modalDetailsItem
    {
        /// <summary>
        /// 图片地址
        /// </summary>
        public string picUrl { get; set; }

        /// <summary>
        /// 链接详情
        /// </summary>
        public modalLinkItem link { get; set; }
    }

    /// <summary>
    /// 弹窗链接详情
    /// </summary>
    public class modalLinkItem
    {
        /// <summary>
        /// 跳转地址
        /// </summary>
        public string url { get; set; }

        /// <summary>
        /// 打开方式
        /// </summary>
        public string openType { get; set; }
    }

    /// <summary>
    /// 导航项
    /// </summary>
    public class quicknavDetailsItem
    {
        public bool opened { get; set; }

        public string picUrl { get; set; }


        public string number { get; set; }


        public string appId { get; set; }

        public string page { get; set; }


        public string address { get; set; }

        public string location { get; set; }


        public string open_type { get; set; }

        public string link_url { get; set; }

        public string key { get; set; }

        /// <summary>
        /// 网站链接
        /// </summary>
        public string url { get; set; }

        //public string @params { get; set; }

    }

    /// <summary>
    /// 快捷导航
    /// </summary>
    public class quicknavItem
    {
        public int navSwitch { get; set; }
        public bool useMallConfig { get; set; }

        public int navStyle { get; set; }

        public string closedPicUrl { get; set; }

        public string openedPicUrl { get; set; }

        public quicknavDetailsItem home { get; set; }

        public quicknavDetailsItem customerService { get; set; }

        public quicknavDetailsItem tel { get; set; }

        public quicknavDetailsItem web { get; set; }
        public quicknavDetailsItem mApp { get; set; }
        public quicknavDetailsItem mapNav { get; set; }
        public quicknavDetailsItem customize { get; set; }
    }

    /// <summary>
    /// 店铺用户信息
    /// </summary>
    public class shopinfoItem
    {
        /// <summary>
        /// 头像
        /// </summary>
        public string headImg { get; set; }

        /// <summary>
        /// 用户信息
        /// </summary>
        public string headName { get; set; }

        /// <summary>
        /// 用户介绍
        /// </summary>
        public string headInfo { get; set; }

        /// <summary>
        /// 背景图片
        /// </summary>
        public string backgroundPicUrl { get; set; }

        /// <summary>
        /// 背景颜色
        /// </summary>
        public string backgroundColor { get; set; }

        /// <summary>
        /// 分享按钮图片
        /// </summary>
        public string bottonImg { get; set; }

        /// <summary>
        /// 字体颜色
        /// </summary>
        public string fontColor { get; set; }

        /// <summary>
        /// 字体名称
        /// </summary>
        public string fontName { get; set; }

        /// <summary>
        /// 字体大小
        /// </summary>
        public string fontSize { get; set; }

        /// <summary>
        /// 是否加粗
        /// </summary>
        public string isBold { get; set; }
    }


    /// <summary>
    /// 司导插件
    /// </summary>
    public class driveGuideItem
    {

        /// <summary>
        /// 搜索背景
        /// </summary>
        public string SearchBackground { get; set; }

        /// <summary>
        /// 搜索框文字
        /// </summary>
        public string SearchTips { get; set; }

        /// <summary>
        /// 是否显示时间筛选0-否，1-是
        /// </summary>
        public int IsShowDate { get; set; }

        /// <summary>
        /// 是否显示城市筛选0-否，1-是
        /// </summary>
        public int IsShowCity { get; set; }

        /// <summary>
        /// 是否显示地址筛选0-否，1-是
        /// </summary>
        public int IsShowAddress { get; set; }

        /// <summary>
        /// 是否显示拼车筛选0-否，1-是
        /// </summary>
        public int IsShowCarpooling { get; set; }

        /// <summary>
        /// 是否显示出行类型筛选0-否，1-是
        /// </summary>
        public int IsShowGuideCarGoodsType { get; set; }

        /// <summary>
        /// 是否显示车辆类型筛选0-否，1-是
        /// </summary>
        public int IsShowCarClass { get; set; }

        /// <summary>
        /// 是否显示出行人数筛选0-否，1-是
        /// </summary>
        public int IsShowTravelGuestNum { get; set; }

        /// <summary>
        /// 按钮上面的文字提示
        /// </summary>
        public string Tips { get; set; }

        /// <summary>
        /// 按钮上面的文字图标提示
        /// </summary>
        public string TipsIco { get; set; }

        /// <summary>
        /// 搜索框图标
        /// </summary>
        public string SearchIco { get; set; }

        /// <summary>
        /// 搜索圆角像素
        /// </summary>        
        public int SearchFilletPX
        {
            get;
            set;
        }

        /// <summary>
        /// 按钮圆角像素
        /// </summary>        
        public int ButtonFilletPX
        {
            get;
            set;
        }

        /// <summary>
        /// 按钮文本
        /// </summary>        
        public string ButtonText
        {
            get;
            set;
        }

        /// <summary>
        /// 按钮颜色
        /// </summary>        
        public string ButtonColor
        {
            get;
            set;
        }

        /// <summary>
        /// 按钮文字颜色
        /// </summary>        
        public string ButtonTextColor
        {
            get;
            set;
        }

        /// <summary>
        /// 上边距
        /// </summary>
        public string PaddingTop { get; set; }

        /// <summary>
        /// 下边距
        /// </summary>
        public string PaddingBottom { get; set; }

        /// <summary>
        /// 左边距
        /// </summary>
        public string PaddingLeft { get; set; }

        /// <summary>
        /// 右边距
        /// </summary>
        public string PaddingRight { get; set; }
    }


    #region 教育模块
    /// <summary>
    /// 教育模块-最近学习组件
    /// </summary>
    public class educationItem
    {

        /// <summary>
        /// 封面
        /// </summary>
        public string Cover { get; set; }
        /// <summary>
        /// 课程名称
        /// </summary>
        public string Name { get; set; }
        /// <summary>
        /// 显示进度
        /// </summary>
        public decimal showProgress { get; set; }



        /// <summary>
        /// 上边距
        /// </summary>
        public string PaddingTop { get; set; }

        /// <summary>
        /// 下边距
        /// </summary>
        public string PaddingBottom { get; set; }

        /// <summary>
        /// 左边距
        /// </summary>
        public string PaddingLeft { get; set; }

        /// <summary>
        /// 右边距
        /// </summary>
        public string PaddingRight { get; set; }


        /// <summary>
        /// 按钮位置
        /// </summary>
        public string BtnPosition { get; set; }
    }

    /// <summary>
    ///新增教育模块-自定义列表
    /// </summary>
    public class educationCustomItem
    {

        /// <summary>
        /// 商品数量
        /// </summary>
        public int goodsLength { get; set; }

        /// <summary>
        /// 列表样式[-1-列表模式,0-左右滑动,1-一行一个,2-一行两个3-一行三个]
        /// </summary>
        public int listStyle { get; set; }

        /// <summary>
        /// 类型(1-载体，2-品牌)
        /// </summary>
        public int goodType { get; set; }

        /// <summary>
        /// 添加方式【0-自动添加,1-手动添加】
        /// </summary>
        public int addGoodsType { get; set; }

        /// <summary>
        /// 背景颜色
        /// </summary>
        public string backgroundColor { get; set; }

        /// <summary>
        /// 上边距
        /// </summary>
        public string PaddingTop { get; set; }

        /// <summary>
        /// 下边距
        /// </summary>
        public string PaddingBottom { get; set; }

        /// <summary>
        /// 左边距
        /// </summary>
        public string PaddingLeft { get; set; }

        /// <summary>
        /// 右边距
        /// </summary>
        public string PaddingRight { get; set; }

        /// <summary>
        /// 搜索圆角像素
        /// </summary>        
        public int SearchFilletPX
        {
            get;
            set;
        }



        /// <summary>
        /// 自定义列表
        /// </summary>
        public List<CustomDetailsItem2> list { get; set; }
    }


    /// <summary>
    /// 商品详情项
    /// </summary>
    public class CustomDetailsItem2
    {
        /// <summary>
        /// 商品编号
        /// </summary>
        public int id { get; set; }

        /// <summary>
        /// 标题
        /// </summary>

        public string name { get; set; }

        /// <summary>
        /// 副标题
        /// </summary>

        public string lableName { get; set; }

        /// <summary>
        /// 副标题
        /// </summary>

        public List<string> lableNameList { get; set; }

        /// <summary>
        /// 商品图片
        /// </summary>
        public string picUrl { get; set; }

        /// <summary>
        /// 链接
        /// </summary>
        public string linkUrl { get; set; }
    }


    /// <summary>
    ///教育模块-资讯列表
    /// </summary>
    public class educationArticleItem
    {
        /// <summary>
        /// 商品数量
        /// </summary>
        public int goodsLength { get; set; }

        /// <summary>
        /// 商品添加方式【0-自定义,1-最新】
        /// </summary>
        public int addGoodsType { get; set; }

        /// <summary>
        /// 列表样式[-1-列表模式,0-左右滑动,1-一行一个]
        /// </summary>
        public int listStyle { get; set; }


        /// <summary>
        /// 背景颜色
        /// </summary>
        public string backgroundColor { get; set; }

        /// <summary>
        /// 上边距
        /// </summary>
        public string PaddingTop { get; set; }

        /// <summary>
        /// 下边距
        /// </summary>
        public string PaddingBottom { get; set; }

        /// <summary>
        /// 左边距
        /// </summary>
        public string PaddingLeft { get; set; }

        /// <summary>
        /// 右边距
        /// </summary>
        public string PaddingRight { get; set; }


        /// <summary>
        /// 搜索圆角像素
        /// </summary>        
        public int SearchFilletPX
        {
            get;
            set;
        }

        /// <summary>
        /// 自定义列表
        /// </summary>
        public List<CustomDetailsItem2> list { get; set; }
    }




    /// <summary>
    /// 老师
    /// </summary>
    public class educationTeacherItem
    {
        /// <summary>
        /// 上边距
        /// </summary>
        public string PaddingTop { get; set; }

        /// <summary>
        /// 下边距
        /// </summary>
        public string PaddingBottom { get; set; }

        /// <summary>
        /// 左边距
        /// </summary>
        public string PaddingLeft { get; set; }

        /// <summary>
        /// 右边距
        /// </summary>
        public string PaddingRight { get; set; }

        /// <summary>
        /// 列表样式[-1-列表模式,0-左右滑动,1-一行一个]
        /// </summary>
        public int listStyle { get; set; }


        /// <summary>
        /// 背景颜色
        /// </summary>
        public string backgroundColor { get; set; }
        /// <summary>
        /// 圆角像素
        /// </summary>        
        public int SearchFilletPX
        {
            get;
            set;
        }

        /// <summary>
        /// 老师列表
        /// </summary>
        public List<TeacherDetailsItem> TeacherList { get; set; }
    }



    /// <summary>
    /// 老师详情项
    /// </summary>
    public class TeacherDetailsItem
    {
        /// <summary>
        /// 商品编号
        /// </summary>
        public int id { get; set; }

        /// <summary>
        /// 老师名称
        /// </summary>

        public string name { get; set; }


        /// <summary>
        /// 老师国籍
        /// </summary>

        public string nationality { get; set; }


        /// <summary>
        /// 是否外国人0-否，1-是
        /// </summary>
        public string foreignersUrl { get; set; }

        /// <summary>
        /// 标签
        /// </summary>

        public string lableName { get; set; }

        /// <summary>
        /// 标签
        /// </summary>

        public List<string> lableNameList { get; set; }

        /// <summary>
        /// 老师头像
        /// </summary>
        public string picUrl { get; set; }

    }

    #endregion



    #region 门店
    /// <summary>
    /// 门店
    /// </summary>
    public class StoreGoodsItem
    {
        /// <summary>
        /// 显示分类
        /// </summary>
        public bool showCat { get; set; }

        /// <summary>
        /// 分类栏位置
        /// </summary>
        public string catPosition { get; set; }

        /// <summary>
        /// 分类样式
        /// </summary>
        public int catStyle { get; set; }

        /// <summary>
        /// 商品添加方式【0-自动添加,1-手动添加】
        /// </summary>
        public int addGoodsType { get; set; }

        /// <summary>
        /// 商品数量
        /// </summary>
        public int goodsLength { get; set; }

        /// <summary>
        /// 列表样式[-1-列表模式,0-左右滑动,1-一行一个,2-一行两个3-一行三个  4-教育模式]
        /// </summary>
        public int listStyle { get; set; }

        /// <summary>
        /// 商品封面图宽高比例[1-1]
        /// </summary>
        public string goodsCoverProportion { get; set; }

        /// <summary>
        /// 商品封面图填充
        /// </summary>
        public int fill { get; set; }

        /// <summary>
        /// 商品样式
        /// </summary>
        public int goodsStyle { get; set; }

        /// <summary>
        /// 文本样式
        /// </summary>
        public int textStyle { get; set; }

        /// <summary>
        /// 显示商品名称
        /// </summary>
        public bool showGoodsName { get; set; }

        /// <summary>
        /// 显示商品价格
        /// </summary>
        public bool showGoodsPrice { get; set; }

        /// <summary>
        /// 显示购买按钮
        /// </summary>
        public bool showBuyBtn { get; set; }

        /// <summary>
        /// 购买按钮样式[cart]
        /// </summary>
        public string buyBtn { get; set; }

        /// <summary>
        /// 购买按钮文字样式
        /// </summary>
        public int buyBtnStyle { get; set; }

        /// <summary>
        /// 购买按钮文字
        /// </summary>
        public string buyBtnText { get; set; }

        /// <summary>
        /// 购买按钮颜色
        /// </summary>
        public string buttonColor { get; set; }

        /// <summary>
        /// 显示评分    ld  2020-10-13
        /// </summary>
        public bool showScore { get; set; }

        /// <summary>
        /// 评分颜色
        /// </summary>
        public string scoreColor { get; set; }

        /// <summary>
        /// 显示商品角标
        /// </summary>
        public bool showGoodsTag { get; set; }

        /// <summary>
        /// 商品角标自定义
        /// </summary>
        public bool customizeGoodsTag { get; set; }

        /// <summary>
        /// 商品角标链接
        /// </summary>
        public string goodsTagPicUrl { get; set; }

        /// <summary>
        /// 是否显示图片背景
        /// </summary>
        public bool showImg { get; set; }

        /// <summary>
        /// 背景颜色
        /// </summary>
        public string backgroundColor { get; set; }

        /// <summary>
        /// 背景链接
        /// </summary>
        public string backgroundPicUrl { get; set; }

        /// <summary>
        ///  图片位置
        /// </summary>
        public int position { get; set; }


        /// <summary>
        ///  填充方式
        /// </summary>
        public int mode { get; set; }

        /// <summary>
        ///  背景高
        /// </summary>
        public int backgroundHeight { get; set; }

        /// <summary>
        ///  背景宽
        /// </summary>
        public int backgroundWidth { get; set; }

        /// <summary>
        /// 分类列表
        /// </summary>
        public List<StoreCatItem> catList { get; set; }

        /// <summary>
        /// 商品列表
        /// </summary>
        public List<StoreGoodsDetailsItem2> list { get; set; }
    }



    /// <summary>
    /// 门店商品分类
    /// </summary>
    public class StoreCatItem
    {
        /// <summary>
        /// 分类编号
        /// </summary>
        public int id { get; set; }

        /// <summary>
        /// 商品分类
        /// </summary>
        public string name { get; set; }

        /// <summary>
        /// 菜单名称
        /// </summary>
        public string menuName { get; set; }

        /// <summary>
        /// 商品数量
        /// </summary>
        public int goodsNum { get; set; }

        /// <summary>
        /// 是否显示自定义商品
        /// </summary>
        public bool staticGoods { get; set; }

        /// <summary>
        /// 商品列表
        /// </summary>
        public List<StoreGoodsDetailsItem2> goodsList { get; set; }
    }

    /// <summary>
    /// 门店商品详情项
    /// </summary>
    public class StoreGoodsDetailsItem2
    {
        /// <summary>
        /// 商品编号
        /// </summary>
        public int id { get; set; }

        /// <summary>
        /// 商品名称
        /// </summary>

        public string name { get; set; }

        /// <summary>
        /// 商品图片
        /// </summary>
        public string picUrl { get; set; }

        /// <summary>
        /// 售价
        /// </summary>
        public decimal price { get; set; }

        /// <summary>
        /// 【原价】前端使用
        /// </summary>
        public decimal OriginalPrice { get; set; }

        /// <summary>
        /// 是否选择服务人员(0-不选,1-选择)前端使用
        /// </summary>
        public int IsChooseServicePerson { get; set; }

        /// <summary>
        /// 课程评分  2020-10-13  ld 
        /// </summary>
        public decimal courseScore { get; set; }

        /// <summary>
        /// 定金服务商品使用
        /// </summary>
        public decimal DepositMoney { get; set; }
    }



    /// <summary>
    /// 门店
    /// </summary>
    public class ReserveStoreItem
    {
        /// <summary>
        /// 上边距
        /// </summary>
        public string PaddingTop { get; set; }

        /// <summary>
        /// 下边距
        /// </summary>
        public string PaddingBottom { get; set; }

        /// <summary>
        /// 左边距
        /// </summary>
        public string PaddingLeft { get; set; }

        /// <summary>
        /// 右边距
        /// </summary>
        public string PaddingRight { get; set; }


        /// <summary>
        /// 圆角像素
        /// </summary>        
        public int SearchFilletPX
        {
            get;
            set;
        }
        /// <summary>
        /// 是否显示封面图
        /// </summary>
        public bool IsShowStoreImg { get; set; }

    }
    #endregion


    #region 相亲- 人物插件
    public class MiAiUserItem
    {

        /// <summary>
        /// 人数数量
        /// </summary>
        public int goodsLength { get; set; }

        /// <summary>
        /// 列表样式[-1-列表模式,0-左右滑动,1-一行一个,2-一行两个3-一行三个]
        /// </summary>
        public int listStyle { get; set; }



        /// <summary>
        /// 用户添加方式（0-自定义，1-按照匹配度【规则未确定】，2-按照热度【被浏览数据，被关注数据】，3-按照最新,4-每日随机）
        /// </summary>
        public int addUserType { get; set; }


        /// <summary>
        /// 用户添加方式（0-默认，1-男神，2-女神）
        /// </summary>
        public int sexType { get; set; }

        /// <summary>
        /// 浏览权重
        /// </summary>
        public decimal BrowseRate { get; set; }


        /// <summary>
        /// 关注权重
        /// </summary>
        public decimal FollowRate { get; set; }


        /// <summary>
        /// 背景颜色
        /// </summary>
        public string backgroundColor { get; set; }

        /// <summary>
        /// 上边距
        /// </summary>
        public string PaddingTop { get; set; }

        /// <summary>
        /// 下边距
        /// </summary>
        public string PaddingBottom { get; set; }

        /// <summary>
        /// 左边距
        /// </summary>
        public string PaddingLeft { get; set; }

        /// <summary>
        /// 右边距
        /// </summary>
        public string PaddingRight { get; set; }

        /// <summary>
        /// 搜索圆角像素
        /// </summary>        
        public int SearchFilletPX
        {
            get;
            set;
        }



        /// <summary>
        /// 自定义列表
        /// </summary>
        public List<miaiUserDetail> list { get; set; }
    }

    /// <summary>
    /// 详情
    /// </summary>
    public class miaiUserDetail
    {
        /// <summary>
        /// 商品编号
        /// </summary>
        public int id { get; set; }

        /// <summary>
        /// 标题
        /// </summary>

        public string name { get; set; }

        /// <summary>
        /// 商品图片
        /// </summary>
        public string Photo { get; set; }

        /// <summary>
        /// 性别
        /// </summary>
        public string SexStr { get; set; }


        /// <summary>
        /// 年龄
        /// </summary>
        public string Age { get; set; }

        /// <summary>
        /// 学历
        /// </summary>
        public string Education { get; set; }

        /// <summary>
        /// 婚姻状态
        /// </summary>
        public string Marriage { get; set; }

        /// <summary>
        /// 匹配度
        /// </summary>
       // public int MatchingRate { get; set; }

        /// <summary>
        /// 分数
        /// </summary>
        public int Score { get; set; }

        /// <summary>
        /// 相册
        /// </summary>
        public string Album { get; set; }


        public List<string> AlbumList { get; set; }
    }
    #endregion

    #region 星球大事件分类

    /// <summary>
    ///教育模块-资讯列表
    /// </summary>
    public class MiAiActivityTypeItem
    {


        /// <summary>
        /// 列表样式[-1-列表模式,0-左右滑动,1-一行一个]
        /// </summary>
        public int listStyle { get; set; }


        /// <summary>
        /// 背景颜色
        /// </summary>
        public string backgroundColor { get; set; }

        /// <summary>
        /// 上边距
        /// </summary>
        public string PaddingTop { get; set; }

        /// <summary>
        /// 下边距
        /// </summary>
        public string PaddingBottom { get; set; }

        /// <summary>
        /// 左边距
        /// </summary>
        public string PaddingLeft { get; set; }

        /// <summary>
        /// 右边距
        /// </summary>
        public string PaddingRight { get; set; }


        /// <summary>
        /// 搜索圆角像素
        /// </summary>        
        public int SearchFilletPX
        {
            get;
            set;
        }

        /// <summary>
        /// 自定义列表
        /// </summary>
        public List<MiAiActivityTypeModel> list { get; set; }
    }



    /// <summary>
    /// 商品详情项
    /// </summary>
    public class MiAiActivityTypeModel
    {
        /// <summary>
        /// 商品编号
        /// </summary>
        public int id { get; set; }

        /// <summary>
        /// 标题
        /// </summary>

        public string name { get; set; }

        /// <summary>
        /// 副标题
        /// </summary>

        public string lableName { get; set; }

        /// <summary>
        /// 副标题
        /// </summary>

        public List<string> lableNameList { get; set; }

        /// <summary>
        /// 商品图片
        /// </summary>
        public string picUrl { get; set; }

    }







    /// <summary>
    ///新增相亲星球大事件-自定义列表
    /// </summary>
    public class MiAiActivityTypeCustomItem
    {

        /// <summary>
        /// 列表样式[-1-列表模式,0-左右滑动,1-一行一个,2-一行两个3-一行三个]
        /// </summary>
        public int listStyle { get; set; }



        /// <summary>
        /// 背景颜色
        /// </summary>
        public string backgroundColor { get; set; }

        /// <summary>
        /// 上边距
        /// </summary>
        public string PaddingTop { get; set; }

        /// <summary>
        /// 下边距
        /// </summary>
        public string PaddingBottom { get; set; }

        /// <summary>
        /// 左边距
        /// </summary>
        public string PaddingLeft { get; set; }

        /// <summary>
        /// 右边距
        /// </summary>
        public string PaddingRight { get; set; }

        /// <summary>
        /// 搜索圆角像素
        /// </summary>        
        public int SearchFilletPX
        {
            get;
            set;
        }



        /// <summary>
        /// 自定义列表
        /// </summary>
        public List<MiAiActivityTypeCusModel> list { get; set; }
    }


    /// <summary>
    /// 商品详情项
    /// </summary>
    public class MiAiActivityTypeCusModel
    {


        /// <summary>
        /// 标题
        /// </summary>

        public string name { get; set; }

        /// <summary>
        /// 副标题
        /// </summary>

        public string lableName { get; set; }

        /// <summary>
        /// 副标题
        /// </summary>

        public List<string> lableNameList { get; set; }

        /// <summary>
        /// 商品图片
        /// </summary>
        public string picUrl { get; set; }



        /// <summary>
        /// 链接
        /// </summary>
        public string linkUrl { get; set; }

    }




    /// <summary>
    /// 相亲ppplus (招募贴)插件
    /// </summary>
    public class blindDatePPPlusItem
    {
        /// <summary>
        /// 显示分类
        /// </summary>
        public bool showCat { get; set; }

        /// <summary>
        /// 分类栏位置
        /// </summary>
        public string catPosition { get; set; }

        /// <summary>
        /// 分类样式
        /// </summary>
        public int catStyle { get; set; }

        /// <summary>
        /// ppplus添加方式【0-自动添加,1-手动添加】
        /// </summary>
        public int addActivityType { get; set; }

        /// <summary>
        /// ppplus数量
        /// </summary>
        public int activityLength { get; set; }

        /// <summary>
        /// 列表样式[-1-瀑布流模式,0-卡片,]
        /// </summary>
        public int listStyle { get; set; }


        /// <summary>
        /// 背景色
        /// </summary>
        public string backgroundColor { get; set; }

        /// <summary>
        /// 展示样式
        /// </summary>
        public int activityStyle { get; set; }



        /// <summary>
        /// 分类列表
        /// </summary>
        public List<catActivityItem> catList { get; set; }

        /// <summary>
        /// 商品列表
        /// </summary>
        public List<ActivityDetailsItem> list { get; set; }
    }

    /// <summary>
    ///相亲ppplus (招募贴)详情项
    /// </summary>
    public class ActivityDetailsItem
    {
        /// <summary>
        /// 商品编号
        /// </summary>
        public int id { get; set; }

        /// <summary>
        /// 商品名称
        /// </summary>

        public string name { get; set; }

        /// <summary>
        /// 商品图片
        /// </summary>
        public string picUrl { get; set; }

        /// <summary>
        /// 发帖人
        /// </summary>
        public string CreateBy { get; set; }




        /// <summary>
        /// 发帖人
        /// </summary>
        public int CreateById { get; set; }

        /// <summary>
        /// 发帖人
        /// </summary>
        public string CreateByIco { get; set; }

        /// <summary>
        /// 点赞数
        /// </summary>
        public int DianZanNum { get; set; }

        /// <summary>
        /// 是否点赞0-否，1-是
        /// </summary>
        public int IsDianZan { get; set; }


        /// <summary>
        /// 是否是帖子，0-活动，1-帖子
        /// </summary>
        public int IsTieZi { get; set; }
    }

    /// <summary>
    /// 相亲ppplus (招募贴)分类
    /// </summary>
    public class catActivityItem
    {
        /// <summary>
        /// 分类编号
        /// </summary>
        public int id { get; set; }

        /// <summary>
        /// 是否自定义分类0-否，1-是
        /// </summary>
        public int isCustom { get; set; }

        /// <summary>
        /// 帖子范围，1-全部帖子，2-用户关注，3-手动关联，1-2只需要填写帖子数量，3-要手动指定活动
        /// </summary>
        public int range { get; set; }

        /// <summary>
        /// 商品分类
        /// </summary>
        public string name { get; set; }

        /// <summary>
        /// 菜单名称
        /// </summary>
        public string menuName { get; set; }

        /// <summary>
        /// 商品数量
        /// </summary>
        public int goodsNum { get; set; }

        /// <summary>
        /// 是否显示自定义商品
        /// </summary>
        public bool staticGoods { get; set; }

        /// <summary>
        /// 商品列表
        /// </summary>
        public List<ActivityDetailsItem> goodsList { get; set; }
    }

    #endregion
}