﻿using Mall.Model.Entity.TradePavilion;
using System;
using System.Collections.Generic;
using System.Text;
using Mall.Common.Plugin;

namespace Mall.Model.Extend.TradePavilion
{
    /// <summary>
    /// 自定义表单扩展实体类
    /// </summary>
    public class RB_Custom_Form_Extend : RB_Custom_Form
    {
        public string FormTypeStr { get { return this.FormType.GetEnumName(); } }

        /// <summary>
        /// 表单内容
        /// </summary>
        public List<FormDataItem> FormDataList { get; set; }
    }

    /// <summary>
    /// 组件对象
    /// </summary>
    public class FormDataItem
    {
        /// <summary>
        ///组件Key
        /// </summary>
        public string CompKey { get; set; }

        /// <summary>
        /// 是否选中
        /// </summary>
        public bool isCked { get; set; }

        /// <summary>
        /// 组件对象
        /// </summary>
        public object CompData { get; set; }
    }

    /// <summary>
    /// 文本对象
    /// </summary>
    public class TextItem
    {
        /// <summary>
        /// 名字
        /// </summary>
        public string Name { get; set; }

        /// <summary>
        /// 字数(0-不限)
        /// </summary>
        public int WordsLength { get; set; }

        /// <summary>
        /// 是否必填
        /// </summary>
        public bool IsRequire { get; set; }
    }

    /// <summary>
    /// 下拉框对象
    /// </summary>
    public class SelectItem
    {
        /// <summary>
        /// 名称
        /// </summary>
        public string Name { get; set; }

        /// <summary>
        /// 是否多选
        /// </summary>
        public bool IsMultiple { get; set; }

        /// <summary>
        /// 选项值（以英文逗号相隔）
        /// </summary>
        public string OptionValue { get; set; }

        /// <summary>
        /// 是否必填
        /// </summary>
        public bool IsRequire { get; set; }
    }

    /// <summary>
    /// 上传组件
    /// </summary>
    public class UploadItem
    {
        /// <summary>
        /// 名称
        /// </summary>
        public string Name { get; set; }

        /// <summary>
        /// 上传文件数量
        /// </summary>
        public int FileCount { get; set; }

        /// <summary>
        /// 上传文件大小M
        /// </summary>
        public int FileSizeLimit { get; set; }
    }
}

