﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using Mall.Common.Enum;
using Mall.Model.Entity.Education;
using Mall.Model.Extend.Education;
using VT.FW.DB.Dapper;

namespace Mall.Repository.Education
{
    public class RB_Education_ActivityRepository : BaseRepository<RB_Education_Activity>
    {
        /// <summary>
        /// 获取商会活动分页列表
        /// </summary>
        /// <param name="pageIndex"></param>
        /// <param name="pageSize"></param>
        /// <param name="rowsCount"></param>
        /// <param name="query"></param>
        /// <returns></returns>
        public List<RB_Education_Activity_Extend> GetCommerceActivityPageListRepository(int pageIndex, int pageSize, out long rowsCount, RB_Education_Activity_Extend query)
        {
            rowsCount = 0;
            DynamicParameters parameters = new DynamicParameters();
            StringBuilder builder = new StringBuilder();
            builder.AppendFormat(@"
SELECT A.*,IFNULL(B.TypeName,'') AS ActivityTypeName,IFNULL(C.JoinNum,0) AS JoinNum
FROM RB_Education_Activity AS A LEFT JOIN RB_Education_Activitytype AS B ON A.ActivityType=B.Id
     LEFT JOIN (SELECT ActivityId,COUNT(1) AS JoinNum  FROM rb_education_consult WHERE `Status`=0 and OrderStatus=1 GROUP BY ActivityId) AS C ON A.Id=C.ActivityId
WHERE 1=1
");
            builder.AppendFormat(" AND A.{0}={1} ", nameof(RB_Education_Activity_Extend.Status), (int)DateStateEnum.Normal);
            if (query == null)
            {
                return new List<RB_Education_Activity_Extend>();
            }
            else
            {
                if (query.TenantId > 0)
                {
                    builder.AppendFormat(" AND A.{0}={1} ", nameof(RB_Education_Activity_Extend.TenantId), query.TenantId);
                }
                if (query.MallBaseId > 0)
                {
                    builder.AppendFormat(" AND A.{0}={1} ", nameof(RB_Education_Activity_Extend.MallBaseId), query.MallBaseId);
                }

                if (!string.IsNullOrEmpty(query.ActivityName))
                {
                    builder.AppendFormat(" AND A.{0} LIKE @Name ", nameof(RB_Education_Activity_Extend.ActivityName));
                    parameters.Add("Name", "%" + query.ActivityName.Trim() + "%");
                }
                if (query.ActivityType > 0)
                {
                    builder.AppendFormat(" AND A.{0}={1} ", nameof(RB_Education_Activity_Extend.ActivityType), query.ActivityType);
                }

                if (query.SelectIsEnd == 1)
                {
                    builder.AppendFormat($" and  DATE_FORMAT(a.{nameof(RB_Education_Activity_Extend.EndTime)},'%Y-%m-%d' )< DATE_FORMAT(NOW(),'%Y-%m-%d' ) ");
                }
                else
                {
                    if (!string.IsNullOrWhiteSpace(query.SelectStartTimeStr))
                    {
                        builder.AppendFormat($" and  DATE_FORMAT(a.{ nameof(RB_Education_Activity_Extend.EndTime)},'%Y-%m-%d' )>=DATE_FORMAT('{query.SelectStartTimeStr}','%Y-%m-%d' ) ");
                    }
                    if (!string.IsNullOrWhiteSpace(query.SelectEndTimeStr))
                    {
                        builder.AppendFormat($" and  DATE_FORMAT(a.{nameof(RB_Education_Activity_Extend.EndTime)},'%Y-%m-%d' )<= DATE_FORMAT('{query.SelectEndTimeStr}','%Y-%m-%d' ) ");
                    }
                }


                if (!string.IsNullOrWhiteSpace(query.OrderByStr))
                {
                    builder.AppendFormat($" ORDER BY A.{query.OrderByStr}  asc");
                }
                else
                {
                    builder.AppendFormat(" ORDER BY A.{0} DESC ", nameof(RB_Education_Activity_Extend.Id));
                }
            }
            return GetPage<RB_Education_Activity_Extend>(pageIndex, pageSize, out rowsCount, builder.ToString(), parameters).ToList();
        }







        /// <summary>
        /// 获取商会活动分页列表
        /// </summary>
        /// <param name="pageIndex"></param>
        /// <param name="pageSize"></param>
        /// <param name="rowsCount"></param>
        /// <param name="query"></param>
        /// <returns></returns>
        public List<RB_Education_Activity_Extend> GetCommerceActivityPageListRepository_V2(int pageIndex, int pageSize, out long rowsCount, RB_Education_Activity_Extend query)
        {
            rowsCount = 0;
            DynamicParameters parameters = new DynamicParameters();
            StringBuilder builder = new StringBuilder();
            builder.AppendFormat(@"
SELECT A.*,IFNULL(B.TypeName,'') AS ActivityTypeName,IFNULL(C.JoinNum,0) AS JoinNum
FROM RB_Education_Activity AS A LEFT JOIN RB_Education_Activitytype AS B ON A.ActivityType=B.Id
     LEFT JOIN (SELECT ActivityId,COUNT(1) AS JoinNum  FROM rb_education_consult WHERE `Status`=0 and OrderStatus=1 GROUP BY ActivityId) AS C ON A.Id=C.ActivityId
WHERE 1=1
");
            builder.AppendFormat(" AND A.{0}={1} ", nameof(RB_Education_Activity_Extend.Status), (int)DateStateEnum.Normal);
            if (query == null)
            {
                return new List<RB_Education_Activity_Extend>();
            }
            else
            {
                if (query.TenantId > 0)
                {
                    builder.AppendFormat(" AND A.{0}={1} ", nameof(RB_Education_Activity_Extend.TenantId), query.TenantId);
                }
                if (query.MallBaseId > 0)
                {
                    builder.AppendFormat(" AND A.{0}={1} ", nameof(RB_Education_Activity_Extend.MallBaseId), query.MallBaseId);
                }

                if (!string.IsNullOrEmpty(query.ActivityName))
                {
                    builder.AppendFormat(" AND A.{0} LIKE @Name ", nameof(RB_Education_Activity_Extend.ActivityName));
                    parameters.Add("Name", "%" + query.ActivityName.Trim() + "%");
                }
                if (query.ActivityType > 0)
                {
                    builder.AppendFormat(" AND A.{0}={1} ", nameof(RB_Education_Activity_Extend.ActivityType), query.ActivityType);
                }

                if (query.SelectIsEnd == 0)//未开始
                {
                    builder.AppendFormat($" and  DATE_FORMAT(a.{ nameof(RB_Education_Activity_Extend.StartTime)},'%Y-%m-%d' ) > DATE_FORMAT(NOW(),'%Y-%m-%d' ) ");
                }
                else if (query.SelectIsEnd == 1)//已结束
                {
                    builder.AppendFormat($" and  DATE_FORMAT(a.{nameof(RB_Education_Activity_Extend.EndTime)},'%Y-%m-%d' )< DATE_FORMAT(NOW(),'%Y-%m-%d' ) ");
                }
                else if (query.SelectIsEnd == 2)//进行中
                {
                    builder.AppendFormat($" and  DATE_FORMAT(a.{ nameof(RB_Education_Activity_Extend.StartTime)},'%Y-%m-%d' ) <=DATE_FORMAT(NOW(),'%Y-%m-%d' ) ");
                    builder.AppendFormat($" and  DATE_FORMAT(a.{ nameof(RB_Education_Activity_Extend.EndTime)},'%Y-%m-%d' ) >=DATE_FORMAT(NOW(),'%Y-%m-%d' ) ");
                }

                if (!string.IsNullOrWhiteSpace(query.SelectStartTimeStr))
                {
                    builder.AppendFormat($" and  DATE_FORMAT(a.{ nameof(RB_Education_Activity_Extend.StartTime)},'%Y-%m-%d' )>=DATE_FORMAT('{query.SelectStartTimeStr}','%Y-%m-%d' ) ");
                }
                if (!string.IsNullOrWhiteSpace(query.SelectEndTimeStr))
                {
                    builder.AppendFormat($" and  DATE_FORMAT(a.{nameof(RB_Education_Activity_Extend.StartTime)},'%Y-%m-%d' )<= DATE_FORMAT('{query.SelectEndTimeStr}','%Y-%m-%d' ) ");
                }
                if (!string.IsNullOrWhiteSpace(query.OrderByStr))
                {
                    builder.AppendFormat($" ORDER BY A.{query.OrderByStr}  asc");
                }
                else
                {
                    builder.AppendFormat(" ORDER BY A.{0} DESC ", nameof(RB_Education_Activity_Extend.Id));
                }
            }
            return GetPage<RB_Education_Activity_Extend>(pageIndex, pageSize, out rowsCount, builder.ToString(), parameters).ToList();
        }


        /// <summary>
        /// 获取当前用户参加商会活动分页列表
        /// </summary>
        /// <param name="pageIndex"></param>
        /// <param name="pageSize"></param>
        /// <param name="rowsCount"></param>
        /// <param name="query"></param>
        /// <returns></returns>
        public List<RB_Education_Activity_Extend> GetUserCommerceActivityPageRepository(int pageIndex, int pageSize, out long rowsCount, RB_Education_Activity_Extend query)
        {
            rowsCount = 0;
            DynamicParameters parameters = new DynamicParameters();
            StringBuilder builder = new StringBuilder();
            builder.AppendFormat(@"
SELECT A.*,IFNULL(B.TypeName,'') AS ActivityTypeName,IFNULL(C.JoinNum,0) AS JoinNum
FROM RB_Education_Activity AS A LEFT JOIN RB_Education_Activitytype AS B ON A.ActivityType=B.Id
     LEFT JOIN (SELECT ActivityId,COUNT(1) AS JoinNum  FROM rb_education_consult WHERE `Status`=0 GROUP BY ActivityId) AS C ON A.Id=C.ActivityId
     INNER JOIN rb_education_consult AS D ON A.Id=D.ActivityId
WHERE 1=1
");
            builder.AppendFormat(" AND A.{0}={1} ", nameof(RB_Education_Activity_Extend.Status), (int)DateStateEnum.Normal);
            builder.AppendFormat(" AND D.{0}={1} ", nameof(RB_Education_Consult_Extend.Status), (int)DateStateEnum.Normal);
            builder.AppendFormat(" AND D.{0}={1} ", nameof(RB_Education_Consult_Extend.OrderStatus), 1);
            if (query == null)
            {
                return new List<RB_Education_Activity_Extend>();
            }
            else
            {
                if (query.TenantId > 0)
                {
                    builder.AppendFormat(" AND A.{0}={1} ", nameof(RB_Education_Activity_Extend.TenantId), query.TenantId);
                }
                if (query.MallBaseId > 0)
                {
                    builder.AppendFormat(" AND A.{0}={1} ", nameof(RB_Education_Activity_Extend.MallBaseId), query.MallBaseId);
                }
                if (!string.IsNullOrEmpty(query.ActivityName))
                {
                    builder.AppendFormat(" AND A.{0} LIKE @Name ", nameof(RB_Education_Activity_Extend.ActivityName));
                    parameters.Add("Name", "%" + query.ActivityName.Trim() + "%");
                }
                if (query.ActivityType > 0)
                {
                    builder.AppendFormat(" AND A.{0}={1} ", nameof(RB_Education_Activity_Extend.ActivityType), query.ActivityType);
                }
                //当前用户参加的活动
                if (query.CreateBy > 0)
                {
                    builder.AppendFormat(" AND D.{0}={1} ", nameof(RB_Education_Consult_Extend.UserId), query.CreateBy);
                }
            }
            builder.AppendFormat(" ORDER BY A.{0} DESC ", nameof(RB_Education_Activity_Extend.Id));
            return GetPage<RB_Education_Activity_Extend>(pageIndex, pageSize, out rowsCount, builder.ToString(), parameters).ToList();
        }

        /// <summary>
        /// 获取列表
        /// </summary>
        /// <param name="dmodel"></param>
        /// <returns></returns>
        public List<RB_Education_Activity_Extend> GetList(RB_Education_Activity_Extend query)
        {
            StringBuilder builder = new StringBuilder();
            builder.AppendFormat(@"
SELECT A.* FROM RB_Education_Activity AS A 
WHERE 1=1
");
            builder.AppendFormat(" AND A.{0}={1} ", nameof(RB_Education_Activity_Extend.Status), (int)DateStateEnum.Normal);
            if (query == null)
            {
                return new List<RB_Education_Activity_Extend>();
            }
            else
            {
                if (query.TenantId > 0)
                {
                    builder.AppendFormat(" AND A.{0}={1} ", nameof(RB_Education_Activity_Extend.TenantId), query.TenantId);
                }
                if (query.MallBaseId > 0)
                {
                    builder.AppendFormat(" AND A.{0}={1} ", nameof(RB_Education_Activity_Extend.MallBaseId), query.MallBaseId);
                }
                if (query.ActivityType > 0)
                {
                    builder.AppendFormat(" AND A.{0}={1} ", nameof(RB_Education_Activity_Extend.ActivityType), query.ActivityType);
                }
                if (!string.IsNullOrEmpty(query.ActivityIds))
                {
                    builder.AppendFormat(" AND A.{0} in({1}) ", nameof(RB_Education_Activity_Extend.Id), query.ActivityIds);
                }
            }
            return Get<RB_Education_Activity_Extend>(builder.ToString()).ToList();
        }
    }
}
