﻿using Mall.Common.Enum;
using Mall.Model.Entity.Finance;
using Mall.Model.Extend.Finance;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using VT.FW.DB.Dapper;

namespace Mall.Repository.Finance
{
    /// <summary>
    /// 财务单据仓储
    /// </summary>
    public partial class RB_FinanceRepository : BaseRepository<RB_Finance>
    {
        /// <summary>
        /// 表名称
        /// </summary>
        public string TableName { get { return nameof(RB_Finance); } }

        /// <summary>
        /// 记录表
        /// </summary>
        public string ReCordTableName { get { return nameof(Rb_Workflow_Auditrecord); } }
        /// <summary>
        /// 获取电商订单所有财务单据
        /// </summary>
        /// <param name="model"></param>
        /// <returns></returns>
        public List<RB_Finance_Extend> GetList(RB_Finance_Extend model)
        {
            string where = "1=1 AND A.Is_Auto=0 ";
            where += string.Format(" AND A." + nameof(RB_Finance.Status) + " <> 4");
            where += string.Format(" AND E." + nameof(RB_Finance.Status) + " <> 4");
            //集团
            if (model.RB_Group_Id > 0)
            {
                where += string.Format(" AND A." + nameof(RB_Finance.RB_Group_Id) + " ={0}", model.RB_Group_Id);
            }
            //单据状态
            if (model.Status >= 0)
            {
                where += string.Format(" AND A." + nameof(RB_Finance.Status) + " ={0}", (int)model.Status);
            }
            if (model.Type > 0)
            {
                where += string.Format(" AND A." + nameof(RB_Finance.Type) + " ={0}", (int)model.Type);
            }
            //订单号
            if (model.OrderID > 0)
            {
                where += string.Format(" AND A." + nameof(RB_Finance.OrderID) + " ={0}", model.OrderID);
            }
            //对象类型
            if (model.ClientType > 0)
            {
                where += string.Format(" AND A." + nameof(RB_Finance.ClientType) + " ={0}", (int)model.ClientType);
            }
            //汇款人
            if (!string.IsNullOrEmpty(model.RemitterName))
            {
                where += string.Format(" AND A." + nameof(RB_Finance.RemitterName) + " like '%{0}%' ", model.RemitterName);
            }
            //付款对象
            if (model.ClientID > 0)
            {
                where += string.Format(" AND A." + nameof(RB_Finance.ClientID) + " ={0}", model.ClientID);
            }

            if (model.ECOrderId > 0)
            {
                where += string.Format(" AND E." + nameof(RB_ECFinanceId_Relation.ECOrderId) + " ={0}", model.ECOrderId);
            }
            if (!string.IsNullOrEmpty(model.ECOrderIds))
            {
                where += string.Format(" AND E." + nameof(RB_ECFinanceId_Relation.ECOrderId) + " in({0})", model.ECOrderIds);
            }

            if (!string.IsNullOrEmpty(model.ReFinanceIds2))
            {
                where += string.Format(" AND A." + nameof(RB_Finance.ReFinanceId2) + " in({0})", model.ReFinanceIds2);
            }

            string sql = $@"
select A.FrID,A.Status,A.Type,A.Is_Cashier,E.ECOrderId,E.ECOrderDetailId,A.ReFinanceId2 from RB_Finance A 
inner join RB_ECFinanceId_Relation E on A.FrID = E.FinanceId
where {where} order by FrID desc
";
            return Get<RB_Finance_Extend>(sql).ToList();
        }

        /// <summary>
        /// 获取甲鹤活动报名订单所有财务单据
        /// </summary>
        /// <param name="model"></param>
        /// <returns></returns>
        public List<RB_Finance_Extend> GetListJH(RB_Finance_Extend model)
        {
            string where = "1=1 AND A.Is_Auto=0 ";
            where += string.Format(" AND A." + nameof(RB_Finance.Status) + " <> 4");
            //  where += string.Format(" AND E." + nameof(RB_Finance.Status) + " <> 4");
            //集团
            if (model.RB_Group_Id > 0)
            {
                where += string.Format(" AND A." + nameof(RB_Finance.RB_Group_Id) + " ={0}", model.RB_Group_Id);
            }
            //单据状态
            if (model.Status >= 0)
            {
                where += string.Format(" AND A." + nameof(RB_Finance.Status) + " ={0}", (int)model.Status);
            }
            if (model.Type > 0)
            {
                where += string.Format(" AND A." + nameof(RB_Finance.Type) + " ={0}", (int)model.Type);
            }
            //订单号
            if (model.OrderID > 0)
            {
                where += string.Format(" AND A." + nameof(RB_Finance.OrderID) + " ={0}", model.OrderID);
            }
            //对象类型
            if (model.ClientType > 0)
            {
                where += string.Format(" AND A." + nameof(RB_Finance.ClientType) + " ={0}", (int)model.ClientType);
            }
            //汇款人
            if (!string.IsNullOrEmpty(model.RemitterName))
            {
                where += string.Format(" AND A." + nameof(RB_Finance.RemitterName) + " like '%{0}%' ", model.RemitterName);
            }
            //付款对象
            if (model.ClientID > 0)
            {
                where += string.Format(" AND A." + nameof(RB_Finance.ClientID) + " ={0}", model.ClientID);
            }



            if (!string.IsNullOrEmpty(model.ReFinanceIds2))
            {
                where += string.Format(" AND A." + nameof(RB_Finance.ReFinanceId2) + " in({0})", model.ReFinanceIds2);
            }

            string sql = $@"
select A.* from RB_Finance A 
where {where} order by FrID desc
";
            return Get<RB_Finance_Extend>(sql).ToList();
        }


        /// <summary>
        /// 财务单据 主表查询
        /// </summary>
        /// <param name="model"></param>
        /// <returns></returns>
        public List<RB_Finance_Extend> GetListSingle(RB_Finance_Extend model)
        {
            string where = "1=1 AND A.Is_Auto=0 ";
            //单据ID
            if (model.FrID > 0)
            {
                where += string.Format(" AND A." + nameof(RB_Finance.FrID) + " ={0}", model.FrID);
            }
            //集团
            if (model.RB_Group_Id > 0)
            {
                where += string.Format(" AND A." + nameof(RB_Finance.RB_Group_Id) + " ={0}", model.RB_Group_Id);
            }
            if (model.RB_Branch_Id >= 0)
            {
                where += string.Format(" AND A." + nameof(RB_Finance.RB_Branch_Id) + " ={0}", model.RB_Branch_Id);
            }
            if (model.TCID > 0)
            {
                where += string.Format(" AND A.FrID in (select b.FinanceId from rb_travel_finance_relation as b where b.FinanceId=FrID and b.TCID=" + model.TCID + ")");
            }
            
            if (model.BankList != null && model.BankList.Count > 0)
            {
                where += string.Format(" AND A." + nameof(RB_Finance.FrID) + " in (SELECT b.FinanceId from rb_tradeway as b where b.FinanceId=A.FrID and Type=" + (int)model.BankList?.FirstOrDefault()?.Type + " and AccountId=" + model.BankList?.FirstOrDefault().AccountId + " Group By b.FinanceId) ");
            }
            //查询收款 并且账户类形一致的单据
            if (!string.IsNullOrWhiteSpace(model.AccountIdStr))
            {
                where += string.Format(" AND A." + nameof(RB_Finance.FrID) + " in (SELECT b.FinanceId from rb_tradeway as b where b.FinanceId=A.FrID and Type=1 and AccountId in(" + model.AccountIdStr + ") Group By b.FinanceId) ");
            }
            if (model.ClientID > 0)
            {
                where += string.Format(" AND A." + nameof(RB_Finance.ClientID) + " ={0}", model.ClientID);
            }
            if (!string.IsNullOrEmpty(model.sTradeDate))
            {
                where += string.Format(" AND A." + nameof(RB_Finance_Extend.TradeDate) + ">='{0}'", model.sTradeDate);
            }
            if (!string.IsNullOrEmpty(model.eTradeDate))
            {
                where += string.Format(" AND A." + nameof(RB_Finance_Extend.TradeDate) + "<='{0} 23:59:59'", model.eTradeDate);
            }
            if (model.Is_Cashier >= 0)
            {
                where += string.Format(" AND A." + nameof(RB_Finance_Extend.Is_Cashier) + "={0}", model.Is_Cashier);
            }
            if (model.OrderID > 0)
            {
                where += string.Format(" AND A." + nameof(RB_Finance.OrderID) + " ={0}", model.OrderID);
            }
            if (model.ReFinanceId > 0)
            {
                where += string.Format(" AND A." + nameof(RB_Finance.ReFinanceId) + " ={0}", model.ReFinanceId);
            }
            if (!string.IsNullOrWhiteSpace(model.OrderIdStr))
            {
                where += string.Format(" AND A." + nameof(RB_Finance.OrderID) + " in({0})", model.OrderIdStr);
            }
          
            if (model.Type > 0)
            {
                where += string.Format(" AND A." + nameof(RB_Finance.Type) + " ={0}", (int)model.Type);
            }
            if (model.FinanceType.HasValue && model.FinanceType > 0)
            {
                where += string.Format(" AND A." + nameof(RB_Finance.FinanceType) + " ={0}", model.FinanceType);
            }
            if (model.OtherType > 0)
            {
                where += string.Format(" AND A." + nameof(RB_Finance.OtherType) + " ={0}", model.OtherType);
            }
            if (model.ReFinanceId > 0)
            {
                where += string.Format(" AND A." + nameof(RB_Finance.ReFinanceId) + " ={0}", model.ReFinanceId);
            }
            if (model.Status > 0)
            {
                where += string.Format(" AND A." + nameof(RB_Finance.Status) + " ={0}", (int)model.Status);
            }
            if (model.OrderSource > 0)
            {
                where += string.Format(" AND A." + nameof(RB_Finance.OrderSource) + " ={0}", (int)model.OrderSource);
            }
            if (model.SourceID > 0)
            {
                where += string.Format(" AND A." + nameof(RB_Finance.SourceID) + " ={0}", model.SourceID);
            }
            if (!string.IsNullOrEmpty(model.AccountNumber))
            {
                where += string.Format(" AND A." + nameof(RB_Finance.AccountNumber) + " ='{0}'", model.AccountNumber);
            }
            if (!string.IsNullOrEmpty(model.FrIDs))
            {
                where += string.Format(" AND A." + nameof(RB_Finance.FrID) + " in ({0})", model.FrIDs);
            }
            if (!string.IsNullOrWhiteSpace(model.DijieOnlyCode))
            {
                where += string.Format(" AND A." + nameof(RB_Finance.DijieOnlyCode) + " ='{0}'", model.DijieOnlyCode);
            }
            if (model.IsSelectNormal == 1)
            {
                where += string.Format(" AND A." + nameof(RB_Finance.Status) + " in(1,2,5)");
            }
            string sql = string.Format(@"SELECT A.*  FROM {0} AS A WHERE {2} {3}", TableName, ReCordTableName, where, " GROUP BY A.FrID DESC");
            return Get<RB_Finance_Extend>(sql).ToList();
        }


    }
}
