﻿using Mall.Model.Entity.User;
using Mall.Model.Extend.User;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using VT.FW.DB.Dapper;

namespace Mall.Repository.User
{
    /// <summary>
    /// 商城插件表仓储层
    /// </summary>
    public class RB_Tenant_PlugRepository : BaseRepository<RB_Tenant_Plug>
    {
        /// <summary>
        ///  获取商城插件列表
        /// </summary>
        /// <param name="query"></param>
        /// <returns></returns>
        public List<RB_Tenant_Plug_Extend> GetTenantPlugListRepository(RB_Tenant_Plug_Extend query)
        {
            DynamicParameters parameters = new DynamicParameters();
            StringBuilder builder = new StringBuilder();
            builder.AppendFormat(@"
SELECT * 
FROM rb_tenant_plug
WHERE 1=1
");
            if (query == null)
            {
                return new List<RB_Tenant_Plug_Extend>();
            }
            else
            {
                if (query.TenantId > 0)
                {
                    builder.AppendFormat(@" AND {0}={1} ", nameof(RB_Tenant_Plug_Extend.TenantId), query.TenantId);
                }
                if (query.Id > 0)
                {
                    builder.AppendFormat(@" AND {0}={1} ", nameof(RB_Tenant_Plug_Extend.Id), query.Id);
                }
                if (!string.IsNullOrEmpty(query.PlugName))
                {
                    builder.AppendFormat(@" AND {0} LIKE @PlugName ", nameof(RB_Tenant_Plug_Extend.PlugName));
                    parameters.Add("PlugName", "%" + query.PlugName.Trim() + "%");
                }
            }
            return Get<RB_Tenant_Plug_Extend>(builder.ToString(), parameters).ToList();
        }
    }
}
