﻿using Mall.Model.Extend.TradePavilion;
using Mall.Repository.TradePavilion;
using System;
using System.Collections.Generic;
using System.Text;
using VT.FW.DB;

namespace Mall.Module.TradePavilion
{
    /// <summary>
    /// 联系人处理类
    /// </summary>
    public class ContractModule
    {
        /// <summary>
        /// 联系人仓储层对象
        /// </summary>
        private readonly RB_ContractRepository contractRepository = new RB_ContractRepository();

        /// <summary>
        /// 获取联系人人也列表
        /// </summary>
        /// <param name="pageIndex"></param>
        /// <param name="pageSize"></param>
        /// <param name="rowsCount"></param>
        /// <param name="query"></param>
        /// <returns></returns>
        public List<RB_Contract_Extend> GetContractPageListModule(int pageIndex, int pageSize, out long rowsCount, RB_Contract_Extend query)
        {
            return contractRepository.GetContractPageListRepository(pageIndex, pageSize, out rowsCount, query);
        }

        /// <summary>
        /// 获取联系人实体
        /// </summary>
        /// <param name="Id"></param>
        /// <returns></returns>
        public RB_Contract_Extend GetContractModule(object Id)
        {
            return contractRepository.GetEntity<RB_Contract_Extend>(Id);
        }

        /// <summary>
        /// 新增修改联系人
        /// </summary>
        /// <param name="model"></param>
        /// <returns></returns>
        public bool SetContractModule(RB_Contract_Extend model)
        {
            bool flag;
            if (model.Id > 0)
            {
                Dictionary<string, object> fileds = new Dictionary<string, object>()
                {
                    {nameof(RB_Contract_Extend.Name),model.Name },
                    {nameof(RB_Contract_Extend.Tel),model.Tel },
                    {nameof(RB_Contract_Extend.HeadIcon),model.HeadIcon },
                    {nameof(RB_Contract_Extend.BgImg),model.BgImg },
                    {nameof(RB_Contract_Extend.Position),model.Position },
                    {nameof(RB_Contract_Extend.Intro),model.Intro },
                    {nameof(RB_Contract_Extend.UpdateBy),model.UpdateBy },
                    {nameof(RB_Contract_Extend.UpdateDate),model.UpdateDate },
                };
                flag = contractRepository.Update(fileds, new WhereHelper(nameof(RB_Contract_Extend.Id), model.Id));
            }
            else
            {
                var newId = contractRepository.Insert(model);
                model.Id = newId;
                flag = newId > 0;
            }
            return flag;
        }

        /// <summary>
        /// 更新联系人状态
        /// </summary>
        /// <param name="Id"></param>
        /// <param name="Status"></param>
        /// <returns></returns>
        public bool RemoveContractModule(int Id, int Status)
        {
            Dictionary<string, object> fileds = new Dictionary<string, object>()
            {
                {nameof(RB_Contract_Extend.Status),Status },
            };
            bool flag = contractRepository.Update(fileds, new WhereHelper(nameof(RB_Contract_Extend.Id), Id));
            return flag;
        }
    }
}
