﻿using VT.FW.DB;
using System;
using System.Collections.Generic;
using System.Text;

namespace Mall.Model.Entity.BaseSetUp
{
    /// <summary>
    /// 发货的模板
    /// </summary>
    [Serializable]
    [DB(ConnectionName = "DefaultConnection")]
    public class RB_ShippingTemplate
    {
        /// <summary>
        /// 网点名称
        /// </summary>
        public int WebDot { get; set; }

        /// <summary>
        /// 网点联系人
        /// </summary>
        public int Name { get; set; }

        /// <summary>
        /// 网点联系方式
        /// </summary>
        public int Mobile { get; set; }

        /// <summary>
        /// 网点地址
        /// </summary>
        public int Address { get; set; }

        /// <summary>
        /// 网点邮编
        /// </summary>
        public int PostCode { get; set; }


        /// <summary>
        /// 订单号
        /// </summary>
        public int OrderId { get; set; }

        /// <summary>
        /// 订单时间
        /// </summary>
        public int OrderDate { get; set; }

        /// <summary>
        /// 打印日期
        /// </summary>
        public int PrintDate { get; set; }


        /// <summary>
        /// 商品序号
        /// </summary>
        public int GoodsSerial { get; set; }

        /// <summary>
        /// 商品名称
        /// </summary>
        public int GoodsName { get; set; }

        /// <summary>
        /// 规格
        /// </summary>
        public int Standard { get; set; }

        /// <summary>
        /// 数量
        /// </summary>
        public int GoodsNum { get; set; }

        /// <summary>
        /// 小计
        /// </summary>
        public int Subtotal { get; set; }

        /// <summary>
        /// 货号
        /// </summary>
        public int GoodsNo { get; set; }

        /// <summary>
        /// 单位
        /// </summary>
        public int Unit { get; set; }

        /// <summary>
        /// 订单金额
        /// </summary>
        public int OrderPrice { get; set; }


        /// <summary>
        /// 优惠
        /// </summary>
        public int DiscountsPrice { get; set; }

        /// <summary>
        /// 实付
        /// </summary>
        public int OrderPay { get; set; }

        /// <summary>
        /// 运费
        /// </summary>
        public int Freight { get; set; }

        /// <summary>
        /// 收货人昵称
        /// </summary>
        public int RecipientsNickName { get; set; }


        /// <summary>
        /// 收货人姓名
        /// </summary>
        public int RecipientsName { get; set; }


        /// <summary>
        /// 联系方式
        /// </summary>
        public int RecipientsMobile { get; set; }

        /// <summary>
        /// 支付方式
        /// </summary>
        public int PayType { get; set; }

        /// <summary>
        /// 发货方式
        /// </summary>
        public int DeliverType { get; set; }

        /// <summary>
        /// 收货地址
        /// </summary>
        public int DeliveryAddre { get; set; }

        /// <summary>
        /// 买家留言
        /// </summary>
        public int BuyerMessage { get; set; }

        /// <summary>
        /// 商家备注
        /// </summary>
        public int BusinessRemark { get; set; }
    }
}
