﻿using System;
using System.Collections.Generic;
using System.Text;
using Mall.Model.Extend.User;
using Mall.Repository;
using VT.FW.DB;

namespace Mall.Module.User
{
    /// <summary>
    /// 导航图标处理类
    /// </summary>
    public class MiniProgramNaviconModule
    {
        /// <summary>
        /// 导航图标仓储层对象
        /// </summary>
        private readonly Repository.User.RB_MiniProgram_NaviconRepository  naviconRepository = new Repository.User.RB_MiniProgram_NaviconRepository();

        /// <summary>
        /// 根据查询条件获取小程序导航图标列表
        /// </summary>
        /// <param name="query">查询条件</param>
        /// <returns></returns>
        public List<RB_MiniProgram_Navicon_Extend> GetMiniProgramNaviconListModule(RB_MiniProgram_Navicon_Extend query)
        {
            return naviconRepository.GetListRepository(query);
        }


        /// <summary>
        /// 获取小程序导航图标分页列表
        /// </summary>
        /// <param name="pageIndex">页码</param>
        /// <param name="pageSize">每页显示条数</param>
        /// <param name="rowCount">总条数</param>
        /// <param name="query">查询条件</param>
        /// <returns></returns>
        public List<RB_MiniProgram_Navicon_Extend> GetMiniProgramNaviconPageListModule(int pageIndex, int pageSize, out long rowCount, RB_MiniProgram_Navicon_Extend query)
        {
            return naviconRepository.GetPageListRepository(pageIndex, pageSize, out rowCount, query);
        }

        /// <summary>
        /// 添加修改小程序导航图标
        /// </summary>
        /// <param name="extModel"></param>
        /// <returns></returns>
        public bool SetMiniProgramNaviconModule(RB_MiniProgram_Navicon_Extend extModel)
        {
            bool flag;
            if (extModel.NavIconId > 0)
            {
                Dictionary<string, object> fileds = new Dictionary<string, object>()
                {
                    { nameof(RB_MiniProgram_Navicon_Extend.NavIconName),extModel.NavIconName},
                    { nameof(RB_MiniProgram_Navicon_Extend.NavIconImg),extModel.NavIconImg},
                    { nameof(RB_MiniProgram_Navicon_Extend.NavIconUrl),extModel.NavIconUrl},
                    { nameof(RB_MiniProgram_Navicon_Extend.NavIconSort),extModel.NavIconSort},
                    { nameof(RB_MiniProgram_Navicon_Extend.NavIconIsShow),extModel.NavIconIsShow},
                };
                flag = naviconRepository.Update(fileds, new WhereHelper(nameof(RB_MiniProgram_Navicon_Extend.NavIconId), extModel.NavIconId));
            }
            else
            {
                int NewId = naviconRepository.Insert(extModel);
                extModel.NavIconId = NewId;
                flag = NewId > 0;
            }
            return flag;
        }

        /// <summary>
        /// 删除小程序导航图标
        /// </summary>
        /// <param name="extModel"></param>
        /// <returns></returns>
        public bool RemoveMiniProgramNaviconModule(object NavIconId)
        {
            Dictionary<string, object> fileds = new Dictionary<string, object>()
            {
                { nameof(RB_MiniProgram_Navicon_Extend.NavIconStatus),1},
            };
            bool flag = naviconRepository.Update(fileds, new WhereHelper(nameof(RB_MiniProgram_Navicon_Extend.NavIconId), NavIconId));
            return flag;
        }

        /// <summary>
        /// 根据编号获取小程序导航
        /// </summary>
        /// <param name="NavIconId"></param>
        /// <returns></returns>
        public RB_MiniProgram_Navicon_Extend GetMiniProgramNaviconModule(object NavIconId)
        {
            RB_MiniProgram_Navicon_Extend extModel = naviconRepository.GetEntity<RB_MiniProgram_Navicon_Extend>(NavIconId);
            if (extModel == null)
            {
                extModel = new RB_MiniProgram_Navicon_Extend();
            }
            return extModel;
        } 
    }
}
