﻿using System;
using System.Collections.Generic;
using System.Text;
using Mall.Model.Entity.User;
using Mall.Model.Extend.User;
using System.Linq;
namespace Mall.Repository.User
{
    /// <summary>
    /// 导航图标仓储层对象
    /// </summary>
    public class RB_MiniProgram_NaviconRepository : RepositoryBase<RB_MiniProgram_Navicon>
    {
        /// <summary>
        /// 根据查询条件获取小程序导航图标列表
        /// </summary>
        /// <param name="query">查询条件</param>
        /// <returns></returns>
        public List<RB_MiniProgram_Navicon_Extend> GetListRepository(RB_MiniProgram_Navicon_Extend query)
        {
            StringBuilder builder = new StringBuilder();
            builder.Append(" SELECT * FROM RB_MiniProgram_Navicon WHERE 1=1 AND NavIconStatus=0 ");
            if (query != null)
            {
                if (query.MallBaseId != null && query.MallBaseId > 0)
                {
                    builder.AppendFormat(" AND MallBaseId={0} ", query.MallBaseId);
                }
            }
            builder.Append(" ORDER BY NavIconSort ASC ");
            return Get<RB_MiniProgram_Navicon_Extend>(builder.ToString()).ToList();
        }


        /// <summary>
        /// 获取小程序导航图标分页列表
        /// </summary>
        /// <param name="pageIndex">页码</param>
        /// <param name="pageSize">每页显示条数</param>
        /// <param name="rowCount">总条数</param>
        /// <param name="query">查询条件</param>
        /// <returns></returns>
        public List<RB_MiniProgram_Navicon_Extend> GetPageListRepository(int pageIndex, int pageSize, out long rowCount, RB_MiniProgram_Navicon_Extend query)
        {
            StringBuilder builder = new StringBuilder();
            builder.Append(" SELECT * FROM RB_MiniProgram_Navicon WHERE 1=1 AND NavIconStatus=0 ");
            if (query != null)
            {
                if (query.MallBaseId != null && query.MallBaseId > 0)
                {
                    builder.AppendFormat(" AND MallBaseId={0} ", query.MallBaseId);
                }
                if (query.NavIconName != null && !string.IsNullOrEmpty(query.NavIconName.Trim()))
                {
                    builder.AppendFormat(" AND NavIconName LIKE '{0}%' ", query.NavIconName.Trim());
                }
                if (query.NavIconIsShow != null && query.NavIconIsShow > -1)
                {
                    builder.AppendFormat(" AND NavIconIsShow={0} ", query.NavIconIsShow);
                }
            }
            builder.Append(" ORDER BY NavIconSort ASC ");
            return GetPage<RB_MiniProgram_Navicon_Extend>(pageIndex, pageSize, out rowCount, builder.ToString()).ToList();
        }
    }
}
