﻿using System;
using System.Threading;

namespace Mall.WindowsService.Helper
{
    public class TimersHelper
    {

        private static int inTimer6 = 0;
        private static int inTimer7 = 0;
        private static int inTimer8 = 0;
        private static int inTimer9 = 0;

        /// <summary>
        /// 收入单子服务开始执行方法
        /// </summary>
        /// <param name="sender"></param>
        /// <param name="e"></param>
        public void RevenueFinance(object sender, System.Timers.ElapsedEventArgs e)
        {
            DateTime now = DateTime.Now;
            if (now.Minute == 10)
            {
                Thread.Sleep(1000 * 60);
                LogHelper.Write("RevenueFinance=====Start");
                bool flag = Module.FinanceModule.OrderIncomeFinanceModule();
                LogHelper.Write("RevenueFinance=====End " + flag);
                #region 退款制单
                LogHelper.Write("AutoCreateFinanceRefund=====Start");
                flag = Module.FinanceModule.AutoCreateFinanceRefund();
                LogHelper.Write("AutoCreateFinanceRefund=====End " + flag);
                #endregion
                #region 分享商VIP过期时间
                LogHelper.Write("DistributorVipModule=====Start");
                flag = Module.FinanceModule.DistributorVipModule();
                LogHelper.Write("DistributorVipModule=====End " + flag);
                #endregion

                #region 电商统计

                if (now.Hour == 1)
                {
                    LogHelper.Write("UpdateToDayUserStatistics=====Start");
                    try
                    {
                        flag = new Module.UserStatisticsModule().UpdateToDayUserStatistics("", "");
                    }
                    catch (Exception ex)
                    {
                        flag = false;
                        LogHelper.Write("UpdateToDayUserStatistics：" + ex.Message);
                    }
                    LogHelper.Write("UpdateToDayUserStatistics=====End " + flag);
                }
                #endregion
            }
        }

        /// <summary>
        /// 自动取消订单【10分钟执行一次】
        /// </summary>
        /// <param name="sender"></param>
        /// <param name="e"></param>
        public void AutoCancelOrder(object sender, System.Timers.ElapsedEventArgs e)
        {
            DateTime now = DateTime.Now;
            if (now.Minute % 10 == 0)
            {
                Thread.Sleep(1000 * 60);
                LogHelper.Write("AutoCancelOrder=====Start");
                bool flag = Module.FinanceModule.AutoCancelOrder();
                LogHelper.Write("AutoCancelOrder=====End " + flag);
            }
        }

        /// <summary>
        /// 自动取消订单【10分钟执行一次】
        /// </summary>
        /// <param name="sender"></param>
        /// <param name="e"></param>
        public void AddWechatStatistics(object sender, System.Timers.ElapsedEventArgs e)
        {
            DateTime now = DateTime.Now;
            if (now.Hour <= 4 && now > Convert.ToDateTime("2024-12-06 00:00:00"))
            {
                Thread.Sleep(1000 * 60);
                LogHelper.Write("AddWechatStatistics=====Start");
                bool flag = Module.CuiPingModule.AddWechatStatistics();
                LogHelper.Write("AddWechatStatistics=====End " + flag);
            }
        }
        /// <summary>
        /// 自动收货订单
        /// </summary>
        /// <param name="sender"></param>
        /// <param name="e"></param>
        public void AutoReceivingOrder(object sender, System.Timers.ElapsedEventArgs e)
        {
            DateTime now = DateTime.Now;
            if (now.Minute == 20)
            {
                if (now.Hour == 1)
                {
                    LogHelper.Write("AutoReceivingOrder=====Start");
                    bool flag = Module.FinanceModule.AutoReceivingOrder();
                    LogHelper.Write("AutoReceivingOrder=====End " + flag);
                }
                Thread.Sleep(1000 * 60);
                LogHelper.Write("AutoAfterSaleOrderSendCommission=====Start");
                bool flag2 = Module.FinanceModule.AutoAfterSaleOrderSendCommission();
                LogHelper.Write("AutoAfterSaleOrderSendCommission=====End " + flag2);
            }
        }

        /// <summary>
        /// 七天自动取消下线【每天2:00执行一次】
        /// </summary>
        /// <param name="sender"></param>
        /// <param name="e"></param>
        public void AutoReleaseTheOffline(object sender, System.Timers.ElapsedEventArgs e)
        {
            DateTime now = DateTime.Now;
            if (now.Hour == 2 && now.Minute == 0)
            {
                Thread.Sleep(1000 * 60);
                LogHelper.Write("AutoReleaseTheOffline=====Start");
                Module.FinanceModule.AutoReleaseTheOffline();
                LogHelper.Write("AutoReleaseTheOffline=====End");
            }
        }

        /// <summary>
        /// 商品定时上架，下架
        /// </summary>
        /// <param name="sender"></param>
        /// <param name="e"></param>
        public void GoodsShelves(object sender, System.Timers.ElapsedEventArgs e)
        {
            DateTime now = DateTime.Now;
            if ((now.Minute + 5) % 10 == 0)
            {
                Thread.Sleep(1000 * 60);
                try
                {
                    string str = Common.Config.GetConnectionString("DefaultConnection");
                    LogHelper.Write("GoodsShelves=====Start" + str);
                    Module.GoodsShelvesModule.ShelvesGoodsModule();
                    Module.GoodsShelvesModule.DownGoodsModule();
                    LogHelper.Write("GoodsShelves=====End");
                }
                catch (Exception ex)
                {
                    LogHelper.Write("GoodsShelves=====ex" + ex.Message);
                }
            }
        }



        /// <summary>
        /// 资讯定时上架，下架【每30分钟执行一次】
        /// </summary>
        /// <param name="sender"></param>
        /// <param name="e"></param>
        public void EducationArticleShelves(object sender, System.Timers.ElapsedEventArgs e)
        {
            DateTime now = DateTime.Now;
            if ((now.Minute + 6) % 30 == 0)
            {
                try
                {
                    LogHelper.Write("EducationArticleShelves=====Start");
                    bool flag1 = Module.EducationArticleShelvesModule.ShelvesEducationArticleModule();
                    bool flag2 = Module.EducationArticleShelvesModule.DownEducationArticleModule();
                    LogHelper.Write("EducationArticleShelves=====End flag1:" + flag1 + " flag2:" + flag2);
                }
                catch (Exception ex)
                {
                    LogHelper.Write("EducationArticleShelves=====ex" + ex.Message);
                }
            }
        }


        /// <summary>
        ///用户储值卡赠送状态更新
        /// </summary>
        /// <param name="sender"></param>
        /// <param name="e"></param>
        public void MemberDepositBuyShelves(object sender, System.Timers.ElapsedEventArgs e)
        {
            if (Interlocked.Exchange(ref inTimer6, 1) == 0)
            {
                try
                {
                    string str = Common.Config.GetConnectionString("DefaultConnection");
                    LogHelper.Write("MemberDepositBuyShelves=====Start" + str);
                    Module.EducationArticleShelvesModule.MemberDepositBuyModule();
                    LogHelper.Write("MemberDepositBuyShelves=====End");
                }
                catch (Exception ex)
                {
                    LogHelper.Write("MemberDepositBuyShelves=====ex" + ex.Message);
                }
                Interlocked.Exchange(ref inTimer6, 0);
            }
        }

        /// <summary>
        ///用户储值卡赠送状态更新
        /// </summary>
        /// <param name="sender"></param>
        /// <param name="e"></param>
        public void DepositIncomeFinanceShelves(object sender, System.Timers.ElapsedEventArgs e)
        {
            if (Interlocked.Exchange(ref inTimer7, 1) == 0)
            {
                try
                {
                    string str = Common.Config.GetConnectionString("DefaultConnection");
                    LogHelper.Write("DepositIncomeFinanceShelves=====Start" + str);

                    Module.FinanceModule.DepositIncomeFinanceModule();
                    LogHelper.Write("DepositIncomeFinanceShelves=====End");
                }
                catch (Exception ex)
                {
                    LogHelper.Write("DepositIncomeFinanceShelves=====ex" + ex.Message);
                }
                Interlocked.Exchange(ref inTimer7, 0);
            }
        }

        /// <summary>
        ///相亲每日随机查询信息删除
        /// </summary>
        /// <param name="sender"></param>
        /// <param name="e"></param>
        public void DailyRandomShelves(object sender, System.Timers.ElapsedEventArgs e)
        {
            if (Interlocked.Exchange(ref inTimer8, 1) == 0)
            {
                try
                {
                    string str = Common.Config.GetConnectionString("DefaultConnection");
                    LogHelper.Write("DailyRandomShelves=====Start" + str);
                    Module.EducationArticleShelvesModule.DailyRandomModule();
                    LogHelper.Write("DailyRandomShelves=====End");
                }
                catch (Exception ex)
                {
                    LogHelper.Write("DailyRandomShelves=====ex" + ex.Message);
                }
                Interlocked.Exchange(ref inTimer8, 0);
            }
        }

        /// <summary>
        /// 赠送咖啡劵
        /// </summary>
        /// <param name="sender"></param>
        /// <param name="e"></param>
        public void EduInitFreeCoffee(object sender, System.Timers.ElapsedEventArgs e)
        {
            if (Interlocked.Exchange(ref inTimer9, 1) == 0)
            {
                if (DateTime.Now.ToString("dd HH:mm") == "01 00:01" || DateTime.Now.ToString("dd HH:mm") == "01 00:02")
                {
                    //每月1日 凌晨初始化 赠送咖啡劵
                    try
                    {
                        LogHelper.Write("赠送咖啡劵=====S");
                        Module.CoffeeModule.UpdateUserCoffeeFreeNum();
                        LogHelper.Write("赠送咖啡劵=====E");
                    }
                    catch (Exception ex)
                    {
                        LogHelper.Write("EduInitFreeCoffee=====ex" + ex.Message);
                    }
                }
                Interlocked.Exchange(ref inTimer9, 0);
            }
        }

    }
}
