﻿using Mall.DataHelper.Import;
using Mall.Repository.TradePavilion;
using Mall.ThirdCore.Oss;
using System;
using System.Collections.Generic;
using System.IO;
using System.Linq;

namespace TestCore
{
    class Program
    {
        static string rootPath = Path.Combine(Directory.GetCurrentDirectory(), "upfile");
        static string tempPath = rootPath + @"\TempImport\TempFile";
        static string ViewFileSiteUrl = "https://viitto-1301420277.cos.ap-chengdu.myqcloud.com";

        /// <summary>
        /// 分类仓储层
        /// </summary>
        private static RB_BrandClassRepository brandClassRepository = new RB_BrandClassRepository();

        /// <summary>
        /// 品牌仓储层
        /// </summary>
        private static RB_Brand_EnterpriseRepository brand_EnterpriseRepository = new RB_Brand_EnterpriseRepository();
        static void Main(string[] args)
        {
            Console.WriteLine("开始.." );
            int Type = 2;
            if (Type == 1)
            {
                BrandImport();
            }
            else if (Type == 2)
            {
                CarrierImport();
            }
            else if (Type == 3)
            {
                BuildingImport();
            }
            else
            {
                EnterpriseImport();
            }
            Console.WriteLine("结束..");
            Console.ReadKey();
        }

        /// <summary>
        /// 品牌导入
        /// </summary>
        static void BrandImport()
        {
            string brandFile = rootPath + @"\消费品牌导入.xlsx";
            Console.WriteLine("Start解析品牌文件...");
            var brandList = BrandHelper.ImportYBBrandData(brandFile, tempPath);
            Console.WriteLine("End解析品牌文件...");
            var categoryList = brandClassRepository.GetBrandClassListRepository(new Mall.Model.Extend.TradePavilion.RB_BrandClass_Extend() { });
            foreach (var item in brandList)
            {
                item.BrandEnterpriseType = 1;
                item.FullBrandName = item.BrandName;
                if (!string.IsNullOrEmpty(item.Logo))
                {
                    OssResult logoObj = SaveImg(item.Logo);
                    if (logoObj != null && logoObj.resultCode == 1)
                    {
                        item.Logo = ViewFileSiteUrl + logoObj.data;
                    }
                }
                if (!string.IsNullOrEmpty(item.Banner))
                {
                    List<string> bannerList = new List<string>();
                    var tempArray = item.Banner.Split(',');
                    if (tempArray != null && tempArray.Length > 0)
                    {
                        foreach (var tItem in tempArray)
                        {
                            if (!string.IsNullOrEmpty(tItem))
                            {
                                OssResult bObj = SaveImg(tItem);
                                if (bObj.resultCode == 1)
                                {
                                    bannerList.Add(ViewFileSiteUrl + bObj.data);
                                }
                            }
                        }
                    }
                    item.Banner = Mall.Common.Plugin.JsonHelper.Serialize(bannerList);
                }
                if (!string.IsNullOrEmpty(item.CategoryName))
                {
                    var tempCategory = categoryList.FirstOrDefault(qitem => qitem.ClassName.Trim() == item.CategoryName.Trim());
                    item.CategoryId = tempCategory?.ID ?? 0;
                }
                item.TenantId = 30;
                item.MallBaseId = 20;
                item.CreateBy = 30;
                item.CreateDate = DateTime.Now;
                item.UpdateBy = 30;
                item.UpdateDate = DateTime.Now;
            }
            bool flag = false;
            if (brandList != null && brandList.Count > 0)
            {
                flag= brand_EnterpriseRepository.InsertBatch(brandList);
            }
            Console.WriteLine("BrandImport::Flag_{0}  Params:{1} ", flag, Mall.Common.Plugin.JsonHelper.Serialize(brandList));
        }



        /// <summary>
        /// 商业载体导入
        /// </summary>
        static void CarrierImport()
        {
            string carrierFile = rootPath + @"\商业载体导入.xlsx";
            var carrierList = CarrierHelper.ImportYBCarrierData(carrierFile, tempPath);
            Console.WriteLine("CarrierImport::{0}", Mall.Common.Plugin.JsonHelper.Serialize(carrierList));
        }

        /// <summary>
        /// 楼宇导入
        /// </summary>
        static void BuildingImport()
        {
            string buildingFile = rootPath + @"\活力楼宇导入.xlsx";
            var buildingList = BuildingHelper.ImportYBuildingData(buildingFile, tempPath);
            Console.WriteLine("BuildingImport::{0}", Mall.Common.Plugin.JsonHelper.Serialize(buildingList));
        }

        /// <summary>
        /// 企业服务导入
        /// </summary>
        static void EnterpriseImport()
        {
            string enterpriseFile = rootPath + @"\企业服务导入.xlsx";
            var enterpriseList = EnterpriseServiceHelper.ImportYBEnterpriseData(enterpriseFile, tempPath);
            Console.WriteLine("EnterpriseImport::{0}", Mall.Common.Plugin.JsonHelper.Serialize(enterpriseList));
        }

        /// <summary>
        /// 上传图片
        /// </summary>
        /// <param name="path"></param>
        /// <returns></returns>
        static OssResult SaveImg(string path)
        {
            OssResult result = new OssResult();
            if (!string.IsNullOrEmpty(path))
            {
                result = UploadHelper.UploadFileToTencent(path);
            }
            return result;
        }
    }
}
