﻿using Mall.Model.Extend.Product;
using Mall.Repository.Product;
using System;
using System.Collections.Generic;
using System.Text;
using VT.FW.DB;
using System.Linq;
using Mall.Model.Entity.Product;

namespace Mall.Module.Product
{
    /// <summary>
    /// 拼团活动处理类
    /// </summary>
    public class GroupBuyConfigActivityModule
    {
        /// <summary>
        /// 拼团活动仓储层对象
        /// </summary>
        private readonly RB_Groupbuy_ActivityRepository groupbuy_ActivityRepository = new RB_Groupbuy_ActivityRepository();

        /// <summary>
        /// 拼团活动商品规格价格仓储层对象
        /// </summary>
        private RB_Groupbuy_Activity_SpecificationPriceRepository groupbuy_Activity_SpecificationPriceRepository = new RB_Groupbuy_Activity_SpecificationPriceRepository();

        /// <summary>
        /// 拼团活动商品关联规格值仓储层对象
        /// </summary>
        private RB_Groupbuy_Activity_SpecificationValueRepository groupbuy_Activity_SpecificationValueRepository = new RB_Groupbuy_Activity_SpecificationValueRepository();

        /// <summary>
        /// 拼团商品关联规格仓储层对象
        /// </summary>
        private RB_Groupbuy_Activity_SpecificationRepository groupbuy_Activity_SpecificationRepository = new RB_Groupbuy_Activity_SpecificationRepository();

        /// <summary>
        /// 阶梯团仓储层对象
        /// </summary>
        private RB_Groupbuy_Activity_StepRepository stepRepository = new RB_Groupbuy_Activity_StepRepository();

        /// <summary>
        /// 获取拼团活动阶梯价列表
        /// </summary>
        /// <param name="query"></param>
        /// <returns></returns>
        public List<RB_Groupbuy_Activity_Step_Extend> GetGroupBuyActivityListRepository(RB_Groupbuy_Activity_Step_Extend query)
        {
            return stepRepository.GetGroupBuyActivityListRepository(query);
        }

        /// <summary>
        /// 获取拼团活动商品规格价格列表
        /// </summary>
        /// <param name="dmodel">查询条件</param>
        /// <returns></returns>
        public List<RB_Groupbuy_Activity_Specificationprice_Extend> GetGroupbuyActivitySpecificationpriceListModule(RB_Groupbuy_Activity_Specificationprice_Extend dmodel)
        {
            return groupbuy_Activity_SpecificationPriceRepository.GetGroupbuyActivitySpecificationpriceListRepository(dmodel);
        }

        /// <summary>
        /// 获取拼团活动商品关联规格值列表
        /// </summary>
        /// <param name="dmodel">查询条件</param>
        /// <returns></returns>
        public List<RB_Groupbuy_Activity_Specificationvalue_Extend> GetGroupbuyActivitySpecificationValueListModule(RB_Groupbuy_Activity_Specificationvalue_Extend dmodel)
        {
            return groupbuy_Activity_SpecificationValueRepository.GetGroupbuyActivitySpecificationValueListRepository(dmodel);
        }

        /// <summary>
        /// 获取拼团商品关联规格列表
        /// </summary>
        /// <param name="dmodel">查询条件</param>
        /// <returns></returns>
        public List<RB_Groupbuy_Activity_Specification_Extend> GetGroupbuyActivitySpecificationListModule(RB_Groupbuy_Activity_Specification_Extend dmodel)
        {
            return groupbuy_Activity_SpecificationRepository.GetGroupbuyActivitySpecificationListRepository(dmodel);
        }


        /// <summary>
        ///  获取拼团活动分页列表
        /// </summary>
        /// <param name="pageIndex">页码</param>
        /// <param name="pageSize">每页显示条数</param>
        /// <param name="rowsCount">总条数</param>
        /// <param name="query">查询条件</param>
        /// <returns></returns>
        public List<RB_Groupbuy_Activity_Extend> GetGroupbuyActivityPageListModule(int pageIndex, int pageSize, out long rowsCount, RB_Groupbuy_Activity_Extend query)
        {
            var list = groupbuy_ActivityRepository.GetGroupbuyActivityPageListRepository(pageIndex, pageSize, out rowsCount, query);
            if (list != null && list.Count > 0)
            {
                string Ids = string.Join(",", list.Select(qitem => qitem.ActivityId));
                if (!string.IsNullOrEmpty(Ids))
                {

                }
            }
            return list;
        }

        /// <summary>
        /// 获取活动实体类
        /// </summary>
        /// <param name="query"></param>
        /// <param name="isGetSpec">是否获取规格信息</param>
        /// <returns></returns>
        public RB_Groupbuy_Activity_Extend GetGroupbuyActivityEntityModule(RB_Groupbuy_Activity_Extend query, bool isGetSpec = false)
        {
            var extModel = groupbuy_ActivityRepository.GetGroupbuyActivityEntityRepository(query);
            if (extModel == null)
            {
                extModel = new RB_Groupbuy_Activity_Extend();
            }
            if (isGetSpec)
            {
                //获取规格列表
                List<RB_Groupbuy_Activity_Specification_Extend> specificationList = GetGroupbuyActivitySpecificationListModule(new RB_Groupbuy_Activity_Specification_Extend()
                {
                    MallBaseId = query.MallBaseId,
                    TenantId = query.TenantId,
                    GoodsId = extModel.GoodId,
                });

                //规格值列表
                List<RB_Groupbuy_Activity_Specificationvalue_Extend> specificationvalueList = GetGroupbuyActivitySpecificationValueListModule(new RB_Groupbuy_Activity_Specificationvalue_Extend()
                {
                    MallBaseId = query.MallBaseId,
                    TenantId = query.TenantId,
                    GoodsId = extModel.GoodId,
                });
                if (specificationList != null && specificationList.Count > 0)
                {
                    foreach (var item in specificationList)
                    {
                        item.SpecificationValueList = specificationvalueList?.Where(qitem => qitem.SpecificationId == item.Id)?.ToList() ?? new List<RB_Groupbuy_Activity_Specificationvalue_Extend>();
                    }
                }

                //拼团价格列表
                List<RB_Groupbuy_Activity_Specificationprice_Extend> specificationpriceList = GetGroupbuyActivitySpecificationpriceListModule(new RB_Groupbuy_Activity_Specificationprice_Extend()
                {
                    MallBaseId = query.MallBaseId,
                    TenantId = query.TenantId,
                    GoodsId = extModel.GoodId,
                });
                //拼团阶梯价格列表
                List<RB_Groupbuy_Activity_Step_Extend> groupStepList = GetGroupBuyActivityListRepository(new RB_Groupbuy_Activity_Step_Extend()
                {
                    MallBaseId = query.MallBaseId,
                    TenantId = query.TenantId,
                    GoodId = extModel.GoodId,
                });
                extModel.SpecificationList = specificationList;
                extModel.SpecificationPriceList = specificationpriceList;
                extModel.GroupList = groupStepList;
            }
            return extModel;
        }

        /// <summary>
        /// 新增修改拼团活动
        /// </summary>
        /// <param name="extModel"></param>
        /// <returns></returns>
        public bool SetGroupbuyActivityModule(RB_Groupbuy_Activity_Extend extModel)
        {
            bool flag = false;
            if (extModel.ActivityId > 0)
            {
                Dictionary<string, object> fileds = new Dictionary<string, object>()
                {
                    { nameof(RB_Groupbuy_Activity_Extend.StartTime),extModel.StartTime},
                    { nameof(RB_Groupbuy_Activity_Extend.EndTime),extModel.EndTime},
                    { nameof(RB_Groupbuy_Activity_Extend.GoodId),extModel.GoodId},
                    { nameof(RB_Groupbuy_Activity_Extend.GoodsStatus),extModel.GoodsStatus},
                    { nameof(RB_Groupbuy_Activity_Extend.SellingPrice),extModel.SellingPrice},
                    { nameof(RB_Groupbuy_Activity_Extend.Original_Price),extModel.Original_Price},
                    { nameof(RB_Groupbuy_Activity_Extend.Goods_Stock),extModel.Goods_Stock},
                    { nameof(RB_Groupbuy_Activity_Extend.Goods_unit),extModel.Goods_unit},
                    { nameof(RB_Groupbuy_Activity_Extend.Goods_no),extModel.Goods_no},
                    { nameof(RB_Groupbuy_Activity_Extend.Goods_weight),extModel.Goods_weight},
                    { nameof(RB_Groupbuy_Activity_Extend.Sort),extModel.Sort},
                    { nameof(RB_Groupbuy_Activity_Extend.Is_Auto_Add_Robot),extModel.Is_Auto_Add_Robot},
                    { nameof(RB_Groupbuy_Activity_Extend.Virtual_Sales),extModel.Virtual_Sales},
                    { nameof(RB_Groupbuy_Activity_Extend.Is_Alone_Buy),extModel.Is_Alone_Buy},
                    { nameof(RB_Groupbuy_Activity_Extend.IsDefaultService),extModel.IsDefaultService},
                    { nameof(RB_Groupbuy_Activity_Extend.GoodsService),extModel.GoodsService},
                    { nameof(RB_Groupbuy_Activity_Extend.FreightId),extModel.FreightId},
                    { nameof(RB_Groupbuy_Activity_Extend.FormsId),extModel.FormsId},
                    { nameof(RB_Groupbuy_Activity_Extend.Confine_Count),extModel.Confine_Count},
                    { nameof(RB_Groupbuy_Activity_Extend.Confine_Order_Count),extModel.Confine_Order_Count},
                    { nameof(RB_Groupbuy_Activity_Extend.Pieces),extModel.Pieces},
                    { nameof(RB_Groupbuy_Activity_Extend.Forehead),extModel.Forehead},
                    { nameof(RB_Groupbuy_Activity_Extend.Is_Area_Limit),extModel.Is_Area_Limit},
                    { nameof(RB_Groupbuy_Activity_Extend.Area_limit),extModel.Area_limit},
                    { nameof(RB_Groupbuy_Activity_Extend.Is_quick_shop),extModel.Is_quick_shop},
                    { nameof(RB_Groupbuy_Activity_Extend.Give_integral),extModel.Give_integral},
                    { nameof(RB_Groupbuy_Activity_Extend.Give_integral_type),extModel.Give_integral_type},
                    { nameof(RB_Groupbuy_Activity_Extend.Is_forehead_integral),extModel.Is_forehead_integral},
                    { nameof(RB_Groupbuy_Activity_Extend.Forehead_integral_type),extModel.Forehead_integral_type},
                    { nameof(RB_Groupbuy_Activity_Extend.Accumulative),extModel.Accumulative},
                    { nameof(RB_Groupbuy_Activity_Extend.CardIds),extModel.CardIds},
                    { nameof(RB_Groupbuy_Activity_Extend.App_share_title),extModel.App_share_title},
                    { nameof(RB_Groupbuy_Activity_Extend.App_share_pic),extModel.App_share_pic},
                };
                flag = groupbuy_ActivityRepository.Update(fileds, new WhereHelper(nameof(RB_Groupbuy_Activity_Extend.ActivityId), extModel.ActivityId));
            }
            else
            {
                var newId = groupbuy_ActivityRepository.Insert(extModel);
                extModel.ActivityId = newId;
                flag = newId > 0;
            }
            return flag;
        }
    }
}
