﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using Mall.Common;
using Mall.Common.Plugin;
using Mall.Model.Entity.User;
using Mall.Model.Extend.User;
using Mall.Repository;
using Mall.Repository.User;
using Mall.Repository.Product;
using Mall.Model.Extend.Product;
using Microsoft.Extensions.Configuration;
using Microsoft.Extensions.Configuration.Json;
using Newtonsoft.Json;
using Mall.Repository.BaseSetUp;
using Mall.Common.Enum.User;
using Mall.Common.API;
using Newtonsoft.Json.Linq;
using System.Threading;
using Mall.Repository.Finance;
using NPOI.SS.Formula.Functions;
using VT.FW.DB;

namespace Mall.Module.User
{
    /// <summary>
    /// 微店处理层
    /// </summary>
    public class SmallShopsModule
    {
        /// <summary>
        /// 用户管理
        /// </summary>
        private readonly RB_Member_UserRepository member_UserRepository = new RB_Member_UserRepository();
        /// <summary>
        /// 小程序
        /// </summary>
        private readonly RB_MiniProgramRepository miniProgramRepository = new RB_MiniProgramRepository();
        /// <summary>
        /// 微店
        /// </summary>
        private readonly RB_SmallShops_InfoRepository smallShops_InfoRepository = new RB_SmallShops_InfoRepository();
        /// <summary>
        /// 微店价格
        /// </summary>
        private readonly RB_SmallShops_PriceRepository smallShops_PriceRepository = new RB_SmallShops_PriceRepository();


        #region 微店管理

        /// <summary>
        /// 获取微店分页列表
        /// </summary>
        /// <param name="pageIndex"></param>
        /// <param name="pageSize"></param>
        /// <param name="count"></param>
        /// <param name="demodel"></param>
        /// <returns></returns>
        public List<RB_SmallShops_Info_Extend> GetSmallShopsPageList(int pageIndex, int pageSize, out long count, RB_SmallShops_Info_Extend demodel)
        {
            var list = smallShops_InfoRepository.GetPageList(pageIndex, pageSize, out count, demodel);
            return list;
        }
        /// <summary>
        /// 获取下拉
        /// </summary>
        /// <param name="pageIndex"></param>
        /// <param name="pageSize"></param>
        /// <param name="count"></param>
        /// <param name="demodel"></param>
        /// <returns></returns>
        public List<RB_SmallShops_Info_Extend> GetSmallShopsDropDownList(int pageIndex, int pageSize, out long count, RB_SmallShops_Info_Extend demodel)
        {
            return smallShops_InfoRepository.GetSmallShopsDropDownList(pageIndex, pageSize, out count, demodel);
        }
        /// <summary>
        /// 获取微店信息
        /// </summary>
        /// <param name="smallShopsId"></param>
        /// <returns></returns>
        public RB_SmallShops_Info_Extend GetSmallShopsInfo(int smallShopsId)
        {
            var model = smallShops_InfoRepository.GetEntity<RB_SmallShops_Info_Extend>(smallShopsId);
            model.NickName = member_UserRepository.GetEntity(model?.UserId ?? 0)?.Name ?? "";
            return model;
        }
        /// <summary>
        /// 微店审核
        /// </summary>
        /// <param name="ssmodel"></param>
        /// <param name="type"></param>
        /// <returns></returns>
        public bool SetSmallShopsAudit(RB_SmallShops_Info_Extend ssmodel, int type)
        {
            Dictionary<string, object> keyValues = new Dictionary<string, object>() {
                { nameof(RB_SmallShops_Info.UpdateDate),DateTime.Now}
            };
            if (type == 1)
            {
                keyValues.Add(nameof(RB_SmallShops_Info.AuditStatus), DistributorAuditStatusEnum.Audited);
                keyValues.Add(nameof(RB_SmallShops_Info.AuditDate), DateTime.Now);
            }
            else if (type == 2)
            {
                keyValues.Add(nameof(RB_SmallShops_Info.AuditStatus), DistributorAuditStatusEnum.Reject);
            }
            else if (type == 3)
            {
                keyValues.Add(nameof(RB_SmallShops_Info.Remark), ssmodel.Remark);
            }
            else {
                return false;
            }

            List<WhereHelper> wheres = new List<WhereHelper>() {
                new WhereHelper(){
                     FiledName=nameof(RB_SmallShops_Info.Id),
                      FiledValue=ssmodel.Id,
                       OperatorEnum=OperatorEnum.Equal
                }
            };

            return smallShops_InfoRepository.Update(keyValues, wheres);
        }

        /// <summary>
        /// 修改店铺佣金
        /// </summary>
        /// <param name="smallShopsId"></param>
        /// <param name="commission"></param>
        /// <param name="tenantId"></param>
        /// <param name="mallBaseId"></param>
        /// <returns></returns>
        public bool SetSmallShopsCommission(int smallShopsId, decimal commission, int tenantId, int mallBaseId,int empId)
        {
            var model = smallShops_InfoRepository.GetEntity(smallShopsId);
            if (model == null) { return false; }
            Dictionary<string, object> keyValues = new Dictionary<string, object>() {
                { nameof(RB_SmallShops_Info.UpdateDate),DateTime.Now},
                { nameof(RB_SmallShops_Info.Commission),commission},
                { nameof(RB_SmallShops_Info.Remark),model.Remark +" EmpId:"+empId+"修改佣金：由"+(model.Commission??0)+"=>"+commission},
            };

            List<WhereHelper> wheres = new List<WhereHelper>() {
                new WhereHelper(){
                     FiledName=nameof(RB_SmallShops_Info.Id),
                      FiledValue=smallShopsId,
                       OperatorEnum=OperatorEnum.Equal
                }
            };

            return smallShops_InfoRepository.Update(keyValues, wheres);
        }

        #endregion
    }
}
