﻿using VT.FW.DB;
using Mall.Common.Enum.MarketingCenter;
using System;
using System.Collections.Generic;
using System.Text;
using Mall.Common.Enum.Goods;
using Mall.Common.Enum.User;

namespace Mall.Model.Entity.Education
{
    /// <summary>
    ///  教育-资讯评论管理实体表
    /// </summary>
    [Serializable]
    [DB(ConnectionName = "DefaultConnection")]
    public class RB_Education_ArticleComment
    {

        public int ID { get; set; }

        /// <summary>
        /// 商户id
        /// </summary>
        public int TenantId { get; set; }

        /// <summary>
        /// 小程序id
        /// </summary>
        public int MallBaseId { get; set; }


        public int Status { get; set; }

        public DateTime? CreateDate { get; set; }
        public DateTime UpdateDate { get; set; }



        /// <summary>
        /// 用户id
        /// </summary>        
        public int? UserId
        {
            get;
            set;
        }
        /// <summary>
        /// 资讯id
        /// </summary>        
        public int ArticleId
        {
            get;
            set;
        }


        /// <summary>
        /// 客人名称
        /// </summary>        
        public string UserName
        {
            get;
            set;
        }
        /// <summary>
        /// 用户头像
        /// </summary>        
        public int? UserPhoto
        {
            get;
            set;
        }
        /// <summary>
        /// 评论类型  1 好评  2中评   3差评
        /// </summary>        
        public GoodsCommentTypeEnum? CommentGrade
        {
            get;
            set;
        }
        /// <summary>
        /// 评分 1-5分
        /// </summary>
        public int? CommentScore { get; set; }


        /// <summary>
        /// 评论内容
        /// </summary>        
        public string Content
        {
            get;
            set;
        }
        /// <summary>
        /// 评论图片
        /// </summary>        
        public string CommentImage
        {
            get;
            set;
        }
        /// <summary>
        /// 回复
        /// </summary>        
        public string Reply
        {
            get;
            set;
        }
        /// <summary>
        /// 来源
        /// </summary>        
        public UserSourceEnum? PlatformSource
        {
            get;
            set;
        }
        /// <summary>
        /// 是否置顶  1是  2否
        /// </summary>        
        public int? Is_Top
        {
            get;
            set;
        }
        /// <summary>
        /// 是否显示   1是  2否
        /// </summary>        
        public int? Is_Show
        {
            get;
            set;
        }
        /// <summary>
        /// 是否匿名  1是  2否
        /// </summary>        
        public int? Is_Anonymity
        {
            get;
            set;
        }


    }
}
