﻿using Mall.Model.Entity.GuideCar;
using Mall.Model.Entity.Product;
using Mall.Model.Extend.Product;
using System;
using System.Collections.Generic;
using System.Text;
using VT.FW.DB;

namespace Mall.Model.Extend.GuideCar
{
    /// <summary>
    /// 司导-导游扩展表
    /// </summary>
    [Serializable]
    [DB(ConnectionName = "DefaultConnection")]
    public class RB_GuideCar_Guide_Extend : RB_GuideCar_Guide
    {
        /// <summary>
        /// 导游ids
        /// </summary>
        public string GuideIds { get; set; }
        /// <summary>
        /// 站点名称
        /// </summary>
        public string SiteName { get; set; }

        /// <summary>
        /// 订单数
        /// </summary>
        public int OrderNum { get; set; }

        /// <summary>
        /// 订单人数
        /// </summary>
        public int OrderGuestNum { get; set; }

        /// <summary>
        /// 商品数
        /// </summary>
        public int GoodsNum { get; set; }

        /// <summary>
        /// 关联商品
        /// </summary>
        public List<RB_Goods_Extend> GoodsList { get; set; }

        /// <summary>
        /// 开始时间
        /// </summary>
        public string StartTime { get; set; }
        /// <summary>
        /// 结束时间
        /// </summary>
        public string EndTime { get; set; }


        /// <summary>
        /// 开始年限
        /// </summary>
        public decimal? StartWorkYears { get; set; }
        /// <summary>
        /// 结束年限
        /// </summary>
        public decimal? EndWorkYears { get; set; }


        /// <summary>
        /// 开始评分
        /// </summary>
        public decimal? StartScore { get; set; }
        /// <summary>
        /// 结束评分
        /// </summary>
        public decimal? EndScore { get; set; }
    }
}
