﻿using System;
using System.Collections.Generic;
using System.Text;
using Mall.Model.Extend.User;
using Mall.Repository;
using Mall.Repository.User;
using VT.FW.DB;

namespace Mall.Module.User
{
    /// <summary>
    /// 菜单处理类
    /// </summary>
    public class MenuModule
    {
        /// <summary>
        /// 菜单仓储层对象
        /// </summary>
        private readonly RB_MenuRepository menuRepository = new RB_MenuRepository();

        /// <summary>
        /// 根据查询条件获取菜单列表
        /// </summary>
        /// <param name="query">查询条件</param>
        /// <returns></returns>
        public List<RB_Menu_Extend> GetMenuListModule(RB_Menu_Extend query)
        {
            return menuRepository.GetListRepository(query);
        }

        /// <summary>
        /// 获取菜单分页列表
        /// </summary>
        /// <param name="pageIndex">页码</param>
        /// <param name="pageSize">每页显示条数</param>
        /// <param name="rowCount">总条数</param>
        /// <param name="query">查询条件</param>
        /// <returns></returns>
        public List<RB_Menu_Extend> GetMenuPageListModule(int pageIndex, int pageSize, out long rowCount, RB_Menu_Extend query)
        {
            return menuRepository.GetPageListRepository(pageIndex, pageSize, out rowCount, query);
        }

        /// <summary>
        /// 新增修改菜单
        /// </summary>
        /// <param name="extModel"></param>
        /// <returns></returns>
        public bool SetMenuModule(RB_Menu_Extend extModel)
        {
            bool flag;
            if (extModel.MenuId > 0)
            {
                Dictionary<string, object> fileds = new Dictionary<string, object>()
                {
                    { nameof(RB_Menu_Extend.MenuName),extModel.MenuName.Trim()},
                    { nameof(RB_Menu_Extend.MenuUrl),extModel.MenuUrl.Trim()},
                    { nameof(RB_Menu_Extend.MenuLevel),extModel.MenuLevel},
                    { nameof(RB_Menu_Extend.ParentId),extModel.ParentId},
                    { nameof(RB_Menu_Extend.IconClass),extModel.IconClass},
                    { nameof(RB_Menu_Extend.SortNum),extModel.SortNum},
                };
                flag = menuRepository.Update(fileds, new WhereHelper(nameof(RB_Menu_Extend.MenuId), extModel.MenuId));
            }
            else
            {
                extModel.CreateDate = DateTime.Now;
                int NewId = menuRepository.Insert(extModel);
                extModel.MenuId = NewId;
                flag = NewId > 0;
            }
            return flag;
        }

        /// <summary>
        /// 删除菜单
        /// </summary>
        /// <param name="MenuId">菜单编号</param>
        /// <param name="Status">菜单状态</param>
        /// <returns></returns>
        public bool RemoveMenuModule(object MenuId, int Status)
        {
            Dictionary<string, object> fileds = new Dictionary<string, object>()
            {
                { nameof(RB_Menu_Extend.Status),Status},
            };
            bool flag = menuRepository.Update(fileds, new WhereHelper(nameof(RB_Menu_Extend.MenuId), MenuId));
            return flag;
        }

        /// <summary>
        /// 根据编号获取菜单实体
        /// </summary>
        /// <param name="MenuId">菜单编号</param>
        /// <returns></returns>
        public RB_Menu_Extend GetMenuModule(object MenuId)
        {
            RB_Menu_Extend extModel = menuRepository.GetEntity<RB_Menu_Extend>(MenuId);
            if (extModel == null)
            {
                extModel = new RB_Menu_Extend();
            }
            return extModel;
        }

    }
}
