﻿using System;
using System.Collections.Generic;
using System.Text;
using Mall.Model.Entity.Product;
using Mall.Model.Extend.Product;
using System.Linq;

namespace Mall.Repository.Product
{
    /// <summary>
    /// 商品购物车仓储层
    /// </summary>
    public class RB_Goods_ShoppingCartRepository : BaseRepository<RB_Goods_ShoppingCart>
    {

        /// <summary>
        /// 分页列表
        /// </summary>
        /// <param name="pageIndex">页码</param>
        /// <param name="pageSize">每页显示条数</param>
        /// <param name="rowCount">总条数</param>
        /// <param name="dmodel">查询条件</param>
        /// <returns></returns>
        public List<RB_Goods_ShoppingCart_Extend> GetPageList(int pageIndex, int pageSize, out long rowCount, RB_Goods_Extend dmodel)
        {
            string where = $" 1=1 and sc.{nameof(RB_Goods_ShoppingCart.Status)}=0";
            if (dmodel.TenantId > 0) {
                where += $@" and sc.{nameof(RB_Goods_ShoppingCart.TenantId)}={dmodel.TenantId}";
            }
            if (dmodel.MallBaseId > 0) {
                where += $@" and sc.{nameof(RB_Goods_ShoppingCart.MallBaseId)}={dmodel.MallBaseId}";
            }

            if (dmodel.UserId > 0) {
                where += $@" and sc.{nameof(RB_Goods_ShoppingCart.UserId)}={dmodel.UserId}";
            }
            if (!string.IsNullOrEmpty(dmodel.GoodsIds)) {
                where += $@" and g.{nameof(RB_Goods_Extend.Id)} in({dmodel.GoodsIds})";
            }
            if (!string.IsNullOrEmpty(dmodel.Name)) {
                where += $@" and g.{nameof(RB_Goods_Extend.Name)} like '%{dmodel.Name}%'";
            }
            if (dmodel.GoodsStatus > 0) {
                where += $@" and g.{nameof(RB_Goods_Extend.GoodsStatus)}={dmodel.GoodsStatus}";
            }
            if (dmodel.GoodsClassify >= 0)
            {
                where += $@" and g.{nameof(RB_Goods_Extend.GoodsClassify)}={dmodel.GoodsClassify}";
            }

            string sql = $@"select sc.*,g.Name as GoodsName,g.GoodsStatus,g.CarouselImage,g.SellingPrice as Price,g.IsCustomSpecification,g.DefaultSpecificationName,
g.EnjoyMember,g.SeparateSetMember,g.InventoryNum,g.FullNumPinkage,g.FullMoneyPinkage,g.MarketingLogo,g.CourseScore from RB_Goods_ShoppingCart sc
inner join RB_Goods g on sc.GoodsId=g.Id
where {where} order by g.GoodsStatus asc,sc.CreateDate desc";
            return GetPage<RB_Goods_ShoppingCart_Extend>(pageIndex, pageSize, out rowCount, sql).ToList();
        }

        public List<RB_Goods_ShoppingCart_Extend> GetList(RB_Goods_ShoppingCart_Extend dmodel) {
            string where = $" 1=1 and {nameof(RB_Goods_ShoppingCart.Status)}=0";
            if (dmodel.TenantId > 0)
            {
                where += $@" and {nameof(RB_Goods_ShoppingCart.TenantId)}={dmodel.TenantId}";
            }
            if (dmodel.MallBaseId > 0)
            {
                where += $@" and {nameof(RB_Goods_ShoppingCart.MallBaseId)}={dmodel.MallBaseId}";
            }
            if (dmodel.UserId > 0)
            {
                where += $@" and {nameof(RB_Goods_ShoppingCart.UserId)}={dmodel.UserId}";
            }
            if (dmodel.GoodsId > 0)
            {
                where += $@" and {nameof(RB_Goods_ShoppingCart.GoodsId)}={dmodel.GoodsId}";
            }
            if (!string.IsNullOrEmpty(dmodel.SpecificationSort)) 
            {
                where += $@" and {nameof(RB_Goods_ShoppingCart.SpecificationSort)}='{dmodel.SpecificationSort}'";
            }

            string sql = $@"SELECT * FROM RB_Goods_ShoppingCart where {where} order by Id asc";
            return Get<RB_Goods_ShoppingCart_Extend>(sql).ToList();
        }
    }
}
