﻿using VT.FW.DB;
using System;
using System.Collections.Generic;
using System.Text;

namespace Mall.Model.Query
{

    /// <summary>
    /// 订单统计
    /// </summary>
    [Serializable]
    [DB(ConnectionName = "DefaultConnection")]
    public class OrderStatistics_Query
    {

        public int TenantId { get; set; }

        public int MallBaseId { get; set; }

        /// <summary>
        /// 订单号
        /// </summary>
        public string OrderNo { get; set; }

        /// <summary>
        /// 商品名称
        /// </summary>
        public string GoodsName { get; set; }


        /// <summary>
        /// 商品id
        /// </summary>
        public int GoodsID { get; set; }

        /// <summary>
        /// 规格
        /// </summary>
        public string Specification { get; set; }

        /// <summary>
        /// 单价
        /// </summary>
        public decimal Unit_Price { get; set; }

        /// <summary>
        /// 数量
        /// </summary>
        public int Number { get; set; }

        /// <summary>
        /// 返佣人员id
        /// </summary>
        public int OneUserId { get; set; }
        /// <summary>
        /// 返佣人员名称
        /// </summary>
        public string OneUserName { get; set; }

        /// <summary>
        /// 返佣人员id
        /// </summary>
        public int TwoUserId { get; set; }
        /// <summary>
        /// 返佣人员名称
        /// </summary>
        public string TwoUserName { get; set; }


        /// <summary>
        /// 供应商名称
        /// </summary>
        public string SupplierName { get; set; }



        /// <summary>
        /// 供应商名称
        /// </summary>
        public int SupplierId { get; set; }


        /// <summary>
        /// 特一级返佣
        /// </summary>
        public decimal SpecialCommission { get; set; }

        /// <summary>
        /// 总代理返佣
        /// </summary>
        public decimal GeneralAgentCommission { get; set; }


        /// <summary>
        /// 分公司
        /// </summary>
        public decimal BranchCommission { get; set; }

        /// <summary>
        /// 分公司
        /// </summary>
        public string BranchName { get; set; }

        /// <summary>
        /// 特一级返佣
        /// </summary>
        public string SpecialName { get; set; }

        /// <summary>
        /// 总代理返佣
        /// </summary>
        public string GeneralAgentName { get; set; }



        /// <summary>
        /// 结算款
        /// </summary>
        public decimal Final_Price { get; set; }

        /// <summary>
        /// 运费
        /// </summary>
        public string FreightMoney { get; set; }


        /// <summary>
        /// 未收
        /// </summary>
        public decimal NoFinal_Price { get; set; }



        /// <summary>
        /// 结算款
        /// </summary>
        public decimal Income { get; set; }



        /// <summary>
        /// 已收
        /// </summary>
        public decimal AllPrice { get; set; }


        /// <summary>
        /// 采购成本
        /// </summary>
        public decimal CostMoney { get; set; }

        /// <summary>
        /// 包装费摊销
        /// </summary>
        public decimal PackingMoney { get; set; }
        /// <summary>
        /// 快递费
        /// </summary>
        public decimal CostFreight { get; set; }

        /// <summary>
        /// 商品运费
        /// </summary>
        public decimal GoodsFreight { get; set; }


        /// <summary>
        /// 一级返佣
        /// </summary>
        public decimal OneCommission { get; set; }

        /// <summary>
        /// 二级返佣
        /// </summary>
        public decimal TwoCommission { get; set; }


        /// <summary>
        /// 其他
        /// </summary>
        public decimal OtherPrice { get; set; }


        /// <summary>
        /// 营业（合计）
        /// </summary>
        public decimal ALLCommission { get; set; }

        /// <summary>
        /// 已付
        /// </summary>
        public decimal Paid { get; set; }
        /// <summary>
        /// 未付
        /// </summary>
        public decimal NoPaid { get; set; }

        /// <summary>
        /// 毛利
        /// </summary>
        public decimal GrossProfit { get; set; }


        /// <summary>
        /// 毛利率
        /// </summary>
        public decimal GrossProfitRate { get; set; }


        /// <summary>
        /// 开始时间
        /// </summary>
        public string StartDate { get; set; }

        /// <summary>
        /// 结束时间
        /// </summary>
        public string EndDate { get; set; }
    }
}
