﻿using Newtonsoft.Json;
using Newtonsoft.Json.Converters;
using System;
using System.Collections.Generic;
using System.IO;

namespace Mall.Common.Data
{
    /// <summary>
    /// 地区数据帮助类
    /// </summary>
    public class AreaDataHelper
    {
        static readonly string path = Path.Combine(AppDomain.CurrentDomain.BaseDirectory, "Data\\Area.json");

        /// <summary>
        /// 地区节点集合
        /// </summary>
        public static List<Node> Nodes { get; set; }

        /// <summary>
        /// 将数据写入Json文件
        /// </summary>
        /// <param name="json"></param>
        public static void WriteJson(object json)
        {
            using (StreamWriter sw = new StreamWriter(path))
            {
                try
                {
                    JsonSerializer serializer = new JsonSerializer();
                    serializer.Converters.Add(new JavaScriptDateTimeConverter());
                    serializer.NullValueHandling = NullValueHandling.Ignore;
                    //构建Json.net的写入流  
                    JsonWriter writer = new JsonTextWriter(sw);
                    //把模型数据序列化并写入Json.net的JsonWriter流中  
                    serializer.Serialize(writer, json);
                    writer.Close();
                    sw.Close();
                    Nodes = null;
                }
                catch
                {

                }
            }
        }

        /// <summary>
        /// 根据编号获取节点
        /// </summary>
        /// <param name="Id"></param>
        /// <returns></returns>
        public static Node GetNode(int Id)
        {
            List<Node> list = GetAreaList();
            return list.Find(qitem => qitem.I == Id);
        }

        /// <summary>
        /// 获取地区列表
        /// </summary>
        /// <returns></returns>
        public static List<Node> GetAreaList()
        {
            if (Nodes != null && Nodes.Count > 0)
            {
                return Nodes;
            }
            try
            {
                //读取json文件  
                using (StreamReader file = new StreamReader(path))
                {
                    try
                    {
                        JsonSerializer serializer = new JsonSerializer();
                        Nodes = (List<Node>)serializer.Deserialize(file, typeof(List<Node>));
                        return Nodes;
                    }
                    catch
                    {
                        return null;
                    }
                }
            }
            catch
            {
                return null;
            }
        }
    }

    /// <summary>
    /// 地区节点
    /// </summary>
    public class Node
    {
        /// <summary>
        /// 编号
        /// </summary>
        public int I
        {
            get;
            set;
        }

        /// <summary>
        /// 名称
        /// </summary>        
        public string N
        {
            get;
            set;
        }

        /// <summary>
        /// 英文名称
        /// </summary>
        public string E { get; set; }

        /// <summary>
        /// 城市三码
        /// </summary>
        public string C { get; set; }

        /// <summary>
        /// 层级1-国家，2-省，3-市，4-区县
        /// </summary>
        public int L { get; set; }

        /// <summary>
        /// 父级编号
        /// </summary>
        public int P { get; set; }

        /// <summary>
        /// 状态
        /// </summary>
        public int S  { get; set; }
    }
}
