﻿using Mall.Common;
using System;
using System.Collections.Generic;
using System.IO;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

namespace Mall.Commom.Plugin
{
    /// <summary>
    /// 公共帮助类
    /// </summary>
    public class FileCommonHelper
    {
        /// <summary>
        /// 文件转义URL
        /// </summary>
        public static string FileCopyUrl
        {
            get
            {
                string url =Mall.Common.Config.UploadSiteUrl + "/Home/FileCopy?filePath={0}&newFilePath={1}";
                return url;
            }
        }

        /// <summary>
        /// 文件移动
        /// </summary>
        /// <param name="images">上传图片</param>
        /// <param name="filePath">文件保存相对路径</param>
        public static List<string> OssFileMove(List<string> images, string filePath)
        {
            List<string> imgList = new List<string>();
            if (images != null && images.Count() > 0)
            {
                foreach (var item in images)
                {
                    string fileFullPath = filePath + Path.GetFileName(item);
                    string url = string.Format(FileCopyUrl, Config.GetFilePath(item), fileFullPath);
                    try
                    {
                        Common.Plugin.HttpHelper.HttpPost(url, "");
                    }
                    catch (Exception ex)
                    {
                        Common.Plugin.LogHelper.Write(ex, "OssFileMove:URL:"+url);
                    }
                    imgList.Add(fileFullPath);
                }
            }
            return imgList;
        }

        /// <summary>
        /// 文件移动
        /// </summary>
        /// <param name="images">上传图片(支持相对路径和绝对路径)</param>
        /// <param name="filePath">文件保存相对路径</param>
        public static string OssFileMove(string images, string filePath)
        {
            List<string> imgList = new List<string>();
            if (!string.IsNullOrWhiteSpace(images))
            {
                string fileFullPath = filePath + Path.GetFileName(images);
                string url = string.Format(FileCopyUrl, Config.GetFilePath(images), fileFullPath);
                try
                {
                    Common.Plugin.HttpHelper.HttpPost(url, "");
                }
                catch (Exception ex)
                {
                    Common.Plugin.LogHelper.Write(ex, "OssFileMove2:URL:"+ url);
                }
                return fileFullPath;
            }
            else
            {
                return "";
            }
        }

        /// <summary>
        /// 文件批量移动
        /// </summary>
        /// <param name="images">上传图片(支持相对路径和绝对路径)</param>
        /// <param name="filePath">文件保存相对路径</param>
        public static List<string> OssFileBatchMove(List<string> images, string filePath)
        {
            List<string> imgList = new List<string>();
            if (images != null && images.Any())
            {
                foreach (var item in images)
                {
                    string fileFullPath = filePath + Path.GetFileName(item);
                    string url = string.Format(FileCopyUrl, Config.GetFilePath(item), fileFullPath);
                    try
                    {
                        Common.Plugin.HttpHelper.HttpPost(url, "");
                    }
                    catch (Exception ex)
                    {
                        Common.Plugin.LogHelper.Write(ex, "OssFileBatchMove:URL:"+ url);
                    }
                    imgList.Add(fileFullPath);
                }
            }
            return imgList;
        }
    }
}