﻿using Mall.Common.AOP;
using System;
using System.Collections.Generic;
using System.Text;

namespace Mall.Model.Entity.User
{
    /// <summary>
    /// 小程序用户中心菜单实体类
    /// </summary>
    [Serializable]
    [DB(ConnectionName = "DefaultConnection")]
    public class RB_MiniProgram_UserCenterMenu
    {
        /// <summary>
        /// 主键ID
        /// </summary>        
        public int DetailId
        {
            get;
            set;
        }

        /// <summary>
        /// 小程序Id
        /// </summary>        
        public int? MallBaseId
        {
            get;
            set;
        }

        /// <summary>
        /// 页面类型(1-基础页面,2-营销页面，3-订单页面，4-插件页面，5-diy页面
        /// </summary>        
        public int? MenuType
        {
            get;
            set;
        }

        /// <summary>
        /// 菜单名称
        /// </summary>        
        public string MenuName
        {
            get;
            set;
        }

        /// <summary>
        /// 菜单图标
        /// </summary>        
        public string MenuIcon
        {
            get;
            set;
        }

        /// <summary>
        /// 菜单链接
        /// </summary>        
        public string MenuUrl
        {
            get;
            set;
        }
    }
}
