﻿using Mall.Common.AOP;
using Mall.Common.Enum.MarketingCenter;
using Mall.Common.Enum.User;
using Mall.Model.Entity.User;
using System;
using System.Collections.Generic;
using System.Text;

namespace Mall.Model.Extend.User
{
    /// <summary>
    /// 会员优惠券扩展实体
    /// </summary>
    [Serializable]
    [DB(ConnectionName = "DefaultConnection")]
    public class RB_Member_DiscountCoupon_Extend : RB_Member_DiscountCoupon
    {
        public int PlatformType { get; set; }


        /// <summary>
        /// 下单时间
        /// </summary>
        public DateTime? OrderCreateDate { get; set; }

        /// <summary>
        /// 优惠券名称
        /// </summary>
        public string Name { get; set; }

        /// <summary>
        /// 优惠方式
        /// </summary>
        public CouponTypeEnum CouponType { get; set; }

        /// <summary>
        /// 最低消费金额
        /// </summary>
        public decimal MinConsumePrice { get; set; }

        /// <summary>
        /// 会员昵称
        /// </summary>
        public string AliasName { get; set; }


        /// <summary>
        /// 下单开始时间
        /// </summary>
        public DateTime? StartDate { get; set; }

        /// <summary>
        /// 下单结束时间
        /// </summary>
        public DateTime? EndDate { get; set; }
        /// <summary>
        /// 优惠卷ids
        /// </summary>
        public string CouponIds { get; set; }


      
    }
}
