﻿using Mall.Common.Plugin;
using Mall.Model.Entity.MarketingCenter;
using Mall.Model.Entity.User;
using Mall.Model.Extend.MarketingCenter;
using Mall.Model.Extend.User;
using Mall.Model.Query;
using Mall.Repository;
using Mall.Repository.MarketingCenter;
using MySqlX.XDevAPI.Relational;
using Org.BouncyCastle.Crypto.Tls;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;

namespace Mall.Module.MarketingCenter
{
    /// <summary>
    /// 小程序模板处理类
    /// </summary>
    public class MiniprogramTemplateModule
    {
        /// <summary>
        /// 小程序模板仓储层对象
        /// </summary>
        private readonly RB_Miniprogram_TemplateRepository miniprogram_TemplateRepository = new RB_Miniprogram_TemplateRepository();

        /// <summary>
        /// 小程序模板分页列表
        /// </summary>
        /// <param name="pageIndex">页码</param>
        /// <param name="pageSize">每页显示条数</param>
        /// <param name="rowCount">总条数</param>
        /// <param name="query">查询条件</param>
        /// <returns></returns>
        public List<RB_Miniprogram_Template_Extend> GetMiniprogramTemplatePageListModule(int pageIndex, int pageSize, out long rowCount, RB_Miniprogram_Template_Extend query)
        {
            return miniprogram_TemplateRepository.GetMiniprogramTemplatePageListRepository(pageIndex, pageSize, out rowCount, query);
        }


        /// <summary>
        /// 小程序模板列表
        /// </summary>
        /// <param name="query">查询条件</param>
        /// <param name="IsAnalyzePlus">是否解析插件</param>
        /// <returns></returns>
        public List<RB_Miniprogram_Template_Extend> GetMiniprogramTemplateListModule(RB_Miniprogram_Template_Extend query,bool IsAnalyzePlus=false)
        {
            var list= miniprogram_TemplateRepository.GetMiniprogramTemplateListRepository(query);
            if (IsAnalyzePlus)
            {
                foreach (var item in list)
                {
                    if (item.TemplateData != null && !string.IsNullOrEmpty(item.TemplateData))
                    {
                        item.ComponentDataList = JsonHelper.DeserializeObject<List<ComponentItem>>(item.TemplateData);
                        if (item.ComponentDataList != null && item.ComponentDataList.Count > 0)
                        {
                            foreach (var subItem in item.ComponentDataList)
                            {
                                AnalyzePlusModule(subItem);
                            }
                        }
                    }
                }
            }
            return list;
        }

        /// <summary>
        /// 新增修改小程序模板
        /// </summary>
        /// <param name="extModel"></param>
        /// <returns></returns>
        public bool SetMiniprogramTemplateModule(RB_Miniprogram_Template_Extend extModel)
        {
            bool flag = false;
            if (extModel.Id > 0)
            {
                Dictionary<string, object> fileds = new Dictionary<string, object>()
                {
                    {nameof(RB_Miniprogram_Template_Extend.Id),extModel.Id }
                };
                fileds.Add(nameof(RB_Miniprogram_Template_Extend.TemplateName), extModel.TemplateName);
                fileds.Add(nameof(RB_Miniprogram_Template_Extend.TemplateData), extModel.TemplateData);
                flag = miniprogram_TemplateRepository.Update(fileds, new WhereHelper(nameof(RB_Miniprogram_Template_Extend.Id), extModel.Id));
            }
            else
            {
                var newId = miniprogram_TemplateRepository.Insert(extModel);
                extModel.Id = newId;
                flag = newId > 0;
            }
            return flag;
        }

        /// <summary>
        /// 获取小程序模板实体
        /// </summary>
        /// <param name="Id"></param>
        /// <returns></returns>
        public RB_Miniprogram_Template_Extend GetMiniprogramTemplateModule(object Id)
        {
            RB_Miniprogram_Template_Extend extModel = miniprogram_TemplateRepository.GetEntity<RB_Miniprogram_Template_Extend>(Id);
            if (extModel == null)
            {
                extModel = new RB_Miniprogram_Template_Extend();
            }
            if (extModel.TemplateData != null && !string.IsNullOrEmpty(extModel.TemplateData))
            {
                extModel.ComponentDataList = JsonHelper.DeserializeObject<List<ComponentItem>>(extModel.TemplateData);
                if (extModel.ComponentDataList != null && extModel.ComponentDataList.Count > 0)
                {
                    foreach (var item in extModel.ComponentDataList)
                    {
                        AnalyzePlusModule(item);
                    }
                }
            }
            return extModel;
        }

        /// <summary>
        /// 解析插件
        /// </summary>
        /// <param name="item"></param>
        public void AnalyzePlusModule(ComponentItem item)
        {
            switch (item.Id)
            {
                case "background":item.data = JsonHelper.DeserializeObject<backgroundItem>(item.data.ToString()); break;
                case "search": item.data = JsonHelper.DeserializeObject<searchItem>(item.data.ToString()); break;
                case "nav": item.data = JsonHelper.DeserializeObject<navItem>(item.data.ToString()); break;
                case "banner": item.data = JsonHelper.DeserializeObject<bannerItem>(item.data.ToString()); break;
                case "notice": item.data = JsonHelper.DeserializeObject<noticeItem>(item.data.ToString()); break;
                //专题
                case "topic": item.data = JsonHelper.DeserializeObject<topicItem>(item.data.ToString()); break;

                case "link": item.data = JsonHelper.DeserializeObject<linkItem>(item.data.ToString()); break;
                case "rubik": item.data = JsonHelper.DeserializeObject<rubikItem>(item.data.ToString()); break;
                case "video": item.data = JsonHelper.DeserializeObject<videoItem>(item.data.ToString()); break;
                case "goods": item.data = JsonHelper.DeserializeObject<goodsItem>(item.data.ToString()); break;
                case "store": item.data = JsonHelper.DeserializeObject<storeItem>(item.data.ToString()); break;
                case "copyright": item.data = JsonHelper.DeserializeObject<copyrightItem>(item.data.ToString()); break;
                case "check-in": item.data = JsonHelper.DeserializeObject<checkinItem>(item.data.ToString()); break;
                case "user-info": item.data = JsonHelper.DeserializeObject<userinfoItem>(item.data.ToString()); break;
                case "user-order": item.data = JsonHelper.DeserializeObject<userorderItem>(item.data.ToString()); break;
                case "map": item.data = JsonHelper.DeserializeObject<mapItem>(item.data.ToString()); break;
                case "mp-link": item.data = JsonHelper.DeserializeObject<mplinkItem>(item.data.ToString()); break;
                case "image-text": item.data = JsonHelper.DeserializeObject<imagetextItem>(item.data.ToString()); break;
                case "coupon": item.data = JsonHelper.DeserializeObject<couponItem>(item.data.ToString()); break;
                case "timer": item.data = JsonHelper.DeserializeObject<timerItem>(item.data.ToString()); break;
                case "pintuan": item.data = JsonHelper.DeserializeObject<pintuanItem>(item.data.ToString()); break;
                case "booking": item.data = JsonHelper.DeserializeObject<bookingItem>(item.data.ToString()); break;
                case "bargain": item.data = JsonHelper.DeserializeObject<bargainItem>(item.data.ToString()); break;
                case "integral-mall": item.data = JsonHelper.DeserializeObject<integralmallItem>(item.data.ToString()); break;
                case "lottery": item.data = JsonHelper.DeserializeObject<lotteryItem>(item.data.ToString()); break;
                case "advance": item.data = JsonHelper.DeserializeObject<advanceItem>(item.data.ToString()); break;
                case "vip-card": item.data = JsonHelper.DeserializeObject<vipcardItem>(item.data.ToString()); break;
                case "live": item.data = JsonHelper.DeserializeObject<liveItem>(item.data.ToString()); break;
                case "empty": item.data = JsonHelper.DeserializeObject<emptyItem>(item.data.ToString()); break;
                case "ad": item.data = JsonHelper.DeserializeObject<adItem>(item.data.ToString()); break;
                case "modal": item.data = JsonHelper.DeserializeObject<modalItem>(item.data.ToString()); break;
                case "quick-nav": item.data = JsonHelper.DeserializeObject<quicknavItem>(item.data.ToString()); break;
            }
        }

        /// <summary>
        /// 删除小程序模板
        /// </summary>
        /// <param name="Id"></param>
        /// <param name="Status"></param>
        /// <returns></returns>
        public bool RemoveMiniprogramTemplateModule(object Id, int Status)
        {
            bool flag = false;
            Dictionary<string, object> fileds = new Dictionary<string, object>()
            {
                {nameof(RB_Miniprogram_Template_Extend.Status),Status }
            };
            flag = miniprogram_TemplateRepository.Update(fileds, new WhereHelper(nameof(RB_Miniprogram_Template_Extend.Id), Id));
            return flag;
        }
    }
}
