﻿using Mall.Model.Extend.Product;
using Mall.Model.Query;
using Mall.Repository.Product;
using NPOI.SS.Formula.Functions;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;

namespace Mall.Module.MarketingCenter
{
    public class StatisticsModule
    {
        private RB_Goods_OrderRepository orderRepository = new RB_Goods_OrderRepository();

        #region 数据统计-数据概况

        /// <summary>
        /// 损益核算表
        /// </summary>
        /// <param name="pageIndex"></param>
        /// <param name="pageSize"></param>
        /// <param name="count"></param>
        /// <param name="dmodel"></param>
        /// <returns></returns>
        public List<OrderStatistics_Query> GetOrderProfitLossList(int pageIndex, int pageSize, out long count, OrderStatistics_Query dmodel)
        {
            return orderRepository.GetOrderProfitLossList(pageIndex, pageSize, out count, dmodel);
        }

        /// <summary>
        /// 数据概况
        /// </summary>
        /// <param name="dmodel"></param>
        /// <returns></returns>
        public List<DataStatistics_Query> GetOrdertSatistics(DataStatistics_Query dmodel)
        {
            return orderRepository.GetOrdertSatistics(dmodel);
        }


        /// <summary>
        /// 获取近一周的数据
        /// </summary>
        /// <param name="dmodel"></param>
        /// <returns></returns>
        public DataStatistics_Query GetWeeklyOrder(DataStatistics_Query dmodel)
        {
            if (dmodel.IsYesterday == 1)
            {
                dmodel.StartDate = dmodel.EndDate = System.DateTime.Now.AddDays(-1).ToString("yyyy-MM-dd");
            }
            else
            {
                dmodel.StartDate = System.DateTime.Now.ToString("yyyy-MM-dd");
                dmodel.EndDate = System.DateTime.Now.AddDays(-7).ToString("yyyy-MM-dd");
            }
            var List = orderRepository.GetWeeklyOrder(dmodel);

            DataStatistics_Query model = new DataStatistics_Query();
            if (List != null && List.Any())
            {
                model.OrderPay = List.Count();
                model.PayMoney = List.Sum(x => x.Income ?? 0);
                model.PayMemerNum = List.GroupBy(x => x.UserId).Count();
                model.BuyNum = List.Sum(x => x.GoodsTotalNum);
                model.OrderLineList = new List<OrderLine>();
                if (dmodel.IsYesterday == 1)//同一天
                {
                    for (int i = 1; i < 24; i++)
                    {
                        OrderLine modelOrderLine = new OrderLine();
                        modelOrderLine.OrderPay = List.Where(x => x.CreateDate.Value.ToString("dd") == ((i > 9) ? ("0" + i) : i.ToString())).Count();
                        modelOrderLine.PayMoney = List.Where(x => x.CreateDate.Value.ToString("dd") == ((i > 9) ? ("0" + i) : i.ToString())).Sum(x => x.Income ?? 0);
                        modelOrderLine.PayMemerNum = List.Where(x => x.CreateDate.Value.ToString("dd") == ((i > 9) ? ("0" + i) : i.ToString())).GroupBy(x => x.UserId).Count();
                        modelOrderLine.BuyNum = List.Where(x => x.CreateDate.Value.ToString("dd") == ((i > 9) ? ("0" + i) : i.ToString())).Sum(x => x.GoodsTotalNum);
                        modelOrderLine.DateStr = (i > 9) ? ("0" + i) : i.ToString();
                        model.OrderLineList.Add(modelOrderLine);
                    }
                }
                else
                {
                    for (int i = 0; i < 7; i++)
                    {
                        OrderLine modelOrderLine = new OrderLine();
                        modelOrderLine.OrderPay = List.Where(x => x.CreateDate.Value.ToString("yyyy-MM-dd") == System.DateTime.Now.AddDays(i).ToString("yyyy-MM-dd")).Count();
                        modelOrderLine.PayMoney = List.Where(x => x.CreateDate.Value.ToString("yyyy-MM-dd") == System.DateTime.Now.AddDays(i).ToString("yyyy-MM-dd")).Sum(x => x.Income ?? 0);
                        modelOrderLine.PayMemerNum = List.Where(x => x.CreateDate.Value.ToString("yyyy-MM-dd") == System.DateTime.Now.AddDays(i).ToString("yyyy-MM-dd")).GroupBy(x => x.UserId).Count();
                        modelOrderLine.BuyNum = List.Where(x => x.CreateDate.Value.ToString("yyyy-MM-dd") == System.DateTime.Now.AddDays(i).ToString("yyyy-MM-dd")).Sum(x => x.GoodsTotalNum);
                        modelOrderLine.DateStr = System.DateTime.Now.AddDays(i).ToString("yyyy-MM-dd");
                        model.OrderLineList.Add(modelOrderLine);
                    }
                }
            }
            return model;
        }



        /// <summary>
        /// 商品购买力TOP排行
        /// </summary>
        /// <param name="dmodel"></param>
        /// <returns></returns>
        public List<DataStatistics_Query> GetGoosTop(DataStatistics_Query dmodel)
        {
            return orderRepository.GetGoosTop(dmodel);
        }


        /// <summary>
        /// 用户购买力TOP排行
        /// </summary>
        /// <param name="dmodel"></param>
        /// <returns></returns>
        public List<DataStatistics_Query> GetMemberTop(DataStatistics_Query dmodel)
        {
            return orderRepository.GetMemberTop(dmodel);
        }

        #endregion


        #region 销售报表
        /// <summary>
        /// 销售统计
        /// </summary>
        /// <param name="pageIndex"></param>
        /// <param name="pageSize"></param>
        /// <param name="count"></param>
        /// <param name="dmodel"></param>
        /// <returns></returns>
        public List<DataStatistics_Query> GetSellPageList(int pageIndex, int pageSize, out long count, DataStatistics_Query dmodel)
        {
            return orderRepository.GetSellPageList(pageIndex, pageSize, out count, dmodel);
        }


        /// <summary>
        /// 总成交
        /// </summary>
        /// <param name="dmodel"></param>
        /// <returns></returns>
        public DataStatistics_Query GetSellOrder(DataStatistics_Query dmodel)
        {

            var List = orderRepository.GetWeeklyOrder(dmodel);

            DataStatistics_Query model = new DataStatistics_Query();
            if (List != null && List.Any())
            {
                model.OrderNum = List.Count();
                model.PayMoney = List.Sum(x => x.Income ?? 0);
                model.PayMemerNum = List.GroupBy(x => x.UserId).Count();
                model.GoodsNum = List.Sum(x => x.GoodsTotalNum);
            }
            return model;
        }


        /// <summary>
        /// 销售统计导出
        /// </summary>
        /// <param name="pageIndex"></param>
        /// <param name="pageSize"></param>
        /// <param name="count"></param>
        /// <param name="dmodel"></param>
        /// <returns></returns>
        public List<DataStatistics_Query> GetSellExcel(DataStatistics_Query dmodel)
        {
            return orderRepository.GetSellExcel(dmodel);
        }

        #endregion
    }
}
