﻿
using Microsoft.AspNetCore.Mvc;
using System;
using System.IO;
using Microsoft.AspNetCore.Cors;
using System.Collections.Generic;
using System.Linq;
using Mall.WebApi.Filter;
using Mall.Common.API;
using Mall.Common.Plugin;

namespace Mall.WebApi.Controllers.File
{
    [Route("api/[controller]/[action]")]
    [ApiExceptionFilter]
    [ApiController]
    [EnableCors("AllowCors")]
    public class FileController : ControllerBase
    {
        /// <summary>
        /// 上传文件到本地临时文件
        /// </summary>
        /// <returns></returns>
        [HttpPost]
        public ApiResult LocalFileUploadImport()
        {
            try
            {
                var files = Request.Form.Files;
                if (files.Count == 0)
                {
                    return new ApiResult { resultCode = (int)ResultCode.Fail, message = "未选择文件", data = "" };
                }
                
                string filename = files[0].FileName;
                string fileExtention = System.IO.Path.GetExtension(files[0].FileName);
                //验证文件格式
                List<string> ExtList = new List<string>() {
                    ".xls",
                    ".xlsx"
                };
                if (!ExtList.Contains(fileExtention)) {
                    return new ApiResult { resultCode = (int)ResultCode.Fail, message = "文件格式有误", data = "" };
                }
                string path = Guid.NewGuid().ToString() + fileExtention; 
                string basepath = AppContext.BaseDirectory;
                string path_server = basepath + "\\upfile\\temporary\\" + path;
                if (!Directory.Exists(basepath + "\\upfile\\temporary"))
                {
                    Directory.CreateDirectory(basepath + "\\upfile\\temporary");
                }
                using (FileStream fstream = new FileStream(path_server, FileMode.OpenOrCreate, FileAccess.ReadWrite))
                {
                    files[0].CopyTo(fstream);
                }

                return ApiResult.Success("", path_server);
            }
            catch (Exception ex)
            {
                LogHelper.Write(ex, "LocalFileUploadImport");
                return ApiResult.Failed();
            }
        }

    }
}
