﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Threading.Tasks;
using Mall.Common.API;
using Mall.Common.Plugin;
using Mall.Model.Entity.BaseSetUp;
using Mall.Model.Entity.MarketingCenter;
using Mall.Model.Extend.BaseSetUp;
using Mall.Model.Extend.MarketingCenter;
using Mall.Module.BaseSetUp;
using Mall.Module.MarketingCenter;
using Mall.WebApi.Filter;
using Microsoft.AspNetCore.Cors;
using Microsoft.AspNetCore.Mvc;
using Newtonsoft.Json;
using Newtonsoft.Json.Linq;


namespace Mall.WebApi.Controllers.MallBase
{
    /// <summary>
    /// 小程序商城控制器
    /// </summary>
    [Route("api/[controller]/[action]")]
    [ApiExceptionFilter]
    [ApiController]
    [EnableCors("AllowCors")]

    public class MallController : BaseController
    {
        /// <summary>
        /// 商户账号处理类
        /// </summary>
        private Module.User.TenantModule TenantModule = new Module.User.TenantModule();

        /// <summary>
        /// 商户小程序处理类
        /// </summary>
        private Module.User.MiniProgramModule programModule = new Module.User.MiniProgramModule();


        /// <summary>
        /// 自定义页面处理类
        /// </summary>
        private readonly MiniprogramPageTemplModule miniprogramPageTemplModule = new MiniprogramPageTemplModule();

        /// <summary>
        /// 自定义模板处理类
        /// </summary>
        private readonly MiniprogramTemplateModule miniprogramTemplateModule = new MiniprogramTemplateModule();

        /// <summary>
        /// 小程序首页
        /// </summary>
        /// <returns></returns>
        [HttpGet]
        [HttpPost]
        public ApiResult GetHome()
        {
            JObject parms = JObject.Parse(RequestParm.msg.ToString());
            //小程序Id
            var MiniAppId = parms.GetStringValue("MiniAppId");
            var homePage = new object();
            //获取小程序信息
            var miniProgram = programModule.GetMiniProgramModule(new Model.Extend.User.RB_MiniProgram_Extend() { MiniAppId = MiniAppId }, isGetHomeData: true);
            if (miniProgram != null && miniProgram.MallBaseId > 0)
            {
                var selfHomePage = miniprogramPageTemplModule.GetMiniprogramPageTemplModule(new RB_Miniprogram_Page_Templ_Extend()
                {
                    MallBaseId = miniProgram.MallBaseId,
                    TenantId = miniProgram.TenantId,
                }, isGetHome: true);
                List<object> list = new List<object>();
                //自定义首页
                if (selfHomePage != null && selfHomePage.Id > 0)
                {
                    //获取模板编号
                    string templateIds = string.Join(",", selfHomePage.DetailsList.Select(qitem => qitem.TemplateId));
                    var templateList = miniprogramTemplateModule.GetMiniprogramTemplateListModule(new Model.Extend.MarketingCenter.RB_Miniprogram_Template_Extend()
                    {
                        MallBaseId = miniProgram.MallBaseId,
                        TenantId = miniProgram.TenantId,
                        QIds = templateIds
                    }, IsAnalyzePlus: true);
                    //解析模板
                    foreach (var item in templateList)
                    {
                        var detailsModel = selfHomePage?.DetailsList?.Where(qitem => qitem.TemplateId == item.Id)?.FirstOrDefault();
                        var templateData = new
                        {
                            id = detailsModel?.Id??0,
                            name = detailsModel?.NavName??"",
                            data = new List<object>()
                        };
                        if (item.ComponentDataList != null && item.ComponentDataList.Count() > 0)
                        {
                            foreach (var subItem in item.ComponentDataList)
                            {
                                switch (subItem.Id)
                                {
                                    case "search":
                                        var searchData = subItem.data as searchItem;
                                        templateData.data.Add(new
                                        {
                                            id = subItem.Id,
                                            data = searchData
                                        });
                                        break;

                                    case "background":
                                        var backgroundData = subItem.data as backgroundItem;
                                        templateData.data.Add(new
                                        {
                                            id = subItem.Id,
                                            data = backgroundData
                                        });
                                        break;
                                    case "banner":
                                        var bannerData = subItem.data as bannerItem;
                                        templateData.data.Add(new
                                        {
                                            id = subItem.Id,
                                            data = bannerData
                                        });
                                        break;
                                    case "empty":
                                        var emptyData = subItem.data as emptyItem;
                                        templateData.data.Add(new
                                        {
                                            id = subItem.Id,
                                            data = emptyData
                                        });
                                        break;
                                    case "rubik":
                                        var rubikData = subItem.data as rubikItem;
                                        templateData.data.Add(new
                                        {
                                            id = subItem.Id,
                                            data = rubikData
                                        });
                                        break;

                                    case "goods":
                                        var goodsData = subItem.data as goodsItem;
                                        templateData.data.Add(new
                                        {
                                            id = subItem.Id,
                                            data = goodsData
                                        });
                                        break;
                                }

                            }
                        }

                        var tempObj = new
                        {
                            id = item.Id,
                            name = item.TemplateName,
                            page_id = 0,
                            template_id = item.Id,
                            template = templateData
                        };
                        list.Add(tempObj);
                    }

                    homePage = new
                    {
                        id = selfHomePage.Id,
                        title = selfHomePage.PageName,
                        show_navs = selfHomePage.IsShowNav,
                        is_home_page = selfHomePage.IsHome,
                        navs = list
                    };
                }
                //默认首页
                else
                {
                    //配置了首页
                    if (miniProgram.HomeDataList != null && miniProgram.HomeDataList.Count > 0)
                    {
                        homePage = new
                        {
                            id = 0,
                            title = miniProgram.MallName,
                            show_navs = 1,
                            is_home_page = 1,
                            navs = list
                        };
                    }
                    //未配置自定义页面
                    else
                    {
                        homePage = new
                        {
                            id = -1,
                            title = miniProgram.MallName,
                            show_navs = 1,
                            is_home_page = 1,
                            navs = list
                        };

                    }
                }
            }
            return ApiResult.Success(data: homePage);
        }

        /// <summary>
        /// 用户中心
        /// </summary>
        /// <returns></returns>
        [HttpGet]
        [HttpPost]
        public ApiResult GetUserCenter()
        {
            JObject parms = JObject.Parse(RequestParm.msg.ToString());
            //小程序Id
            var MiniAppId = parms.GetStringValue("MiniAppId");
            //获取小程序信息
            var miniProgram = programModule.GetMiniProgramModule(new Model.Extend.User.RB_MiniProgram_Extend() { MiniAppId = MiniAppId }, isGetUserCenterMenu: true);
            var mall = new object();
            if (miniProgram != null && miniProgram.MallBaseId > 0)
            {
                var config = new
                {
                    //顶部导航
                    title_bar = new
                    {
                        //顶部背景颜色
                        background = miniProgram.TopNavBgColor,
                        //顶部文字颜色
                        color = miniProgram.TopNavWordColor,
                    },
                    //用户中心
                    user_center = new
                    {
                        //是否显示账户栏
                        is_account_status = (miniProgram.IsShowAccountNav == 0 ? 1 : 0),
                        //是否显示菜单栏
                        is_menu_status = (miniProgram.IsShowMenuNav == 0 ? 1 : 0),
                        //是否显示菜单栏
                        is_order_bar_status = (miniProgram.IsShowOrderNav == 0 ? 1 : 0),
                        //是否显示收藏夹
                        is_foot_bar_status = (miniProgram.IsShowFavorite == 0 ? 1 : 0),
                        //菜单样式
                        menu_style = (miniProgram.MenuNavStyle == 0 ? 1 : 2),
                        //头像样式
                        top_style = (miniProgram.HeadStyle),
                        //顶部默认背景图
                        top_pic_url = miniProgram.DefaultBgImg,
                        //普通用户背景图
                        member_pic_url = miniProgram.MemberBgImg,
                        //会员中心背景图
                        member_bg_pic_url = miniProgram.VipBgImg,
                        //头像内嵌背景图
                        style_bg_pic_url = "",

                        //账户相关菜单
                        account = miniProgram?.AccountMenuList.Select(qitem => new
                        {
                            icon_url = qitem.MenuIcon,
                            name = qitem.MenuName,
                            is_show = 1,
                        }),
                        //自定义菜单
                        menus = miniProgram?.SelfMenuList.Select(qitem => new
                        {
                            icon_url = qitem.MenuIcon,
                            name = qitem.MenuName,
                            link_url = qitem.MenuUrl,
                            open_type = "navigate",
                            @params = "",

                        }),
                        //订单菜单列表
                        order_bar = miniProgram?.OrderMenuList.Select(qitem => new
                        {
                            icon_url = qitem.MenuIcon,
                            name = qitem.MenuName,
                            link_url = qitem.MenuUrl,
                            open_type = "navigate",
                            text = "",
                        }),
                        //收藏足迹
                        foot_bar = miniProgram?.FavoriteFootMenuList.Select(qitem => new
                        {
                            icon_url = qitem.MenuIcon,
                            name = qitem.MenuName,
                            link_url = qitem.MenuUrl,
                            open_type = "navigate",
                        }),
                        //版权设置
                        copyright = new
                        {
                            pic_url = miniProgram.CopyRightImg,
                            description = miniProgram.CopyRightWord,
                            link_url = miniProgram.CopyRightLink,
                        }
                    }
                };
                mall = new
                {
                    id = miniProgram.MallBaseId,
                    name = miniProgram.MallName,
                    //配置信息
                    config
                };
            }
            return ApiResult.Success(data: mall);
        }
    }
}