﻿using VT.FW.DB;
using Mall.Common.Enum.MallBase;
using System;
using System.Collections.Generic;
using System.Text;

namespace Mall.Model.Entity.GuideCar
{
    /// <summary>
    /// 司导专区基础
    /// </summary>
    [Serializable]
    [DB(ConnectionName = "DefaultConnection")]
    public class RB_GuideCar_Base
    {
        /// <summary>
        /// id
        /// </summary>
        public int Id { get; set; }

        /// <summary>
        /// 详情页面链接
        /// </summary>
        public string PagePath { get; set; }

        /// <summary>
        /// 是否需要确认   1是  2否
        /// </summary>
        public int IsConfirm { get; set; }

        /// <summary>
        /// 提前预定天数
        /// </summary>
        public int AdvanceDay { get; set; }

        /// <summary>
        /// 取消提前小时
        /// </summary>
        public int CancelHour { get; set; }

        /// <summary>
        /// 订单状态变更
        /// </summary>
        public string OrderStateJson { get; set; }

        /// <summary>
        /// 保险名称
        /// </summary>
        public string InsuranceName { get; set; }

        /// <summary>
        /// 成本价格
        /// </summary>
        public decimal CostPrice { get; set; }

        /// <summary>
        /// 销售价格
        /// </summary>
        public decimal SalePrice { get; set; }

        /// <summary>
        /// 保险描述(富文本)
        /// </summary>
        public string InsuranceDescription { get; set; }

        /// <summary>
        /// 商户id
        /// </summary>
        public int TenantId { get; set; }

        /// <summary>
        /// 小程序id
        /// </summary>
        public int MallBaseId { get; set; }

        /// <summary>
        /// 创建时间
        /// </summary>
        public DateTime CreateDate { get; set; }

        /// <summary>
        /// 修改人(员工id)
        /// </summary>
        public int UpdateBy { get; set; }

        /// <summary>
        /// 修改时间
        /// </summary>
        public DateTime UpdateDate { get; set; }
    }
}
