﻿using VT.FW.DB;
using System;
using System.Collections.Generic;
using System.Text;
using Mall.Model.Entity.Product;

namespace Mall.Model.Extend.Product
{
    /// <summary>
    /// 活动扩展实体
    /// </summary>
    [Serializable]
    [DB(ConnectionName = "DefaultConnection")]
    public class RB_Goods_Activity_Extend : RB_Goods_Activity
    {
        /// <summary>
        /// 分类/商品信息
        /// </summary>
        public object RangeList = new List<object>();

        /// <summary>
        /// 活动查询状态  1进行中   2已结束
        /// </summary>
        public int QActivityState { get; set; }

        /// <summary>
        /// 商品数量
        /// </summary>
        public int Number { get; set; }

        /// <summary>
        /// 商品价格
        /// </summary>
        public decimal Final_Price { get; set; }

        /// <summary>
        /// 订单总数量
        /// </summary>
        public int OrderTNum { get; set; }

        /// <summary>
        /// 订单id
        /// </summary>
        public int OrderId { get; set; }

        /// <summary>
        /// 用户所有上级
        /// </summary>
        public string UserTree { get; set; }

        /// <summary>
        /// 1级用户
        /// </summary>
        public int OneUserId { get; set; }

        /// <summary>
        /// 二级用户
        /// </summary>
        public int TwoUserId { get; set; }

        /// <summary>
        /// 三级用户
        /// </summary>
        public int ThreeUserId { get; set; }

        /// <summary>
        /// 是否已完成  1是  2否
        /// </summary>
        public int IsFinish { get; set; }

        /// <summary>
        /// 下单订单时间
        /// </summary>
        public string OrderTime { get; set; }
    }
}
