﻿using System;
using System.Collections.Generic;
using System.Linq;
using Mall.Common;
using Mall.Common.Plugin;
using Newtonsoft.Json;
using VT.FW.DB;
using Mall.Repository.Assess;
using Mall.Model.Extend.Assess;
using Mall.Model.Entity.Assess;
using Mall.Repository.User;

namespace Mall.Module.Miai
{
    /// <summary>
    /// 估价处理层
    /// </summary>
    public class AssessModule
    {
        

        /// <summary>
        /// 用户管理
        /// </summary>
        private readonly RB_Member_UserRepository member_UserRepository = new RB_Member_UserRepository();
        /// <summary>
        /// 分类
        /// </summary>
        private readonly RB_Assess_CategoryRepository assess_CategoryRepository = new RB_Assess_CategoryRepository();
        /// <summary>
        /// 品牌
        /// </summary>
        private readonly RB_Assess_BrandRepository assess_BrandRepository = new RB_Assess_BrandRepository();
        /// <summary>
        /// 商品
        /// </summary>
        private readonly RB_Assess_GoodsRepository assess_GoodsRepository = new RB_Assess_GoodsRepository();


        #region 估价分类

        /// <summary>
        /// 获取分类分页列表
        /// </summary>
        /// <param name="pageIndex"></param>
        /// <param name="pageSize"></param>
        /// <param name="count"></param>
        /// <param name="demodel"></param>
        /// <returns></returns>
        public List<RB_Assess_Category_Extend> GetCategoryPageList(int pageIndex, int pageSize, out long count, RB_Assess_Category_Extend demodel)
        {
            return assess_CategoryRepository.GetPageList(pageIndex, pageSize, out count, demodel);
        }

        /// <summary>
        /// 获取分类列表
        /// </summary>
        /// <param name="demodel"></param>
        /// <returns></returns>
        public List<RB_Assess_Category_Extend> GetCategoryList(RB_Assess_Category_Extend demodel)
        {
            return assess_CategoryRepository.GetList(demodel);
        }

        /// <summary>
        /// 保存修改分类
        /// </summary>
        /// <param name="demodel"></param>
        /// <returns></returns>
        public string SetCategoryInfo(RB_Assess_Category_Extend demodel)
        {
            if (demodel.Id > 0)
            {
                var dmodel = assess_CategoryRepository.GetEntity(demodel.Id);
                dmodel.Name = demodel.Name;
                dmodel.Image = demodel.Image;
                dmodel.Enable = demodel.Enable;
                dmodel.Sort = demodel.Sort;
                dmodel.UpdateBy = demodel.UpdateBy;
                dmodel.UpdateDate = demodel.UpdateDate;
                bool flag = assess_CategoryRepository.Update(dmodel);
                return flag ? "" : "出错了，请联系管理员";
            }
            else {
                bool flag = assess_CategoryRepository.Insert(demodel) > 0;
                return flag ? "" : "出错了，请联系管理员";
            }
        }

        /// <summary>
        /// 删除分类
        /// </summary>
        /// <param name="categoryId"></param>
        /// <returns></returns>
        public bool DelCategoryInfo(int categoryId)
        {
            Dictionary<string, object> keyValues = new Dictionary<string, object>() {
                { nameof(RB_Assess_Category_Extend.Status),1},
                { nameof(RB_Assess_Category_Extend.UpdateDate),DateTime.Now},
            };
            List<WhereHelper> wheres = new List<WhereHelper>() {
                new WhereHelper(){
                     FiledName = nameof(RB_Assess_Category_Extend.Id),
                      FiledValue = categoryId,
                       OperatorEnum =OperatorEnum.Equal
                }
            };
            return assess_CategoryRepository.Update(keyValues, wheres);
        }

        #endregion
    }
}