﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using Mall.Model.Entity.Education;
using Mall.Model.Extend.Education;

namespace Mall.Repository.Education
{
    /// <summary>
    /// 校企仓储层
    /// </summary>
    public class Rb_Education_SchoolRepository : BaseRepository<Rb_Education_School>
    {
        /// <summary>
        /// 表名称
        /// </summary>
        public string TableName { get { return nameof(Rb_Education_School); } }
        /// 获取列表
        /// </summary>
        /// <param name="where"></param>
        /// <returns></returns>
        public List<Rb_Education_School_Extend> GetEducationSchoolList(Rb_Education_School_Extend where)
        {
            StringBuilder sb = new StringBuilder();
            sb.Append($@"SELECT a.*,b.UserCount from Rb_Education_School  as a
LEFT JOIN (SELECT EduSchoolId,COUNT(*) as UserCount from rb_member_user  GROUP BY EduSchoolId ) as b on a.Id=b.EduSchoolId
 where  a.Status=0 ");
            if (where != null)
            {
                if (where.TenantId > 0)
                {
                    sb.AppendFormat(" and a.TenantId={0}", where.TenantId);
                }
                if (where.MallBaseId > 0)
                {
                    sb.AppendFormat(" and a.MallBaseId={0}", where.MallBaseId);
                }
                if (!string.IsNullOrWhiteSpace(where.ShoolName))
                {
                    sb.AppendFormat(" and a.ShoolName like '%{0}%'", where.ShoolName);
                }
                if (where.Id > 0)
                {
                    sb.AppendFormat(" and a.Id={0}", where.Id);
                }
                if (where.UserId > 0)
                {
                    sb.Append($" AND FIND_IN_SET('{where.UserId}',  {nameof(Rb_Education_School_Extend.AgentIds)})");
                }
            }
            return Get<Rb_Education_School_Extend>(sb.ToString()).ToList();
        }

        /// <summary>
        /// 校企分页
        /// </summary>
        /// <param name="pageIndex"></param>
        /// <param name="pageSize"></param>
        /// <param name="rowCount"></param>
        /// <param name="where"></param>
        /// <returns></returns>

        public List<Rb_Education_School_Extend> GetEducationSchoolPageList(int pageIndex, int pageSize, out long rowCount, Rb_Education_School_Extend where)
        {
            StringBuilder sb = new StringBuilder();
            sb.Append($@"SELECT a.*,b.UserCount from Rb_Education_School  as a
LEFT JOIN (SELECT EduSchoolId,COUNT(*) as UserCount from rb_member_user  GROUP BY EduSchoolId ) as b on a.Id=b.EduSchoolId
 where  a.Status=0 ");
            if (where != null)
            {
                if (where.TenantId > 0)
                {
                    sb.AppendFormat(" and a.TenantId={0}", where.TenantId);
                }
                if (where.MallBaseId > 0)
                {
                    sb.AppendFormat(" and a.MallBaseId={0}", where.MallBaseId);
                }
                if (!string.IsNullOrWhiteSpace(where.ShoolName))
                {
                    sb.AppendFormat(" and a.ShoolName like '%{0}%'", where.ShoolName);
                }
                if (where.Id > 0)
                {
                    sb.AppendFormat(" and a.Id={0}", where.Id);
                }
            }
            return GetPage<Rb_Education_School_Extend>(pageIndex, pageSize, out rowCount, sb.ToString()).ToList();
        }
    }
}
