﻿using System;
using System.Collections.Generic;
using System.Linq;
using Mall.Common.API;
using Mall.WebApi.Filter;
using Microsoft.AspNetCore.Cors;
using Microsoft.AspNetCore.Mvc;
using Newtonsoft.Json;
using Mall.Common.Plugin;
using Newtonsoft.Json.Linq;
using Mall.Common;
using Mall.Module.Miai;
using Mall.Model.Extend.Assess;
using Mall.Model.Extend.Assess;

namespace Mall.WebApi.Controllers.MallBase
{
    [Route("api/[controller]/[action]")]
    [ApiExceptionFilter]
    [ApiController]
    [EnableCors("AllowCors")]
    public class AssessController : BaseController
    {
        private readonly AssessModule assessModule = new AssessModule();

        #region 分类
        /// <summary>
        /// 获取分类分页列表
        /// </summary>
        /// <returns></returns>
        [HttpPost]
        public ApiResult GetCategoryPageList()
        {
            var req = base.RequestParm;
            ResultPageModel pagelist = JsonConvert.DeserializeObject<ResultPageModel>(req.msg.ToString());
            RB_Assess_Category_Extend demodel = JsonConvert.DeserializeObject<RB_Assess_Category_Extend>(req.msg.ToString());

            demodel.TenantId = Convert.ToInt32(req.uid);
            demodel.MallBaseId = req.MallBaseId;
            var list = assessModule.GetCategoryPageList(pagelist.pageIndex, pagelist.pageSize, out long count, demodel);
            pagelist.count = Convert.ToInt32(count);
            pagelist.pageData = list.Select(x => new
            {
                x.Id,
                x.Name,
                x.Image,
                x.Enable,
                x.Sort,
                CreateDate = x.CreateDate.ToString("yyyy-MM-dd HH:mm:ss")
            });
            return ApiResult.Success("", pagelist);
        }

        /// <summary>
        /// 获取分类下拉列表
        /// </summary>
        /// <returns></returns>
        [HttpPost]
        public ApiResult GetCategoryDropList()
        {
            var req = base.RequestParm;
            RB_Assess_Category_Extend demodel = JsonConvert.DeserializeObject<RB_Assess_Category_Extend>(req.msg.ToString());

            demodel.TenantId = Convert.ToInt32(req.uid);
            demodel.MallBaseId = req.MallBaseId;
            demodel.Enable = 1;
            var list = assessModule.GetCategoryList(demodel);
            return ApiResult.Success("", list.OrderByDescending(x => x.Sort).Select(x => new
            {
                x.Id,
                x.Name,
                x.Image,
                x.Sort,
                CreateDate = x.CreateDate.ToString("yyyy-MM-dd HH:mm:ss")
            }));
        }

        /// <summary>
        /// 新增修改分类
        /// </summary>
        /// <returns></returns>
        [HttpPost]
        public ApiResult SetCategoryInfo() {
            var req = RequestParm;
            RB_Assess_Category_Extend demodel = JsonHelper.DeserializeObject<RB_Assess_Category_Extend>(req.msg.ToString());
            if (string.IsNullOrEmpty(demodel.Name)) {
                return ApiResult.ParamIsNull("请传递分类名称");
            }
            if (string.IsNullOrEmpty(demodel.Image)) {
                return ApiResult.ParamIsNull("请上传分类背景图片");   
            }
            demodel.Enable = demodel.Enable == 0 ? 1:demodel.Enable;

            demodel.TenantId = req.TenantId;
            demodel.MallBaseId = req.MallBaseId;
            demodel.CreateBy = req.EmpId;
            demodel.CreateDate = DateTime.Now;
            demodel.UpdateBy = req.EmpId;

            string msg = assessModule.SetCategoryInfo(demodel);
            if (msg == "")
            {
                return ApiResult.Success();
            }
            else {
                return ApiResult.Failed(msg);
            }
        }

        /// <summary>
        /// 删除分类
        /// </summary>
        /// <returns></returns>
        [HttpPost]
        public ApiResult DelCategoryInfo() {
            JObject parms = JObject.Parse(base.RequestParm.msg.ToString());
            int CategoryId = parms.GetInt("CategoryId", 0);
            if (CategoryId <= 0) {
                return ApiResult.ParamIsNull();
            }

            bool flag = assessModule.DelCategoryInfo(CategoryId);
            return flag ? ApiResult.Success() : ApiResult.Failed();
        }

        #endregion



    }
}