﻿using Mall.Common.Enum;
using Mall.Model.Extend.TradePavilion;
using Mall.Repository.TradePavilion;
using System;
using System.Collections.Generic;
using System.Linq;
using VT.FW.DB;

namespace Mall.Module.TradePavilion
{
    /// <summary>
    /// 载体处理类
    /// </summary>
    public class BuildingCarrierModule
    {
        

        /// <summary>
        /// 【商载通】楼宇、载体仓储层
        /// </summary>
        private readonly RB_Building_CarrierRepository  building_CarrierRepository = new RB_Building_CarrierRepository();
        /// <summary>
        /// 【商载通】楼宇、载体地铁仓储层
        /// </summary>
        private readonly RB_Building_CarriermetroRepository building_CarriermetroRepository = new RB_Building_CarriermetroRepository();

        

        /// <summary>
        /// 获取楼宇分页列表
        /// </summary>
        /// <param name="pageIndex"></param>
        /// <param name="pageSize"></param>
        /// <param name="rowsCount"></param>
        /// <param name="query"></param>
        /// <returns></returns>
        public List<RB_Building_Carrier_Extend> GetBuildingCarrierPageModule(int pageIndex, int pageSize, out long rowsCount, RB_Building_Carrier_Extend query)
        {
            var list= building_CarrierRepository.GetBuildingCarrierPageRepository(pageIndex, pageSize, out rowsCount, query);
            if (list != null && list.Count > 0)
            {
                string Ids = string.Join(",", list.Select(qitem => qitem.ID));
                List<RB_Building_Carriermetro_Extend> metroList = new List<RB_Building_Carriermetro_Extend>();
                if (!string.IsNullOrEmpty(Ids))
                {
                    metroList= building_CarriermetroRepository.GetBuildingCarrierMetroListRepository(new RB_Building_Carriermetro_Extend() { CarrierIds = Ids });
                }
                foreach (var item in list)
                {
                    item.BuildingCarriermetroList = metroList.Where(qitem => qitem.CarrierId == item.ID)?.ToList() ?? new List<RB_Building_Carriermetro_Extend>();
                }
            }
            return list;
        }


        /// <summary>
        /// 获取楼宇列表
        /// </summary>
        /// <param name="query"></param>
        /// <returns></returns>
        public List<RB_Building_Carrier_Extend> GetBuildingCarrierListModule(RB_Building_Carrier_Extend query)
        {
            return building_CarrierRepository.GetBuildingCarrierListRepository(query);
        }

        /// <summary>
        /// 新增修改楼宇
        /// </summary>
        /// <param name="extModel"></param>
        /// <returns></returns>
        public bool SetBuildingCarrierModule(RB_Building_Carrier_Extend extModel)
        {
            bool flag = false;
            if (extModel.ID > 0)
            {
                Dictionary<string, object> fileds = new Dictionary<string, object>()
                {
                    {nameof(RB_Building_Carrier_Extend.CarrierName),extModel.CarrierName },
                    {nameof(RB_Building_Carrier_Extend.Logo),extModel.Logo },
                    {nameof(RB_Building_Carrier_Extend.Banner),extModel.Banner },
                    {nameof(RB_Building_Carrier_Extend.Honor),extModel.Honor },
                    {nameof(RB_Building_Carrier_Extend.Developers),extModel.Developers },
                    {nameof(RB_Building_Carrier_Extend.OpeningStatus),extModel.OpeningStatus },
                    {nameof(RB_Building_Carrier_Extend.VideoUrl),extModel.VideoUrl },
                    {nameof(RB_Building_Carrier_Extend.Address),extModel.Address },
                    {nameof(RB_Building_Carrier_Extend.LatAndLon),extModel.LatAndLon },
                    {nameof(RB_Building_Carrier_Extend.OpenTime),extModel.OpenTime },
                    {nameof(RB_Building_Carrier_Extend.BuildingCarrierType),extModel.BuildingCarrierType },
                    {nameof(RB_Building_Carrier_Extend.CategoryId),extModel.CategoryId },
                    {nameof(RB_Building_Carrier_Extend.Ascription),extModel.Ascription },
                    {nameof(RB_Building_Carrier_Extend.CarrierSize),extModel.CarrierSize },
                    {nameof(RB_Building_Carrier_Extend.PropertyComposition),extModel.PropertyComposition },
                    {nameof(RB_Building_Carrier_Extend.Location),extModel.Location },
                    {nameof(RB_Building_Carrier_Extend.Crowd),extModel.Crowd },
                    {nameof(RB_Building_Carrier_Extend.VisitorsFlowrate),extModel.VisitorsFlowrate },
                    {nameof(RB_Building_Carrier_Extend.LayersNum),extModel.LayersNum },
                    {nameof(RB_Building_Carrier_Extend.SupportingFacilities),extModel.SupportingFacilities },
                    {nameof(RB_Building_Carrier_Extend.ManagementCompany),extModel.ManagementCompany },
                    {nameof(RB_Building_Carrier_Extend.BrandDemand),extModel.BrandDemand },
                    {nameof(RB_Building_Carrier_Extend.UpdateBy),extModel.UpdateBy },
                    {nameof(RB_Building_Carrier_Extend.UpdateDate),extModel.UpdateDate },
                };
                flag = building_CarrierRepository.Update(fileds, new WhereHelper(nameof(RB_Building_Carrier_Extend.ID), extModel.ID));
            }
            else
            {
                var newId = building_CarrierRepository.Insert(extModel);
                extModel.ID = newId;
                flag = newId > 0;
            }

            if (flag)
            {
                var oldCarrierMetroList = building_CarriermetroRepository.GetBuildingCarrierMetroListRepository(new  RB_Building_Carriermetro_Extend { TenantId = extModel.TenantId, MallBaseId = extModel.MallBaseId, CarrierId = extModel.ID });
                building_CarriermetroRepository.DeleteBatch(oldCarrierMetroList);
                foreach (var item in extModel.BuildingCarriermetroList)
                {
                    item.ID = 0;
                    item.Status = 0;
                    item.TenantId = extModel.TenantId;
                    item.MallBaseId = extModel.MallBaseId;
                    item.CarrierId = extModel.ID;
                }
                building_CarriermetroRepository.InsertBatch(extModel.BuildingCarriermetroList);
            }
            return flag;
        }

        /// <summary>
        /// 删除楼宇
        /// </summary>
        /// <param name="ID"></param>
        /// <returns></returns>
        public bool RemoveBuildingCarrierModule(int ID)
        {
            Dictionary<string, object> fileds = new Dictionary<string, object>()
            {
                {nameof(RB_Building_Carrier_Extend.Status),(int)DateStateEnum.Delete },
                {nameof(RB_Building_Carrier_Extend.UpdateDate),DateTime.Now }
            };
            bool flag = building_CarrierRepository.Update(fileds, new WhereHelper(nameof(RB_Building_Carrier_Extend.ID), ID));
            return flag;
        }

        /// <summary>
        /// 根据编号获取楼宇详情
        /// </summary>
        /// <param name="ID"></param>
        /// <returns></returns>
        public RB_Building_Carrier_Extend GetBuildingCarrierModule(int ID)
        {
            var extModel = building_CarrierRepository.GetEntity<RB_Building_Carrier_Extend>(ID);
            if (extModel != null && extModel.ID > 0)
            {
                var bcMetroList = building_CarriermetroRepository.GetBuildingCarrierMetroListRepository(new RB_Building_Carriermetro_Extend() { CarrierId = extModel.ID });
                extModel.BuildingCarriermetroList = bcMetroList ?? new List<RB_Building_Carriermetro_Extend>();
            }
            return extModel;
        }
    }
}
