﻿using Mall.Model.Entity.Property;
using Mall.Model.Extend.Property;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;

namespace Mall.Repository.Property
{
    /// <summary>
    /// 耗材档案仓储类
    /// </summary>
    public partial class RB_Supplies_MaterialRepository : RepositoryBase<RB_Supplies_Material>
    {
        /// <summary>
        /// 获取耗材分页数据
        /// </summary>
        /// <param name="pageIndex"></param>
        /// <param name="pageSize"></param>
        /// <param name="dmodel"></param>
        /// <param name="count"></param>
        /// <returns></returns>
        public List<RB_Supplies_Material_Extend> GetPageList(int pageIndex, int pageSize, RB_Supplies_Material_Extend dmodel, out long count)
        {
            string where = " where 1=1 ";
            where += string.Format(" AND sm.{0}={1}", nameof(RB_Supplies_Material_Extend.Status), 0);
            where += $@" and sm.RB_Group_Id={dmodel.RB_Group_Id}";            
            if (!string.IsNullOrWhiteSpace(dmodel.Name.Trim()))
            {
                where += " and sm." + nameof(RB_Supplies_Material_Extend.Name) + " like '%" + dmodel.Name.Trim() + "%'";
            }
            if (!string.IsNullOrWhiteSpace(dmodel.SuppliesNum.Trim()))
            {
                where += " and sm." + nameof(RB_Supplies_Material_Extend.SuppliesNum) + " like '%" + dmodel.SuppliesNum.Trim() + "%'";
            }
            if (!string.IsNullOrWhiteSpace(dmodel.BrandName.Trim()))
            {
                where += " and sm." + nameof(RB_Supplies_Material_Extend.BrandName) + " like '%" + dmodel.BrandName.Trim() + "%'";
            }
            if (!string.IsNullOrWhiteSpace(dmodel.SupplierName.Trim()))
            {
                where += " and sm." + nameof(RB_Supplies_Material_Extend.SupplierName) + " like '%" + dmodel.SupplierName.Trim() + "%'";
            }

            if (dmodel.CategoryId > 0) {
                where += " and sm." + nameof(RB_Supplies_Material_Extend.CategoryId) + "=" + dmodel.CategoryId;
            }
            
            string sql = $@" select sm.*,pc.Name as CategoryName from RB_Supplies_Material sm
left join rb_property_category pc on sm.CategoryId=pc.Id
{where} order by sm.Id desc";
            return GetPage<RB_Supplies_Material_Extend>(pageIndex, pageSize, out count, sql).ToList();
        }

        /// <summary>
        /// 获取列表
        /// </summary>
        /// <param name="dmodel"></param>
        /// <returns></returns>
        public List<RB_Supplies_Material_Extend> GetList(RB_Supplies_Material_Extend dmodel)
        {
            string where = " where 1=1 ";
            where += string.Format(" AND sm.{0}={1}", nameof(RB_Supplies_Material_Extend.Status), 0);
            where += $@" and sm.RB_Group_Id={dmodel.RB_Group_Id}";
            if (!string.IsNullOrWhiteSpace(dmodel.Name))
            {
                where += " and sm." + nameof(RB_Supplies_Material_Extend.Name) + " like '%" + dmodel.Name + "%'";
            }
            if (!string.IsNullOrWhiteSpace(dmodel.SuppliesNum))
            {
                where += " and sm." + nameof(RB_Supplies_Material_Extend.SuppliesNum) + " like '%" + dmodel.SuppliesNum + "%'";
            }
            if (!string.IsNullOrWhiteSpace(dmodel.BrandName))
            {
                where += " and sm." + nameof(RB_Supplies_Material_Extend.BrandName) + " like '%" + dmodel.BrandName + "%'";
            }
            if (!string.IsNullOrWhiteSpace(dmodel.SupplierName))
            {
                where += " and sm." + nameof(RB_Supplies_Material_Extend.SupplierName) + " like '%" + dmodel.SupplierName + "%'";
            }

            if (dmodel.CategoryId > 0)
            {
                where += " and sm." + nameof(RB_Supplies_Material_Extend.CategoryId) + "=" + dmodel.CategoryId;
            }
            if (!string.IsNullOrEmpty(dmodel.SuppliesIdStr)) {
                where += " and sm." + nameof(RB_Supplies_Material_Extend.Id) + " in(" + dmodel.SuppliesIdStr + ")";
            }

            string sql = $@" select sm.*,pc.Name as CategoryName from RB_Supplies_Material sm
left join rb_property_category pc on sm.CategoryId=pc.Id
{where} order by sm.Id desc";
            return Get<RB_Supplies_Material_Extend>(sql).ToList();
        }

    }
}
