﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using Mall.Model.Entity.Education;
using Mall.Model.Extend.Education;
using VT.FW.DB.Dapper;

namespace Mall.Repository.Education
{
    /// <summary>
    /// 活动周期仓储层
    /// </summary>
    public class RB_Activity_PeriodsRepository : BaseRepository<RB_Activity_Periods>
    {
        /// <summary>
        /// 获取列表
        /// </summary>
        /// <param name="demodel"></param>
        /// <returns></returns>
        public List<RB_Activity_Periods_ViewModel> GetList(RB_Activity_Periods_ViewModel demodel)
        {
            string where = $@" 1=1";

            if (demodel.Group_Id > 0)
            {
                where += $@" and r.{nameof(RB_Activity_Periods_ViewModel.Group_Id)} ={demodel.Group_Id}";
            }
            if (!string.IsNullOrEmpty(demodel.Name))
            {
                where += $@" and r.{nameof(RB_Activity_Periods_ViewModel.Name)} like '%{demodel.Name}%'";
            }
            if (!string.IsNullOrEmpty(demodel.Periods))
            {
                where += $@" and r.{nameof(RB_Activity_Periods_ViewModel.Periods)} ='{demodel.Periods}'";
            }

            string sql = $@" select r.* from RB_Activity_Periods r where {where} order by r.Id desc";
            return Get<RB_Activity_Periods_ViewModel>(sql).ToList();
        }

        /// <summary>
        /// 获取分页列表
        /// </summary>
        /// <param name="pageIndex"></param>
        /// <param name="pageSize"></param>
        /// <param name="count"></param>
        /// <param name="demodel"></param>
        /// <returns></returns>
        public List<RB_Activity_Periods_ViewModel> GetPageList(int pageIndex, int pageSize, out long count, RB_Activity_Periods_ViewModel demodel)
        {
            string where = $@" 1=1";

            if (demodel.Group_Id > 0)
            {
                where += $@" and r.{nameof(RB_Activity_Periods_ViewModel.Group_Id)} ={demodel.Group_Id}";
            }
            if (!string.IsNullOrEmpty(demodel.Name))
            {
                where += $@" and r.{nameof(RB_Activity_Periods_ViewModel.Name)} like '%{demodel.Name}%'";
            }

            string sql = $@" select r.* from RB_Activity_Periods r where {where} order by r.Id desc";
            return GetPage<RB_Activity_Periods_ViewModel>(pageIndex, pageSize, out count, sql).ToList();
        }

    }
}
