﻿using System;
using System.Collections.Generic;
using System.Linq;
using Dnc.Api.Throttle;
using Mall.CacheManager.User;
using Mall.Common;
using Mall.Common.API;
using Mall.Common.Enum;
using Mall.Common.Enum.Goods;
using Mall.Common.Enum.MarketingCenter;
using Mall.Common.Plugin;
using Mall.Model.Extend.Coffee;
using Mall.Model.Extend.Product;
using Mall.Module.Education;
using Mall.WebApi.Filter;
using Microsoft.AspNetCore.Authorization;
using Microsoft.AspNetCore.Cors;
using Microsoft.AspNetCore.Http;
using Microsoft.AspNetCore.Mvc;
using Newtonsoft.Json;
using Newtonsoft.Json.Linq;

namespace Mall.WebApi.Controllers.Education
{
    [Route("api/[controller]/[action]")]
    [ApiExceptionFilter]
    [ApiController]
    [EnableCors("AllowCors")]
    public class AppletCoffeeController : BaseController
    {
        private readonly CoffeeModule coffeeModule = new CoffeeModule();


        /// <summary>
        /// 获取我的咖啡劵信息
        /// </summary>
        /// <returns></returns>
        [HttpPost]
        public ApiResult GetMyCoffeeCouponsInfo() {
            var userInfo = base.AppletUserInfo;

            var Robj = coffeeModule.GetMyCoffeeCouponsInfo(userInfo, out string rmsg);
            if (rmsg == "")
            {
                return ApiResult.Success("", Robj);
            }
            else {
                return ApiResult.Failed(rmsg);
            }
        }

        /// <summary>
        /// 获取我的咖啡劵消费分页列表
        /// </summary>
        /// <returns></returns>
        [HttpPost]
        public ApiResult GetMyCoffeeCouponsPageList()
        {
            var userInfo = base.AppletUserInfo;
            ResultPageModel pageModel = JsonConvert.DeserializeObject<ResultPageModel>(base.RequestParm.msg.ToString());
            RB_Member_CoffeeLog_Extend demodel = JsonHelper.DeserializeObject<RB_Member_CoffeeLog_Extend>(base.RequestParm.msg.ToString());
            demodel.MallBaseId = userInfo.MallBaseId;
            demodel.UserId = userInfo.UserId;

            var list = coffeeModule.GetMyCoffeeCouponsPageList(pageModel.pageIndex, pageModel.pageSize, out long count, demodel);
            pageModel.count = Convert.ToInt32(count);
            pageModel.pageData = list.Select(x => new
            {
                x.Id,
                x.Type,
                x.Number,
                x.Remark,
                CreateDate = x.CreateDate.ToString("yyyy-MM-dd HH:mm")
            });
            return ApiResult.Success("", pageModel);
        }

        /// <summary>
        /// 获取我的咖啡劵订单分页列表
        /// </summary>
        /// <returns></returns>
        [HttpPost]
        public ApiResult GetMyCofeeOrderPageList() {
            var userInfo = base.AppletUserInfo;
            ResultPageModel pageModel = JsonConvert.DeserializeObject<ResultPageModel>(base.RequestParm.msg.ToString());
            RB_Goods_Order_Extend demodel = JsonHelper.DeserializeObject<RB_Goods_Order_Extend>(base.RequestParm.msg.ToString());
            demodel.MallBaseId = userInfo.MallBaseId;
            demodel.UserId = userInfo.UserId;
            demodel.OrderEduType = 1;//只查询咖啡劵
            demodel.Q_OrderEduType = 1;

            var list = coffeeModule.GetMyCofeeOrderPageList(pageModel.pageIndex, pageModel.pageSize, out long count, demodel);
            pageModel.count = Convert.ToInt32(count);
            pageModel.pageData = list.Select(x => new
            {
                x.OrderId,
                x.OrderNo,
                x.PreferPrice,
                x.OrderStatus,
                DetailList = x.DetailList.Select(y => new
                {
                    y.Id,
                    y.GoodsId,
                    y.GoodsName,
                    y.CoverImage,
                    y.Number,
                    y.Final_Price,
                    y.PresentCoffeeNum
                }),
                CreateDate = x.CreateDate.Value.ToString("yyyy-MM-dd HH:mm")
            });
            return ApiResult.Success("", pageModel);
        }

        /// <summary>
        /// 获取我的咖啡劵订单详情
        /// </summary>
        /// <returns></returns>
        [HttpPost]
        public ApiResult GetMyCoffeeOrderInfo()
        {
            var userInfo = base.AppletUserInfo;
            var prams = JObject.Parse(base.RequestParm.msg.ToString());
            int OrderId = prams.GetInt("OrderId", 0);
            if (OrderId <= 0) {
                return ApiResult.ParamIsNull();
            }

            var robj = coffeeModule.GetMyCoffeeOrderInfo(OrderId, userInfo.UserId, userInfo.MallBaseId);
            if (robj == null) {
                return ApiResult.Failed("订单不存在");
            }
            return ApiResult.Success("", new {
                robj.OrderId,
                robj.OrderNo,
                robj.PreferPrice,
                robj.OrderStatus,
                DetailList = robj.DetailList.Select(y => new
                {
                    y.Id,
                    y.GoodsId,
                    y.GoodsName,
                    y.CoverImage,
                    y.Number,
                    y.Final_Price,
                    y.PresentCoffeeNum
                }),
                Address = robj.ShoppingAddress,
                CreateDate = robj.CreateDate.Value.ToString("yyyy-MM-dd HH:mm")
            });
        }

        /// <summary>
        /// 管理员核销咖啡劵
        /// </summary>
        /// <returns></returns>
        [HttpPost]
        public ApiResult SetAdminVerificationCoffee() {
            var userInfo = base.AppletUserInfo;
            var parms = JObject.Parse(base.RequestParm.msg.ToString());
            int UserId = parms.GetInt("UserId", 0);
            string Code = parms.GetStringValue("Code");
            if (UserId <= 0) {
                return ApiResult.ParamIsNull();
            }

            var robj = coffeeModule.SetAdminVerificationCoffee(UserId, Code, userInfo, out string rmsg);
            if (rmsg == "")
            {
                return ApiResult.Success("", robj);
            }
            else {
                return ApiResult.Failed(rmsg);
            }
        }

        /// <summary>
        /// 获取我的咖啡劵使用
        /// </summary>
        /// <returns></returns>
        [HttpPost]
        public ApiResult GetMyCoffeeVerificatInfo()
        {
            var userInfo = base.AppletUserInfo;
            var parms = JObject.Parse(base.RequestParm.msg.ToString());
            string Code = parms.GetStringValue("Code");
            if (string.IsNullOrEmpty(Code))
            {
                return ApiResult.ParamIsNull();
            }

            var robj = coffeeModule.GetMyCoffeeVerificatInfo(Code, userInfo, out string rmsg);
            if (rmsg == "")
            {
                return ApiResult.Success("", new { State =1, Info = robj });
            }
            else
            {
                return ApiResult.Success(rmsg, new { State = 2 });
            }
        }
    }
}