﻿using VT.FW.DB;
using System;
using System.Collections.Generic;
using System.Text;
using Mall.Model.Entity.User;

namespace Mall.Model.Extend.User
{
    /// <summary>
    /// 商户用户表扩展实体
    /// </summary>
    [Serializable]
    [DB(ConnectionName = "DefaultConnection")]
    public class RB_Member_User_Extend : RB_Member_User
    {
        /// <summary>
        /// 是否查询电商利润  1是
        /// </summary>
        public int? IsSelectCommpany { get; set; }
        /// <summary>
        /// 是否用户头像为空  1是  2否
        /// </summary>
        public int? IsEmptyUserPhoto { get; set; }
        /// <summary>
        /// 会员等级名称
        /// </summary>
        public string MemberGradeName { get; set; }

        /// <summary>
        /// 导出枚举ids
        /// </summary>
        public List<int> ExcelEnumIds { get; set; }

        /// <summary>
        /// 用户ids
        /// </summary>
        public string UserIds { get; set; }

        /// <summary>
        /// 获取用户
        /// </summary>
        public int? MinUserId { get; set; }

        /// <summary>
        /// 粉象等级ID
        /// </summary>
        public int? FXGradeId { get; set; }
        /// <summary>
        /// 粉象等级ids
        /// </summary>
        public string FXGradeIds { get; set; }

        /// <summary>
        /// 用户名str
        /// </summary>
        public string UserNameStr { get; set; }
        /// <summary>
        /// 开始时间
        /// </summary>
        public string StartTime { get; set; }
        /// <summary>
        /// 结束时间
        /// </summary>
        public string EndTime { get; set; }

        /// <summary>
        /// 下线数量
        /// </summary>
        public int? ReferralsNum { get; set; }
        /// <summary>
        /// 分销商名称
        /// </summary>
        public string DistributorName { get; set; }
        /// <summary>
        /// 分销商电话
        /// </summary>
        public string DistributorMobile { get; set; }

        #region 数据统计-分销排行字段
        /// <summary>
        /// 累计佣金
        /// </summary>
        public decimal TotalCommission { get; set; }

        /// <summary>
        /// 已提现佣金
        /// </summary>
        public decimal Price { get; set; }

        /// <summary>
        /// 待结算
        /// </summary>
        public decimal WaitCommission { get; set; }

        /// <summary>
        /// 总佣金
        /// </summary>
        public decimal Commission { get; set; }

        /// <summary>
        /// 直接下级数据
        /// </summary>
        public int ChildrenNum { get; set; }

        /// <summary>
        /// 总下级数
        /// </summary>

        public int AllChildrenNum { get; set; }
        /// <summary>
        /// 订单数
        /// </summary>
        public int AllOrderNum { get; set; }


        /// <summary>
        /// 排序
        /// </summary>
        public string OrderBy { get; set; }

        #endregion

        /// <summary>
        /// 小程序排序
        /// </summary>
        public int SortNum { get; set; }

        /// <summary>
        /// 是否已提现   1是   2否
        /// </summary>
        public int IsRemit { get; set; }

        /// <summary>
        /// 用户等级头像
        /// </summary>
        public string Icon { get; set; }



        /// <summary>
        /// 是否赞羊使用0-否，1-是
        /// </summary>
        public int IsZanYangUse { get; set; }

        /// <summary>
        /// 是否直接下级[1-是]
        /// </summary>
        public int IsDirect { get; set; }

        /// <summary>
        /// 店铺Id
        /// </summary>
        public int ShopId { get; set; }

        /// <summary>
        /// 店铺名称
        /// </summary>
        public string ShopName { get; set; }

        /// <summary>
        /// 真实订单数量
        /// </summary>
        public int RealOrderNum { get; set; }

        /// <summary>
        /// 实收金额
        /// </summary>
        public decimal Income { get; set; }


        /// <summary>
        /// 口令优惠券=5其他都等于0
        /// </summary>
        public int CounponPassword { get; set; }

        /// <summary>
        /// 口令
        /// </summary>
        public string KeyWord { get; set; }

    }


    /// <summary>
    /// 抖音客户实体类
    /// </summary>
    public class ByteDanceCustomer
    {
        /// <summary>
        ///  form Id
        /// </summary>
        public string FormId { get; set; }

        /// <summary>
        /// form Id缓存时间
        /// </summary>
        public DateTime FormCreateDate { get; set; }

        /// <summary>
        /// 用户的标识
        /// </summary>
        public string Openid { get; set; }

        /// <summary>
        /// 客户编号
        /// </summary>
        public int UserID { get; set; }
    }
}
