﻿using Mall.Common.AOP;
using Mall.Common.Enum.User;
using System;
using System.Collections.Generic;
using System.Text;

namespace Mall.Model.Entity.Product
{
    /// <summary>
    /// 商品关联分销佣金表实体
    /// </summary>
    [Serializable]
    [DB(ConnectionName = "DefaultConnection")]
    public class RB_Goods_DistributionCommission
    {

        /// <summary>
        /// Id
        /// </summary>        
        public int Id
        {
            get;
            set;
        }
        /// <summary>
        /// 商品id
        /// </summary>        
        public int? GoodsId
        {
            get;
            set;
        }
        /// <summary>
        /// 规格排序组  逗号分隔每规格值
        /// </summary>        
        public string SpecificationSort
        {
            get;
            set;
        }
        /// <summary>
        /// 分销商等级   0普通等级
        /// </summary>        
        public int? DistributorGrade
        {
            get;
            set;
        }
        /// <summary>
        /// 一级佣金
        /// </summary>        
        public decimal? OneCommission
        {
            get;
            set;
        }
        /// <summary>
        /// 二级佣金
        /// </summary>        
        public decimal? TwoCommission
        {
            get;
            set;
        }
        /// <summary>
        /// 三级佣金
        /// </summary>        
        public decimal? ThreeCommission
        {
            get;
            set;
        }
        /// <summary>
        /// Status
        /// </summary>        
        public int? Status
        {
            get;
            set;
        }
        /// <summary>
        /// 商户号
        /// </summary>        
        public int TenantId
        {
            get;
            set;
        }
        /// <summary>
        /// 小程序id
        /// </summary>        
        public int MallBaseId
        {
            get;
            set;
        }
        /// <summary>
        /// CreateDate
        /// </summary>        
        public DateTime? CreateDate
        {
            get;
            set;
        }
        /// <summary>
        /// UpdateDate
        /// </summary>        
        public DateTime? UpdateDate
        {
            get;
            set;
        }
    }
}
