﻿using System.Collections.Generic;
using System.Linq;
using System.Threading;

namespace Mall.ThirdCore.Message
{
    /// <summary>
    /// 消息队列
    /// </summary>
    public class QueueHelper
    {
        /// <summary>
        /// 任务队列
        /// </summary>
        public static Queue<string> Queue = new Queue<string>();

        /// <summary>
        /// 线程锁
        /// </summary>
        private static object locker = new object();

        /// <summary>
        /// 添加消息到队列
        /// </summary>
        /// <param name="task"></param>
        public static void EnqueueTask(string task)
        {
            lock (locker)
            {
                //同样的任务，不同时加入
                IList<string> tasks = Queue.ToList();
                if (tasks.Count(p => p == task) == 0)
                {
                    Queue.Enqueue(task);
                    Monitor.PulseAll(locker);
                }
            }
        }
    }
}
