﻿using Mall.Common.AOP;
using System;
using System.Collections.Generic;
using System.Text;

namespace Mall.Model.Entity.User
{
    /// <summary>
    /// 商户信息表实体
    /// </summary>
    [Serializable]
    [DB(ConnectionName = "DefaultConnection")]
    public class RB_Tenant
    {
        /// <summary>
        /// 商户号
        /// </summary>        
        public int TenantId
        {
            get;
            set;
        }

        /// <summary>
        /// 账号
        /// </summary>        
        public string Account
        {
            get;
            set;
        }

        /// <summary>
        /// 密码
        /// </summary>        
        public string Password
        {
            get;
            set;
        }

        /// <summary>
        /// 姓名/企业名称
        /// </summary>        
        public string Name
        {
            get;
            set;
        }

        /// <summary>
        /// 手机号码
        /// </summary>        
        public string MobilePhone
        {
            get;
            set;
        }

        /// <summary>
        /// 微信号
        /// </summary>        
        public string WeChatNum
        {
            get;
            set;
        }

        /// <summary>
        /// 申请原因
        /// </summary>        
        public string ApplyReason
        {
            get;
            set;
        }

        /// <summary>
        /// 身份证正面图片
        /// </summary>        
        public string IDCardPositiveImg
        {
            get;
            set;
        }

        /// <summary>
        /// 身份证背面图片
        /// </summary>        
        public string IDCardReverseImg
        {
            get;
            set;
        }

        /// <summary>
        /// 营业执照图片
        /// </summary>        
        public string BusinessLicenseImg
        {
            get;
            set;
        }

        /// <summary>
        /// 创建时间
        /// </summary>        
        public DateTime? CreateDate
        {
            get;
            set;
        }

        /// <summary>
        /// 是否永久有效(0-默认，1-永久有效)
        /// </summary>        
        public int? IsEffective
        {
            get;
            set;
        }

        /// <summary>
        /// 账号有效期
        /// </summary>        
        public DateTime? AccountValidate
        {
            get;
            set;
        }

        /// <summary>
        /// 可创建小程序数量
        /// </summary>        
        public int? CreateMiniPrograme
        {
            get;
            set;
        }

        /// <summary>
        /// 账号状态(0-默认，1-提交申请，2-审核通过，3-审核拒绝）
        /// </summary>        
        public int? AccountStatus
        {
            get;
            set;
        }
    }
}
