﻿using Mall.Common.AOP;
using System;
using System.Collections.Generic;
using System.Text;
using Mall.Model.Entity.User;

namespace Mall.Model.Extend.User
{
    /// <summary>
    /// 商品海报扩展实体类
    /// </summary>
    [Serializable]
    [DB(ConnectionName = "DefaultConnection")]
    public class RB_MiniProgram_GoodPoster_Extend : Model.Entity.User.RB_MiniProgram_GoodPoster
    {
        /// <summary>
        /// 海报样式
        /// </summary>
        public List<int> PosterStyleList
        {
            get
            {
                List<int> posters = new List<int>();
                if (this.PosterStyle != null && !string.IsNullOrWhiteSpace(this.PosterStyle))
                {
                    var array = this.PosterStyle.Split(",");
                    if (array != null && array.Length > 0)
                    {
                        foreach (var item in array)
                        {
                            Int32.TryParse(item, out int presult);
                            if (presult > 0)
                            {
                                posters.Add(presult);
                            }
                        }
                    }
                }
                return posters;
            }
        }

        /// <summary>
        /// 商品样式
        /// </summary>
        public List<int> GoodsImgCountList
        {
            get
            {
                List<int> goods = new List<int>();
                if (this.GoodsImgCount != null && !string.IsNullOrWhiteSpace(this.GoodsImgCount))
                {
                    var array = this.GoodsImgCount.Split(",");
                    if (array != null && array.Length > 0)
                    {
                        foreach (var item in array)
                        {
                            Int32.TryParse(item, out int result);
                            if (result > 0)
                            {
                                goods.Add(result);
                            }
                        }
                    }
                }
                return goods;
            }
        }
    }
}
