﻿using Mall.Model.Entity.MarketingCenter;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;

namespace Mall.Repository.MarketingCenter
{
    /// <summary>
    /// 自定义充值仓储层
    /// </summary>
    public class RB_Recharge_CustomRepository : RepositoryBase<RB_Recharge_Custom>
    {

        /// <summary>
        /// 表名称
        /// </summary>
        public string TableName { get { return nameof(RB_Recharge_Custom); } }

        /// <summary>
        /// 自定义充值信息列表
        /// </summary>
        /// <param name="query">查询条件</param>
        /// <returns></returns>
        public List<RB_Recharge_Custom> GetRechargeCustomList(RB_Recharge_Custom query)
        {
            StringBuilder builder = new StringBuilder();
            builder.Append($" SELECT * FROM {TableName} WHERE {nameof(RB_Recharge_Custom.Status)}=0 ");
            if (query != null)
            {
                if (query.ID > 0)
                {
                    builder.Append($" AND {nameof(RB_Recharge_Custom.ID)}={query.ID}");
                }
                if (query.TenantId > 0)
                {
                    builder.Append($" AND {nameof(RB_Recharge_Custom.TenantId)}={query.TenantId}");
                }
                if (query.TenantId > 0)
                {
                    builder.Append($" AND {nameof(RB_Recharge_Custom.MallBaseId)}={query.MallBaseId}");
                }

            }
            return Get<RB_Recharge_Custom>(builder.ToString()).ToList();
        }
    }
}
