﻿using System;
using System.Collections.Generic;
using System.Text;
using Mall.Common.Enum;
using VT.FW.DB;

namespace Mall.Model.Entity.MarketingCenter
{
    /// <summary>
    /// 用户意见信息表
    /// </summary>
    [Serializable]
    [DB(ConnectionName = "DefaultConnection")]
    public class Rb_GuestSurvey
    {
        /// <summary>
        /// 编号
        /// </summary>
        public int ID { get; set; }

        /// <summary>
        /// 会员id
        /// </summary>
        public int? UserId { get; set; }

        /// <summary>
        /// 活动id
        /// </summary>
        public int ActivitySurveyId { get; set; }

        /// <summary>
        /// 小程序编号
        /// </summary>        
        public int MallBaseId { get; set; }

        /// <summary>
        /// 商户编号
        /// </summary>        
        public int TenantId { get; set; }

        /// <summary>
        /// 创建时间
        /// </summary>
        public DateTime? CreateDate { get; set; }

        /// <summary>
        /// 删除
        /// </summary>
        public DateStateEnum State { get; set; }

        /// <summary>
        /// 用户类型(1-小程序用户，2-教育学员)
        /// </summary>
        public int UserType { get; set; }
    }
}
