﻿using VT.FW.DB;
using System;
using System.Collections.Generic;
using System.Text;

namespace Mall.Model.Query
{
    [Serializable]
    [DB(ConnectionName = "DefaultConnection")]
    public class DataStatistics_Query
    {
        public int TenantId { get; set; }

        public int MallBaseId { get; set; }

        public int PlatformType { get; set; }

        /// <summary>
        /// 开始时间【查询使用】
        /// </summary>
        public string StartDate { get; set; }

        /// <summary>
        /// 结束时间【查询使用】
        /// </summary>
        public string EndDate { get; set; }


        /// <summary>
        /// 会员数
        /// </summary>
        public int MemberNum { get; set; }

        /// <summary>
        /// 商品数
        /// </summary>
        public int GoodsNum { get; set; }


        /// <summary>
        /// 商品名称
        /// </summary>
        public string Name { get; set; }
        /// <summary>
        /// 订单数
        /// </summary>
        public int OrderNum { get; set; }
        /// <summary>
        /// 代发货数
        /// </summary>
        public int NotDeliverNum { get; set; }
        /// <summary>
        /// 售后数
        /// </summary>
        public int AfterSale { get; set; }

        /// <summary>
        /// 支付订单数
        /// </summary>
        public int OrderPay { get; set; }


        /// <summary>
        /// 支付金额
        /// </summary>
        public decimal PayMoney { get; set; }

        /// <summary>
        /// 复购人数
        /// </summary>
        public int RepurchaseNum { get; set; }


        /// <summary>
        /// 支付人数
        /// </summary>
        public int PayMemerNum { get; set; }

        /// <summary>
        /// 支付件数
        /// </summary>
        public int BuyNum { get; set; }

        /// <summary>
        /// 折线图统计
        /// </summary>
        public List<OrderLine> OrderLineList { get; set; }

        /// <summary>
        /// 是否是昨日（主要是销售情况，分昨日和近7天）
        /// </summary>
        public int IsYesterday { get; set; }


        public string CreateDate { get; set; }


        /// <summary>
        /// 订单状态0-全部，1-未完成，2-已完成，3-已取消，4-售后中，5-已完成售后
        /// </summary>
        public int OrderStatus { get; set; }

        /// <summary>
        /// 订单类型
        /// </summary>
        public int OrderType { get; set; }
    }


    public class OrderLine
    {
        /// <summary>
        /// 时间
        /// </summary>
        public string DateStr { get; set; }

        /// <summary>
        /// 支付订单数
        /// </summary>
        public int OrderPay { get; set; }


        /// <summary>
        /// 支付金额
        /// </summary>
        public decimal PayMoney { get; set; }


        /// <summary>
        /// 支付人数
        /// </summary>
        public int PayMemerNum { get; set; }

        /// <summary>
        /// 支付件数
        /// </summary>
        public int BuyNum { get; set; }
    }
}
