﻿using VT.FW.DB;
using System;
using System.Collections.Generic;
using System.Text;
using Mall.Model.Entity.User;
using Mall.Common.Enum.User;

namespace Mall.Model.Extend.User
{
    /// <summary>
    /// 分销商表扩展实体
    /// </summary>
    [Serializable]
    [DB(ConnectionName = "DefaultConnection")]
    public class RB_Distributor_Info_Extend : RB_Distributor_Info
    {
        /// <summary>
        /// 来自于自主申请  1是 
        /// </summary>
        public int? IsFormSelfApplication { get; set; }
        /// <summary>
        /// 用户来源
        /// </summary>
        public UserSourceEnum? Source { get; set; }

        /// <summary>
        /// 昵称
        /// </summary>
        public string NickName { get; set; }

          /// <summary>
        /// 会员名称
        /// </summary>
        public string MemberUserName { get; set; }

        /// <summary>
        /// 头像
        /// </summary>
        public string Photo { get; set; }
        /// <summary>
        /// 等级名称
        /// </summary>
        public string GradeName { get; set; }
        /// <summary>
        /// 等级几
        /// </summary>
        public int Grade { get; set; }
        /// <summary>
        /// 和平等级名称
        /// </summary>
        public string HPGradeName { get; set; }
        /// <summary>
        /// 粉象等级名称
        /// </summary>
        public string FXGradeName { get; set; }
        /// <summary>
        /// 上级id
        /// </summary>
        public int? SuperiorId { get; set; }
        /// <summary>
        /// 上级名称
        /// </summary>
        public string SuperiorName { get; set; }
        /// <summary>
        /// 一级分销数量
        /// </summary>
        public int? OneNum { get; set; }
        /// <summary>
        /// 二级分销数量
        /// </summary>
        public int? TwoNum { get; set; }
        /// <summary>
        /// 三级分销数量
        /// </summary>
        public int? ThreeNum { get; set; }
        /// <summary>
        /// 用户ids
        /// </summary>
        public string UserIds { get; set; }

        /// <summary>
        /// 订单数量
        /// </summary>
        public int? OrderNum { get; set; }

        /// <summary>
        /// 下载枚举ids
        /// </summary>
        public List<int> ExcelEnumIds { get; set; }
        /// <summary>
        /// 第几级
        /// </summary>
        public int? ReferralsType { get; set; }


        public string OpenId { get; set; }


        /// <summary>
        /// 查询过期的vip购买记录 0-不查询，1-查询
        /// </summary>
        public int IsSelectOverTime { get; set; }

        /// <summary>
        /// 小程序排序
        /// </summary>
        public int SortNum { get; set; }

        /// <summary>
        /// 是否直接下级[1-是]
        /// </summary>
        public int IsDirect { get; set; }
    }
}
