﻿using Mall.Model.Entity.Education;
using Mall.Model.Extend.Education;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;

namespace Mall.Repository.Education
{
    /// <summary>
    /// 仓储层
    /// </summary>
    public class RB_Education_ArticleRepository : BaseRepository<RB_Education_Article>
    {
        /// <summary>
        /// 表名称
        /// </summary>
        public string TableName { get { return nameof(RB_Education_Article); } }
        /// <summary>
        /// 网课-老师列表
        /// </summary>
        /// <param name="pageIndex">页码</param>
        /// <param name="pageSize">每页显示条数</param>
        /// <param name="rowCount">总条数</param>
        /// <param name="query">查询条件</param>
        /// <returns></returns>
        public List<RB_Education_Article_Extend> GetPageListRepository(int pageIndex, int pageSize, out long rowCount, RB_Education_Article_Extend query)
        {
            StringBuilder builder = new StringBuilder();
            builder.Append(@$" SELECT a.* FROM {TableName} as a   LEFT JOIN (SELECT ArticleId,COUNT(*) as CommentNum from rb_education_articlecomment where `Status`=0 GROUP BY ArticleId ) 
as b on a.ID = b.ArticleId WHERE  a.{nameof(RB_Education_Article_Extend.Status)}=0");
            if (query != null)
            {
                if (query.TenantId > 0)
                {
                    builder.Append($" AND a.{nameof(RB_Education_Article_Extend.TenantId)}={query.TenantId}");
                }
                if (query.TenantId > 0)
                {
                    builder.Append($" AND a.{nameof(RB_Education_Article_Extend.MallBaseId)}={query.MallBaseId}");
                }
                if (query.ID > 0)
                {
                    builder.Append($" AND a.{nameof(RB_Education_Article_Extend.ID)}={query.ID}");
                }
                if (!string.IsNullOrWhiteSpace(query.Name))
                {
                    builder.Append($" AND a.{nameof(RB_Education_Article_Extend.Name)} like '%{query.Name}%'");
                }
                if (query.ArticleStatus > 0)
                {
                    builder.Append($" AND a.{nameof(RB_Education_Article_Extend.ArticleStatus)}={query.ArticleStatus}");
                }
                if (!string.IsNullOrEmpty(query.StartTime))
                {
                    builder.Append($"   and a.{nameof(RB_Education_Article_Extend.CreateDate)} >='{query.StartTime}'");
                }
                if (!string.IsNullOrEmpty(query.EndTime))
                {
                    builder.Append($"  and a.{nameof(RB_Education_Article_Extend.CreateDate)} <='{query.EndTime + " 23:59:59"}'");
                }
            }
            return GetPage<RB_Education_Article_Extend>(pageIndex, pageSize, out rowCount, builder.ToString()).ToList();
        }


        /// <summary>
        /// 网课-老师列表
        /// </summary>
        /// <param name="pageIndex">页码</param>
        /// <param name="pageSize">每页显示条数</param>
        /// <param name="rowCount">总条数</param>
        /// <param name="query">查询条件</param>
        /// <returns></returns>
        public List<RB_Education_Article_Extend> GetTeacherList(RB_Education_Article_Extend query)
        {
            StringBuilder builder = new StringBuilder();
            builder.Append($" SELECT * FROM {TableName} WHERE  {nameof(RB_Education_Article_Extend.Status)}=0");
            if (query != null)
            {
                if (query.TenantId > 0)
                {
                    builder.Append($" AND {nameof(RB_Education_Article_Extend.TenantId)}={query.TenantId}");
                }
                if (query.TenantId > 0)
                {
                    builder.Append($" AND {nameof(RB_Education_Article_Extend.MallBaseId)}={query.MallBaseId}");
                }
                if (query.ID > 0)
                {
                    builder.Append($" AND {nameof(RB_Education_Article_Extend.ID)}={query.ID}");
                }
                if (!string.IsNullOrWhiteSpace(query.Name))
                {
                    builder.Append($" AND {nameof(RB_Education_Article_Extend.Name)} like '%{query.Name}%'");
                }
                if (query.ArticleStatus > 0)
                {
                    builder.Append($" AND {nameof(RB_Education_Article_Extend.ArticleStatus)}={query.ArticleStatus}");
                }
                if (!string.IsNullOrEmpty(query.StartTime))
                {
                    builder.Append($"   and g.{nameof(RB_Education_Article_Extend.CreateDate)} >='{query.StartTime}'");
                }
                if (!string.IsNullOrEmpty(query.EndTime))
                {
                    builder.Append($"  and g.{nameof(RB_Education_Article_Extend.CreateDate)} <='{query.EndTime + " 23:59:59"}'");
                }
            }
            return Get<RB_Education_Article_Extend>(builder.ToString()).ToList();
        }
    }
}
