﻿using System;
using System.Collections.Generic;
using System.Text;
using Mall.Model.Entity.Product;
using Mall.Model.Extend.Product;
using System.Linq;

namespace Mall.Repository.Product
{
    /// <summary>
    /// 商品关联讲师仓储层
    /// </summary>
    public class RB_Goods_WK_TeacherRepository : BaseRepository<RB_Goods_WK_Teacher>
    {

        /// <summary>
        /// 列表
        /// </summary>
        /// <param name="dmodel">查询条件</param>
        /// <returns></returns>
        public List<RB_Goods_WK_Teacher_Extend> GetList(RB_Goods_WK_Teacher_Extend dmodel)
        {
            string where = $" 1=1 and gc.{nameof(RB_Goods_WK_Teacher.Status)}=0";
            if (dmodel.TenantId > 0) {
                where += $@" and gc.{nameof(RB_Goods_WK_Teacher.TenantId)}={dmodel.TenantId}";
            }
            if (dmodel.MallBaseId > 0) {
                where += $@" and gc.{nameof(RB_Goods_WK_Teacher.MallBaseId)}={dmodel.MallBaseId}";
            }
            if (dmodel.Id > 0) {
                where += $@" and gc.{nameof(RB_Goods_WK_Teacher.Id)}={dmodel.Id}";
            }
            if (dmodel.GoodsId > 0) {
                where += $@" and gc.{nameof(RB_Goods_WK_Teacher.GoodsId)}={dmodel.GoodsId}";
            }
            if (!string.IsNullOrEmpty(dmodel.GoodsIds)) {
                where += $@" and gc.{nameof(RB_Goods_WK_Teacher.GoodsId)} in({dmodel.GoodsIds})";
            }
            if (dmodel.TeacherId > 0) {
                where += $@" and gc.{nameof(RB_Goods_WK_Teacher.TeacherId)}={dmodel.TeacherId}";
            }
            
            string sql = $@"
SELECT gc.*,pc.Name
FROM RB_Goods_WK_Teacher gc inner join rb_education_teacher pc on gc.TeacherId=pc.Id
WHERE {where} ORDER BY gc.Id asc ";
            return Get<RB_Goods_WK_Teacher_Extend>(sql).ToList();
        }
    }
}
