﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Linq.Expressions;
using System.Text;
using System.Threading.Tasks;

namespace DapperExtensions.Lambda
{
    /// <summary>
    /// 查询泛型接口
    /// </summary>
    /// <typeparam name="T"></typeparam>
    public interface ISelect<T> : ISelect where T : class
    {
        /// <summary>
        /// 添加查询
        /// </summary>
        /// <param name="lambdaSelect">表达式</param>
        void AddSelect(Expression<Func<T, bool>> lambdaSelect);

        /// <summary>
        /// 添加查询
        /// </summary>
        /// <typeparam name="T2">约束</typeparam>
        /// <param name="lambdaSelect">表达式</param>
        void AddSelect<T2>(Expression<Func<T, T2, bool>> lambdaSelect);

        /// <summary>
        /// 添加查询
        /// </summary>
        /// <typeparam name="T2">约束</typeparam>
        /// <typeparam name="T3">约束</typeparam>
        /// <param name="lambdaSelect">表达式</param>
        void AddSelect<T2, T3>(Expression<Func<T, T2, T3, bool>> lambdaSelect);

        /// <summary>
        /// 添加查询
        /// </summary>
        /// <typeparam name="T2">约束</typeparam>
        /// <typeparam name="T3">约束</typeparam>
        /// <typeparam name="T4">约束</typeparam>
        /// <param name="lambdaSelect">表达式</param>
        void AddSelect<T2, T3, T4>(Expression<Func<T, T2, T3, T4, bool>> lambdaSelect);

        /// <summary>
        /// 添加查询
        /// </summary>
        /// <typeparam name="T2">约束</typeparam>
        /// <typeparam name="T3">约束</typeparam>
        /// <typeparam name="T4">约束</typeparam>
        /// <typeparam name="T5">约束</typeparam>
        /// <param name="lambdaSelect">表达式</param>
        void AddSelect<T2, T3, T4, T5>(Expression<Func<T, T2, T3, T4, T5, bool>> lambdaSelect);

        /// <summary>
        /// 添加查询
        /// </summary>
        /// <typeparam name="T2">约束</typeparam>
        /// <typeparam name="T3">约束</typeparam>
        /// <typeparam name="T4">约束</typeparam>
        /// <typeparam name="T5">约束</typeparam>
        /// <typeparam name="T6">约束</typeparam>
        /// <param name="lambdaSelect">表达式</param>
        void AddSelect<T2, T3, T4, T5, T6>(Expression<Func<T, T2, T3, T4, T5, T6, bool>> lambdaSelect);

        /// <summary>
        /// 添加查询
        /// </summary>
        /// <param name="lambdaSelect"></param>
        void AddSelect(Expression<Func<T, object>> lambdaSelect);

        /// <summary>
        /// 添加查询
        /// </summary>
        /// <typeparam name="T2">约束</typeparam>
        /// <param name="lambdaSelect">表达式</param>
        void AddSelect<T2>(Expression<Func<T, T2, object>> lambdaSelect);

        /// <summary>
        /// 添加查询
        /// </summary>
        /// <typeparam name="T2">约束</typeparam>
        /// <typeparam name="T3">约束</typeparam>
        /// <param name="lambdaSelect">表达式</param>
        void AddSelect<T2, T3>(Expression<Func<T, T2, T3, object>> lambdaSelect);

        /// <summary>
        /// 添加查询
        /// </summary>
        /// <typeparam name="T2">约束</typeparam>
        /// <typeparam name="T3">约束</typeparam>
        /// <typeparam name="T4">约束</typeparam>
        /// <param name="lambdaSelect">表达式</param>
        void AddSelect<T2, T3, T4>(Expression<Func<T, T2, T3, T4, object>> lambdaSelect);

        /// <summary>
        /// 添加查询
        /// </summary>
        /// <typeparam name="T2">约束</typeparam>
        /// <typeparam name="T3">约束</typeparam>
        /// <typeparam name="T4">约束</typeparam>
        /// <typeparam name="T5">约束</typeparam>
        /// <param name="lambdaSelect">表达式</param>
        void AddSelect<T2, T3, T4, T5>(Expression<Func<T, T2, T3, T4, T5, object>> lambdaSelect);

        /// <summary>
        /// 添加查询
        /// </summary>
        /// <typeparam name="T2">约束</typeparam>
        /// <typeparam name="T3">约束</typeparam>
        /// <typeparam name="T4">约束</typeparam>
        /// <typeparam name="T5">约束</typeparam>
        /// <typeparam name="T6">约束</typeparam>
        /// <param name="lambdaSelect">表达式</param>
        void AddSelect<T2, T3, T4, T5, T6>(Expression<Func<T, T2, T3, T4, T5, T6, object>> lambdaSelect);
    }

    /// <summary>
    /// 查询接口
    /// </summary>
    public interface ISelect
    {
        /// <summary>
        /// 字段集合
        /// </summary>
        List<Field> Fields { get; }

        /// <summary>
        /// 新增查询
        /// </summary>
        /// <param name="fields">字段数组</param>
        void AddSelect(params Field[] fields);
    }
}