﻿using System;
using System.Collections.Generic;
using System.Text;
using Mall.Common.Enum;
using Mall.Common.Enum.Goods;
using Mall.Common.Enum.User;
using VT.FW.DB;

namespace Mall.Model.Entity.Education
{
    /// <summary>
    /// 商会活动报名实体类
    /// </summary>
    [Serializable]
    [DB(ConnectionName = "DefaultConnection")]
    public class RB_Education_Consult
    {
        /// <summary>
        /// 主键编号
        /// </summary>
        public int Id { get; set; }

        /// <summary>
        /// 活动编号
        /// </summary>
        public int ActivityId { get; set; }

        /// <summary>
        /// 用户编号
        /// </summary>
        public int UserId { get; set; }

        /// <summary>
        /// 联系人
        /// </summary>
        public string LinkMan { get; set; }

        /// <summary>
        /// 联系电话
        /// </summary>
        public string LinkTel { get; set; }

        /// <summary>
        /// 商户号id
        /// </summary>
        public int TenantId { get; set; }

        /// <summary>
        /// 小程序id
        /// </summary>
        public int MallBaseId { get; set; }

        /// <summary>
        /// 报名时间
        /// </summary>
        public DateTime CreateTime { get; set; }

        /// <summary>
        /// 删除状态
        /// </summary>
        public DateStateEnum Status { get; set; }

        /// <summary>
        /// 报名人数
        /// </summary>
        public int PeopleNum { get; set; }

        /// <summary>
        /// 性别
        /// </summary>

        public int Sex { get; set; }

        /// <summary>
        /// 单价
        /// </summary>
        public decimal UnitPrice { get; set; }

        /// <summary>
        /// 应收金额
        /// </summary>
        public decimal Money { get; set; }


        /// <summary>
        /// 实收金额
        /// </summary>
        public decimal Income { get; set; }

        /// <summary>
        /// 手续费
        /// </summary>
        public decimal PlatformTax { get; set; }
        /// <summary>
        /// 备注
        /// </summary>
        public string Remark { get; set; }

        /// <summary>
        /// 是否申请取消  1是  2否
        /// </summary>
        public int IsApplyForCancel { get; set; }

        /// <summary>
        /// 取消备注
        /// </summary>
        public string CancelRemark { get; set; }

        /// <summary>
        /// 申请取消审核状态  1同意  2拒绝
        /// </summary>
        public int ApplyForCancelStatus { get; set; }

        /// <summary>
        /// 拒绝备注
        /// </summary>
        public string RejectRemark { get; set; }


        /// <summary>
        /// 点数（单价）
        /// </summary>
        public int UnitPoint { get; set; }

        /// <summary>
        /// 总点数
        /// </summary>
        public int TotalPoint { get; set; }

        /// <summary>
        /// 0-未支付，1-已支付
        /// </summary>
        public int OrderStatus { get; set; }

        /// <summary>
        /// 现金支付时间
        /// </summary>
        public DateTime? PaymentTime { get; set; }

        /// <summary>
        /// 退款单号
        /// </summary>
        public string RefundOrderNo { get; set; }


        /// <summary>
        /// 实际退款金额
        /// </summary>
        public decimal RefundPrice { get; set; }

        /// <summary>
        /// 退款时间
        /// </summary>
        public DateTime? RefundTime { get; set; }

        /// <summary>
        /// 订单来源（平台）  枚举
        /// </summary>        
        public UserSourceEnum? OrderSource
        {
            get;
            set;
        }
        /// <summary>
        /// 支付方式   枚举
        /// </summary>        
        public OrderPaymentTypeEnum? PaymentWay
        {
            get;
            set;
        }

        public Common.Enum.Goods.OrderPayTypeEnum? PayWay { get; set; }
        /// <summary>
        /// 订单号
        /// </summary>        
        public string OrderNo
        {
            get;

            set;
        }
        /// <summary>
        /// 商户单号
        /// </summary>        
        public string MerchantsNo
        {
            get;
            set;
        }

        /// <summary>
        /// 是否需取消确认   1是  2否
        /// </summary>
        public int IsCancelConfirm { get; set; }

        /// <summary>
        /// 教育销售id
        /// </summary>
        public int EduUserId { get; set; }


        /// <summary>
        /// 教育学生id
        /// </summary>
        public int EduStudentId { get; set; }



        /// <summary>
        /// 用户id，所有的父级，英文逗号分隔
        /// </summary>
        public string UserTree { get; set; }

        /// <summary>
        /// 分销商id，所有的父级分销商，英文逗号分隔
        /// </summary>
        public string DistributorTree { get; set; }

        /// <summary>
        /// 是否点名，1-没有，2-是
        /// </summary>
        public int IsRollCall { get; set; }

        /// <summary>
        /// 是否提成，1-没有，2-是
        /// </summary>
        public int IsCommission { get; set; }

        /// <summary>
        /// 提成金额
        /// </summary>
        public decimal CommissionPrice { get; set; }


        /// <summary>
        /// 0-甲鹤，1-甲小鹤
        /// </summary>
        public int WeiXinType { get; set; }


    }
}
