﻿using System;
using System.Collections.Generic;
using System.Text;
using Mall.Common.Enum.MiAi;
using VT.FW.DB;

namespace Mall.Model.Entity.Miai
{

    /// <summary>
    /// 查询相亲会员基础资料
    /// </summary>
    [Serializable]
    [DB(ConnectionName = "DefaultConnection")]
    public class RB_MiAi_BaseInfoQuery
    {
        /// <summary>
        /// 编号
        /// </summary>        
        public int Id
        {
            get;
            set;
        }
        /// <summary>
        /// 会员id
        /// </summary>
        public int UserId { get; set; }



        /// <summary>
        /// 商户号Id
        /// </summary>        
        public int? TenantId
        {
            get;
            set;
        }

        /// <summary>
        /// 小程序Id
        /// </summary>        
        public int? MallBaseId
        {
            get;
            set;
        }


        /// <summary>
        /// 创建时间
        /// </summary>        
        public DateTime? CreateDate
        {
            get;
            set;
        }



        /// <summary>
        /// 删除状态
        /// </summary>        
        public int? Status
        {
            get;
            set;
        }

        /// <summary>
        /// 性别1-男，2-女
        /// </summary>
        public int Sex { get; set; }

        /// <summary>
        /// 年龄
        /// </summary>
        public int Age { get; set; }

        /// <summary>
        /// 年龄
        /// </summary>
        public int EndAge { get; set; }

        /// <summary>
        /// 身高
        /// </summary>
        public decimal Height { get; set; }


        /// <summary>
        /// 身高
        /// </summary>
        public decimal EndHeight { get; set; }
        /// <summary>
        /// 体重
        /// </summary>
        public decimal Weight { get; set; }

        /// <summary>
        /// 体重
        /// </summary>
        public decimal EndWeight { get; set; }

        /// <summary>
        /// 年收入
        /// </summary>
        public decimal YearMoney { get; set; }


        /// <summary>
        /// 年收入
        /// </summary>
        public decimal EndYearMoney { get; set; }

        /// <summary>
        /// 车
        /// </summary>
        public CarInfoEnum? CarInfo { get; set; }


        /// <summary>
        /// 房屋信息
        /// </summary>
        public HouseInfoEnum? HouseInfo { get; set; }


        /// <summary>
        /// 学历
        /// </summary>
        public EducationTypeEnum? EducationType { get; set; }


        /// <summary>
        /// 婚姻
        /// </summary>
        public MarriageEnum? Marriage { get; set; }
    }
}
